### Name: PFAMCAZY2AC
### Title: Mappings from an ID to a PFAM Accession number
### Aliases: PFAMCAZY2AC PFAMDE2AC PFAMID2AC PFAMHOMSTRAD2AC
###   PFAMINTERPRO2AC PFAMLOAD2AC PFAMMEROPS2AC PFAMMIM2AC PFAMPFAMB2AC
###   PFAMPRINTS2AC PFAMPROSITE2AC PFAMPROSITEPROFILE2AC PFAMRM2AC
###   PFAMSMART2AC PFAMTC2AC PFAMTP2AC PFAMURL2AC
### Keywords: datasets

### ** Examples

        #To map from CAZY to PFAM IDs:
        x <- PFAMCAZY2AC
        # Get the CAZY identifiers that are mapped to a PFAM ID
        mapped_keys <- mappedkeys(x)
        # Convert to a list
        xx <- as.list(x[mapped_keys])
        if(length(xx) > 0) {
          # Get the PFAM ID for the first five CAZYs
          xx[1:5]
          # Get the first one
          xx[[1]]
        }

        #Or to use the DE2AC mapping:
        x <- PFAMDE2AC
        # Get the Descriptions that are mapped to a PFAM ID
        mapped_keys <- mappedkeys(x)
        # Convert to a list
        xx <- as.list(x[mapped_keys])
        if(length(xx) > 0) {
          # Get the PFAM ID for the first five DEs
          xx[1:5]
          # Get the first one
          xx[[1]]
        }

        #etc.



