### Name: PFAMCAZY
### Title: Mappings from a PFAM Accession number to another kind of ID
### Aliases: PFAMCAZY PFAMDE PFAMID PFAMHOMSTRAD PFAMINTERPRO PFAMLOAD
###   PFAMMEROPS PFAMMIM PFAMPFAMB PFAMPRINTS PFAMPROSITE
###   PFAMPROSITEPROFILE PFAMRM PFAMSMART PFAMTC PFAMTP PFAMURL
### Keywords: datasets

### ** Examples

        #To map from PFAM to CAZYs:
        x <- PFAMCAZY
        # Get the PFAM identifiers that are mapped to a CAZY
        mapped_keys <- mappedkeys(x)
        # Convert to a list
        xx <- as.list(x[mapped_keys])
        if(length(xx) > 0) {
          # Get the CAZY for the first five PFAM IDs
          xx[1:5]
          # Get the first one
          xx[[1]]
        }

        #Or to use the DE mapping:
        x <- PFAMDE
        # Get the PFAM identifiers that are mapped to a DE
        mapped_keys <- mappedkeys(x)
        # Convert to a list
        xx <- as.list(x[mapped_keys])
        if(length(xx) > 0) {
          # Get the DE for the first five PFAM IDs
          xx[1:5]
          # Get the first one
          xx[[1]]
        }

        #etc.



