### Name: Hs6UG171PMID
### Title: Map between Manufacturer Identifiers and PubMed Identifiers
### Aliases: Hs6UG171PMID
### Keywords: datasets

### ** Examples

        x <- Hs6UG171PMID
        # Get the probe identifiers that are mapped to any PubMed ID
        mapped_probes <- mappedkeys(x)
        # Convert to a list
        xx <- as.list(x[mapped_probes])
    if(length(xx) > 0){
        # Get the PubMed identifiers for the first two probe identifiers
        xx[1:2]
        # Get the first one
        xx[[1]]
        if(interactive() && !is.null(xx[[1]]) && !is.na(xx[[1]])
           && require(annotate)){
            # Get article information as XML files
            xmls <- pubmed(xx[[1]], disp = "data")
            # View article information using a browser
            pubmed(xx[[1]], disp = "browser")
        }
    }



