### Name: import.genome.scheme
### Title: Import CLF, PGF and annotation files into a SchemeTreeSet
### Aliases: import.genome.scheme
### Keywords: manip

### ** Examples

## Not run: 
##D ## define paths
##D scmdir <- "/common/path/schemes"
##D libdir <- "/my/path/Affy/libraryfiles"
##D anndir <- "/my/path/Affy/Annotation"
##D 
##D ## create scheme for HuGene-1_0-st-v1 whole genome array
##D scheme.hugene10stv1r3.na23 <- import.genome.scheme("Scheme_HuEx10stv1r3_na23",filedir=scmdir,
##D                               layoutfile=paste(libdir,"HuGene-1_0-st-v1.r3.analysis_libraryfile/HuGene-1_0-st-v1.r3.clf",sep="/"),
##D                               schemefile=paste(libdir,"HuGene-1_0-st-v1.r3.analysis_libraryfile/HuGene-1_0-st-v1.r3.pgf",sep="/"),
##D                               transcript=paste(anndir,"HuGene-1_0-st-v1.na23.hg18.transcript.csv",sep="/"))
##D 
##D ## access ROOT scheme file from new R session
##D scheme.hugene10stv1r3 <- root.scheme(paste(scmdir,"Scheme_HuEx10stv1r3_na23.root",sep="/"))
## End(Not run)



