### Name: snp.pre
### Title: Pre- or post-multiply a snp.matrix object by a general matrix
### Aliases: snp.pre snp.post
### Keywords: array multivariate

### ** Examples

##--
##-- Calculate first two principal components and their loading, and verify
##--    
# Make a snp.matrix with a small number of rows
data(testdata)
small <- Autosomes[1:20,]
# Calculate the X.X-transpose matrix
xx <- xxt(small, correct.for.missing=FALSE)
# Calculate the first two principal components and corresponding eigenvalues
eigvv <- eigen(xx, symmetric=TRUE)
pc <- eigvv$vectors[,1:2]
ev <- eigvv$values[1:2]
# Calculate loadings for first two principal components
Dinv <- diag(1/sqrt(ev))
loadings <- snp.pre(small,  Dinv %*% t(pc))
# Now apply loadings back to recalculate the principal components
pc.again <- snp.post(small, t(loadings) %*% Dinv)
print(cbind(pc, pc.again))



