### Name: DEResult
### Title: Class DEResult
### Aliases: class:DEResult DEResult DEResult-class statistic statistic<-
###   FC FC<- statisticDescription statisticDescription<- DEMethod
###   DEMethod<- pLikeValues topGenes topGeneIDs numberOfProbesets
###   numberOfGenes numberOfContrasts statistic,DEResult-method
###   statistic<-,DEResult,matrix-method FC,DEResult-method
###   FC<-,DEResult,matrix-method statisticDescription,DEResult-method
###   statisticDescription<-,DEResult,character-method
###   DEMethod,DEResult-method DEMethod<-,DEResult,character-method
###   pLikeValues,DEResult-method topGenes,DEResult-method
###   topGeneIDs,DEResult-method numberOfProbesets,DEResult-method
###   numberOfGenes,DEResult-method numberOfContrasts,DEResult-method
###   show,DEResult-method write.reslts,DEResult-method
### Keywords: classes

### ** Examples

## Create an example DEResult object
data(affybatch.example)
varLabels(affybatch.example) <- "level"
pData(affybatch.example) <- data.frame("level"=c("twenty","twenty","ten")
    , "batch"=c("A","B","A"), row.names=rownames(pData(affybatch.example)))
eset_mmgmos <- mmgmos(affybatch.example)
eset_comb <- pumaComb(eset_mmgmos)
esetDE <- pumaDE(eset_comb)

## Use some of the methods
statisticDescription(esetDE)
DEMethod(esetDE)
numberOfProbesets(esetDE)
numberOfContrasts(esetDE)
topGenes(esetDE)
topGenes(esetDE, 3)
pLikeValues(esetDE)[topGenes(esetDE,3)]
topGeneIDs(esetDE, 3)
topGeneIDs(esetDE, 3, direction="down")

## save the expression results into files
write.reslts(esetDE, file="example")



