### Name: getRelevantEGenes
### Title: Automatic selection of most relevant S-genes
### Aliases: getRelevantEGenes selectEGenes filterEGenes
### Keywords: models

### ** Examples

   # Drosophila RNAi and Microarray Data from Boutros et al, 2002
   data("BoutrosRNAi2002")
   D <- BoutrosRNAiDiscrete[,9:16]

   # enumerate all possible models for 4 genes
   models <- enumerate.models(unique(colnames(D)))  
   
   getRelevantEGenes(models[[64]], D, para=c(.13,.05), type="mLL")




