###################################################
### chunk number 1: loadPackage
###################################################
library(flowViz)


###################################################
### chunk number 2: 
###################################################
data(GvHD)


###################################################
### chunk number 3: 
###################################################
n2gate <- norm2Filter("SSC-H", "FSC-H")
rgate <- rectangleGate("FSC-H"=c(5.5, 7),"SSC-H"=c(4, 6.5))
n2gate.results <- filter(GvHD, n2gate)
## n2gate.results <- filter(GvHD, n2gate %on% transform("SSC-H"=asinh,"FSC-H"=asinh))


###################################################
### chunk number 4: 
###################################################
xyplot(`SSC-H` ~ `FSC-H` | Visit, data = GvHD,
       filter = n2gate, displayFilter = TRUE,
       subset = Patient == "6")


###################################################
### chunk number 5: 
###################################################
plot(trellis.last.object())


###################################################
### chunk number 6: 
###################################################
xyplot(`SSC-H` ~ `FSC-H` | Visit,
       data = transform("SSC-H"=asinh,"FSC-H"=asinh) %on% GvHD,
       smooth = FALSE, alpha = 0.1,
       filter = n2gate,
       displayFilter = list(lwd = 2),
       subset = Patient == "6")
##


###################################################
### chunk number 7: 
###################################################
plot(trellis.last.object())


###################################################
### chunk number 8: 
###################################################
xyplot(`SSC-H` ~ `FSC-H` | Patient:Visit,
       data = transform("SSC-H"=asinh,"FSC-H"=asinh) %on% GvHD,
       subset = Patient == "6",
       filter = rgate)
##


###################################################
### chunk number 9: 
###################################################
plot(trellis.last.object())


###################################################
### chunk number 10: 
###################################################
xyplot(`SSC-H` ~ `FSC-H` | Visit,
       data = transform("SSC-H"=asinh,"FSC-H"=asinh) %on% GvHD,
       subset = Patient == "6",
       filterResults = n2gate.results,
       smooth = FALSE, alpha = 0.1)
##


###################################################
### chunk number 11: 
###################################################
plot(trellis.last.object())


###################################################
### chunk number 12: 
###################################################
xyplot(`SSC-H` ~ `FSC-H` | Visit,
       data = transform("SSC-H"=asinh,"FSC-H"=asinh) %on% GvHD,
       subset = Patient == "6",
       filterResults = n2gate.results,
       filter = n2gate,
       smooth = FALSE, alpha = 0.1)
##


###################################################
### chunk number 13: 
###################################################
plot(trellis.last.object())


###################################################
### chunk number 14: 
###################################################
xyplot(`SSC-H` ~ `FSC-H` | Visit,
       data = transform("SSC-H"=asinh,"FSC-H"=asinh) %on% GvHD,
       subset = Patient == "6",
       smooth = FALSE, alpha = 0.1,
       filter = rectangleGate("FSC-H"=c(5.5, 7),"SSC-H"=c(4, 6.5)),
       filterResults = n2gate.results,
       displayFilter = list(border = 'red'))
##


###################################################
### chunk number 15: 
###################################################
plot(trellis.last.object())


###################################################
### chunk number 16: 
###################################################
xyplot(asinh(`FL3-H`) ~ asinh(`FL1-H`) | Visit, data = GvHD,
       subset = Patient == "6",
       smooth = FALSE, alpha = 0.1,
       filter = rectangleGate("FSC-H"=c(5.5, 7),"SSC-H"=c(4, 6.5)),
       filterResults = n2gate.results,
       displayFilter = list(border = 'red'))
##


###################################################
### chunk number 17: 
###################################################
plot(trellis.last.object())


###################################################
### chunk number 18: 
###################################################
parallel(~ . | Visit, 
         data =
         transform("SSC-H"=asinh,"FSC-H"=asinh, "FL1-H"=asinh,
                   "FL2-H"=asinh, "FL3-H"=asinh, "FL2-A"=asinh,
                   "FL4-H"=asinh) %on% GvHD,
         subset = Patient == "6",
         filterResults = n2gate.results,
         alpha = 0.01)
##


###################################################
### chunk number 19: 
###################################################
plot(trellis.last.object())


