### Name: writeQAReport
### Title: Create HTML report for (lists of) qaProcess objects
### Aliases: writeQAReport
### Keywords: IO dynamic

### ** Examples

## Not run: 
##D data(GvHD)
##D GvHD <- transform(GvHD, "FL1-H"=asinh(`FL1-H`), "FL2-H"=asinh(`FL2-H`))
##D dest <- tempdir()
##D qp1 <- qaProcess.timeline(GvHD, channel="FL1-H", outdir=dest, cutoff=1)
##D qp2 <- qaProcess.marginevents(GvHD, channels=c("FL1-H", "FL2-H"),
##D   outdir=dest, cFactor=4)
##D writeQAReport(GvHD, processes=list(qp1, qp2), outdir=dest,
##D   grouping="Patient")
##D browseURL(file.path(dest, "index.html"))
## End(Not run)



