###################################################
### chunk number 1: 
###################################################
library("annotate")
library("hsahomology")
hsahomology()


###################################################
### chunk number 2: 
###################################################
homoGenes <- LL2homology("hsahomology", "25")


###################################################
### chunk number 3: 
###################################################
names(homoGenes[[1]][[1]])


###################################################
### chunk number 4: 
###################################################
## A given LocusLink id may be mapped to more than one HGID. Use the
## data for the first one here
goodG <- sapply(homoGenes[[1]], function(x){
    (x[["homoType"]] == "B" && x[["homoPS"]] > 80.00)})

geneList <- homoGenes[[1]][goodG]
sapply(geneList, function(x) x[["homoOrg"]])
sapply(geneList, function(x) x[["homoHGID"]])


###################################################
### chunk number 5: 
###################################################
library("xlahomology")
subset(xlahomologyORGCODE, species_name == "Danio rerio")


###################################################
### chunk number 6: 
###################################################
temp <- mget(xlahomologyHGID, xlahomologyDATA)
tempFun <- function(x){
   for(i in x){
       if(!is.na(i[["homoOrg"]]) && i[["homoOrg"]] == "dre"
          && i[["homoPS"]] > 90.00){
           return(i)
       }
   }
   return(NA)
}
goodGenes <- sapply(temp, tempFun)
goodGenes <- goodGenes[!is.na(goodGenes)]


###################################################
### chunk number 7: 
###################################################
## Get the HGIDs
hgids <- unlist(sapply(goodGenes, function(x) x[["homoHGID"]]))
## Get the percent similarities
ps <- unlist(sapply(goodGenes, function(x) x[["homoPS"]]))


###################################################
### chunk number 8: 
###################################################
toLatex(sessionInfo())


