###################################################
### chunk number 1: intro1
###################################################
library(MASS)
data(crabs)
dim(crabs)
crabs[1:4,]
table(crabs$sex)


###################################################
### chunk number 2: dolat
###################################################
library(lattice)
print(bwplot(RW~sp|sex, data=crabs))


###################################################
### chunk number 3: dop
###################################################
m1 = glm(sp~RW, data=crabs, fam=binomial)
summary(m1)


###################################################
### chunk number 4: domods
###################################################
table(predict(m1,type="response")>.5, crabs$sp)
m2 = update(m1, subset=sex=="F")
table(predict(m2,type="response")>.5, crabs$sp[crabs$sex=="F"])


###################################################
### chunk number 5: doml1
###################################################
library(MLInterfaces)
fcrabs = crabs[crabs$sex == "F", ]
ml1 = MLearn( sp~RW, fcrabs, glmI.logistic(thresh=.5), c(1:30, 51:80), family=binomial)
ml1
confuMat(ml1)


###################################################
### chunk number 6: doscra
###################################################
set.seed(123)
sfcrabs = fcrabs[ sample(1:100, size=100, replace=FALSE),  ]


###################################################
### chunk number 7: domods
###################################################
sml1 = MLearn( sp~RW, sfcrabs, glmI.logistic(thresh=.5), c(1:30, 51:80), family=binomial)
confuMat(sml1)
smx1 = MLearn( sp~RW, sfcrabs, glmI.logistic(thresh=.5), xvalSpec("LOG",
   5, function(data, clab, iternum) { which(rep(1:5, each=20) == iternum) }), family=binomial)
confuMat(smx1)


###################################################
### chunk number 8: dopa
###################################################
pairs(crabs[,-c(1:3)], col=ifelse(crabs$sp=="B", "blue", "orange"))


###################################################
### chunk number 9: dopc
###################################################
pc1 = prcomp( crabs[,-c(1:3)] )


###################################################
### chunk number 10: lkpc
###################################################
pairs(pc1$x, col=ifelse(crabs$sp=="B", "blue", "orange"))


###################################################
### chunk number 11: dobi
###################################################
biplot(pc1, choices=2:3)


###################################################
### chunk number 12: dohm
###################################################
X = data.matrix(crabs[,-c(1:3)])
heatmap(t(X), ColSideColors=ifelse(crabs$sp=="O", "orange", "blue"))


###################################################
### chunk number 13: docl
###################################################
cl = hclust(dist(X))
tr = cutree(cl,2)
table(tr)


###################################################
### chunk number 14: dos
###################################################
library(cluster)
sil = silhouette( tr, dist(X) )
plot(sil)


###################################################
### chunk number 15: newes
###################################################
feat2 = t(data.matrix(crabs[, -c(1:3)]))
pd2 = new("AnnotatedDataFrame", crabs[,1:2])
crES = new("ExpressionSet", exprs=feat2, phenoData=pd2)
crES$spsex = paste(crES$sp, crES$sex, sep=":")
table(crES$spsex)


###################################################
### chunk number 16: doper
###################################################
set.seed(1234)
crES = crES[ , sample(1:200, size=200, replace=FALSE)]


###################################################
### chunk number 17: dotr
###################################################
library(rpart)
tr1 = MLearn(spsex~., crES, "rpart", 1:140)
tr1
confuMat(tr1)


###################################################
### chunk number 18: doplTree
###################################################
plot(RObject(tr1))
text(RObject(tr1))


###################################################
### chunk number 19: doccp
###################################################
plotcp(RObject(tr1))


###################################################
### chunk number 20: dorf
###################################################
set.seed(124)
library(randomForest)
rf1 = MLearn(spsex~., crES, "randomForest", 1:140 )
rf1
cm = confuMat(rf1)
cm


###################################################
### chunk number 21: dold
###################################################
ld1 = MLearn(spsex~., crES, "lda", 1:140 )
ld1
confuMat(ld1)
xvld = MLearn( spsex~., crES, ldaI, xvalSpec("LOG", 5, balKfold.xvspec(5)))
confuMat(xvld)


###################################################
### chunk number 22: dnn
###################################################
nn1 = MLearn(spsex~., crES, nnetI, 1:140, size=3, decay=.1)
nn1
RObject(nn1)
confuMat(nn1)


###################################################
### chunk number 23: doxx
###################################################
xvnnBAD = MLearn( spsex~., crES, nnetI, 
    xvalSpec("LOG", 5, function(data, clab, iternum) {
      which( rep(1:5,each=40) == iternum ) }),
      size=3, decay=.1 )
xvnnGOOD = MLearn( spsex~., crES, nnetI, 
    xvalSpec("LOG", 5, balKfold.xvspec(5) ),
      size=3, decay=.1 )


###################################################
### chunk number 24: lktann
###################################################
confuMat(xvnnBAD)
confuMat(xvnnGOOD)


###################################################
### chunk number 25: dnn
###################################################
sv1 = MLearn(spsex~., crES, svmI, 1:140)
sv1
RObject(sv1)
confuMat(sv1)


###################################################
### chunk number 26: doxxs
###################################################
xvsv = MLearn( spsex~., crES, svmI, xvalSpec("LOG", 5,
    balKfold.xvspec(5)))


###################################################
### chunk number 27: lktasv
###################################################
confuMat(xvsv)


###################################################
### chunk number 28: setupALL
###################################################
library(ALL)
data(ALL)
bALL = ALL[, substr(ALL$BT,1,1) == "B"]
fus = bALL[, bALL$mol.biol %in% c("BCR/ABL", "NEG")]
fus$mol.biol = factor(fus$mol.biol)
fus


###################################################
### chunk number 29: getq
###################################################
mads = apply(exprs(fus),1,mad)
fusk = fus[ mads > sort(mads,decr=TRUE)[300], ]
fcol = ifelse(fusk$mol.biol=="NEG", "green", "red")


###################################################
### chunk number 30: dohALL eval=FALSE
###################################################
## heatmap(exprs(fusk), ColSideColors=fcol)


###################################################
### chunk number 31: dopcALL
###################################################
PCg = prcomp(t(exprs(fusk)))


###################################################
### chunk number 32: lkscre
###################################################
plot(PCg)


###################################################
### chunk number 33: lkprALL
###################################################
pairs(PCg$x[,1:5],col=fcol,pch=19)


###################################################
### chunk number 34: dobiALL
###################################################
biplot(PCg)


###################################################
### chunk number 35: dld
###################################################
dld1 = MLearn( mol.biol~., fusk, dldaI, 1:40 )
dld1
confuMat(dld1)
nnALL = MLearn( mol.biol~., fusk, nnetI, 1:40, size=5, decay=.01,
  MaxNWts=2000 )
confuMat(nnALL)
rfALL = MLearn( mol.biol~., fusk, randomForestI, 1:40 )
rfALL
confuMat(rfALL)


###################################################
### chunk number 36: lkrda
###################################################
rdaALL = MLearn( mol.biol~., fusk, rdacvI, 1:40 )


###################################################
### chunk number 37: lkrda2
###################################################
rdaALL
confuMat(rdaALL)


###################################################
### chunk number 38: getgl
###################################################
library(hgu95av2)
inds = as.numeric(which(RObject(rdaALL)$gene.list[,1,]>0))
saved = featureNames(fusk)[inds]
as.list(hgu95av2GENENAME)[saved[1:4]]


###################################################
### chunk number 39: getko
###################################################
library(keggorth)
data(KOgraph)
adj(KOgraph, nodes(KOgraph)[1])
EIP = getKOprobes("Environmental Information Processing")
GIP = getKOprobes("Genetic Information Processing")
length(intersect(EIP, GIP))
EIPi = setdiff(EIP, GIP)
GIP = setdiff(GIP, EIP)
EIP = EIPi
Efusk = fusk[ featureNames(fusk) %in% EIP, ]
Gfusk = fusk[ featureNames(fusk) %in% GIP, ]


###################################################
### chunk number 40: dofs
###################################################
dldFS = MLearn( mol.biol~., fusk, dldaI, xvalSpec("LOG", 5,
   balKfold.xvspec(5), fs.absT(30) ))
dldFS
confuMat(dld1)
confuMat(dldFS)


