### Name: pairwiseAlignment
### Title: Optimal Pairwise Alignment
### Aliases: pairwiseAlignment pairwiseAlignment,character,character-method
###   pairwiseAlignment,character,XString-method
###   pairwiseAlignment,XString,character-method
###   pairwiseAlignment,XString,XString-method
### Keywords: models methods

### ** Examples

  ## Nucleotide global, local, and overlap alignments
  s1 <- 
    DNAString("ACTTCACCAGCTCCCTGGCGGTAAGTTGATCAAAGGAAACGCAAAGTTTTCAAG")
  s2 <-
    DNAString("GTTTCACTACTTCCTTTCGGGTAAGTAAATATATAAATATATAAAAATATAATTTTCATC")

  # First use a constant substitution matrix
  mat <- matrix(-3, nrow = 4, ncol = 4)
  diag(mat) <- 1
  rownames(mat) <- colnames(mat) <- DNA_ALPHABET[1:4]
  globalAlign <-
    pairwiseAlignment(s1, s2, substitutionMatrix = mat, gapOpening = -5, gapExtension = -2)
  localAlign <-
    pairwiseAlignment(s1, s2, type = "local", substitutionMatrix = mat, gapOpening = -5, gapExtension = -2)
  overlapAlign <-
    pairwiseAlignment(s1, s2, type = "overlap", substitutionMatrix = mat, gapOpening = -5, gapExtension = -2)

  # Then use quality-based method for generating a substitution matrix
  pairwiseAlignment(s1, s2,
                    patternQuality = rep(c(22L, 12L), times = c(36, 18)),
                    subjectQuality = rep(c(22L, 12L), times = c(40, 20)),
                    scoreOnly = TRUE)

  ## Amino acid global alignment
  pairwiseAlignment(AAString("PAWHEAE"), AAString("HEAGAWGHEE"), substitutionMatrix = "BLOSUM50",
                    gapOpening = 0, gapExtension = -8)



