### Name: XStringViews-class
### Title: The XStringViews class
### Aliases: class:XStringViews XStringViews-class
###   initialize,XStringViews-method subject subject,XStringViews-method
###   alphabet,XStringViews-method width<-,XStringViews-method
###   nchar,XStringViews-method show,XStringViews-method
###   [[,XStringViews-method [[<-,XStringViews-method
###   ==,XStringViews,XStringViews-method ==,XStringViews,XString-method
###   ==,XStringViews,character-method ==,XString,XStringViews-method
###   ==,character,XStringViews-method !=,XStringViews,XStringViews-method
###   !=,XStringViews,XString-method !=,XStringViews,character-method
###   !=,XString,XStringViews-method !=,character,XStringViews-method
###   as.character,XStringViews-method as.matrix,XStringViews-method
###   as.list,XStringViews-method toString,XStringViews-method
### Keywords: methods classes

### ** Examples


  ## One standard way to create an XStringViews object is to use
  ## the "views" constructor:
  s <- DNAString("-CTC-N")
  v4 <- views(s, 3:0, 5:8)
  v4
  subject(v4)
  length(v4)
  start(v4)
  end(v4)
  width(v4)

  ## Attach a comment to views #3 and #4:
  desc(v4)[3:4] <- "out of limits"
  desc(v4)

  ## A more programatical way to "tag" the "out of limits" views:
  desc(v4)[start(v4) < 1 | nchar(subject(v4)) < end(v4)] <- "out of limits"
  ## or just:
  desc(v4)[nchar(v4) < width(v4)] <- "out of limits"

  ## Two equivalent ways to extract a view as an XString object:
  s2a <- v4[[2]]
  s2b <- subXString(subject(v4), start(v4)[2], end(v4)[2])
  identical(s2a, s2b) # TRUE

  ## It is an error to try to extract an "out of limits" view:
  #v4[[3]] # Error!

  v12 <- views(DNAString("TAATAATG"), -2:9, 0:11)
  v12 == DNAString("TAA")
  v12[v12 == v12[4]]
  v12[v12 == v12[1]]
  v12[3] == views(RNAString("AU"), 0, 2)

  ## Here the first view doesn't even overlap with the subject:
  views(BString("aaa--b"), -3:4, -3:4 + c(3:6, 6:3))



