### Name: IRanges-utils
### Title: IRanges utility functions
### Aliases: IRanges-utils intToRanges intToAdjacentRanges shift
###   shift,IRanges-method restrict restrict,IRanges-method narrow
###   narrow,IRanges-method narrow,NormalIRanges-method
###   narrow,numeric-method reduce reduce,IRanges-method toNormalIRanges
###   gaps gaps,IRanges-method
### Keywords: utilities

### ** Examples

  intToRanges(c(19, 5, 0, 8, 5))
  x <- intToAdjacentRanges(c(19, 5, 0, 8, 5))
  x
  shift(x, -3)
  restrict(x, start=12, end=34)
  y <- x[width(x) != 0]
  narrow(y, start=4, end=-2)
  narrow(y, start=-4, end=-2)
  narrow(y, end=5, width=3)

  x <- IRanges(start=c(-2L, 6L, 9L, -4L, 1L, 0L, -6L, 10L),
               width=c( 5L, 0L, 6L,  1L, 4L, 3L,  2L,  3L))
  reduce(x)
  toNormalIRanges(x)   # 3 ranges ordered from left to right and separated by
                       # gaps of width >= 1.
  gaps(x)
  gaps(x, start=-6, end=20)  # Regions of the -6:20 range that are not masked by 'x'.



