### R code from vignette source 'PANTHER.db.Rnw'

###################################################
### code chunk number 1: loadPkg
###################################################
library(PANTHER.db)


###################################################
### code chunk number 2: help (eval = FALSE)
###################################################
## help("PANTHER.db")


###################################################
### code chunk number 3: show
###################################################
PANTHER.db


###################################################
### code chunk number 4: availSpecies
###################################################
availablePantherSpecies(PANTHER.db)


###################################################
### code chunk number 5: setTaxID
###################################################
species(PANTHER.db) <- "HUMAN"
PANTHER.db
resetSpecies(PANTHER.db)
PANTHER.db


###################################################
### code chunk number 6: columns
###################################################
columns(PANTHER.db)


###################################################
### code chunk number 7: keytypes
###################################################
keytypes(PANTHER.db)


###################################################
### code chunk number 8: keys
###################################################
go_ids<-head(keys(PANTHER.db,keytype="GOSLIM_ID"))
go_ids


###################################################
### code chunk number 9: select
###################################################
cols <- c("FAMILY_ID","CLASS_ID")
res <- select(PANTHER.db, keys=go_ids, columns=cols,keytype="GOSLIM_ID")
head(res)


###################################################
### code chunk number 10: traverseClassTree
###################################################
term<-"PC00209"
select(PANTHER.db,term, "CLASS_TERM","CLASS_ID")

ancestors<-traverseClassTree(PANTHER.db,term,scope="ANCESTOR")
select(PANTHER.db,ancestors, "CLASS_TERM","CLASS_ID")

parents<-traverseClassTree(PANTHER.db,term,scope="PARENT")
select(PANTHER.db,parents, "CLASS_TERM","CLASS_ID")

children<-traverseClassTree(PANTHER.db,term,scope="CHILD")
select(PANTHER.db,children, "CLASS_TERM","CLASS_ID")

offspring<-traverseClassTree(PANTHER.db,term,scope="OFFSPRING")
select(PANTHER.db,offspring, "CLASS_TERM","CLASS_ID")


