## example:
##
## require(matrixStats)
## require(TxDb.Hsapiens.UCSC.hg19.knownGene)
## require(BSgenome.Hsapiens.UCSC.hg19)
## 
## TSSes <- flank(unique(transcripts(TxDb.Hsapiens.UCSC.hg19.knownGene)),1)
## values(TSSes)$OECG <- oecg(Hsapiens, TSSes)
## hist(scale(values(TSSes)$OECG), breaks=250, xlim=c(-3, 3),
##      main='Scaled observed/expected CpG% within 3kb window of TSS')
## values(TSSes)$CpG.content <- as.factor(sign(scale(values(TSSes)$OECG)))
## levels(values(TSSes)$CpG.content) <- c('Low.CpG','High.CpG') 
## TSSes.by.CpG.content <- split(TSSes, values(TSSes)$CpG.content)
## 
oecg <- function(BSgenome, GR, bp=3000, minBp=100) {
  require(BSgenome.Hsapiens.UCSC.hg19)
  require(matrixStats)
  if(!is(BSgenome, 'BSgenome')) stop('Need a genome to operate on')
  if(!is(GR, 'GRanges')) stop('Need a GRanges to operate on')
  seqmax <- seqlengths(Hsapiens)[ seqlevels(GR) ][ as.vector(seqnames(GR)) ]
  if(bp > 0) {
    resized <- resize(GR, bp, fix='center')
    if(any(start(resized)<1)) {
      start(resized)[ which(start(resized) < 1) ] <- 1 
    }
    if(any(start(resized)>seqmax)) {
      replacement <- seqmax[ which(start(resized)>seqmax) ]
      start(resized)[ which(start(resized) > seqmax) ] <- replacement
    }
    if(any(end(resized)>seqmax)) {
      replacement <- seqmax[ which(end(resized)>seqmax) ]
      end(resized)[ which(end(resized) > seqmax) ] <- replacement
    }
    seqs <- suppressWarnings(getSeq(BSgenome, resized))
  } else {
    tooSmall <- which(width(GR) < minBp)
    GR[ tooSmall ] <- resize(GR[ tooSmall], 100, fix='center')
    seqs <- suppressWarnings(getSeq(BSgenome, GR))
  }
  e <- matrixStats:::rowProds(letterFrequency(seqs,letters='GC',as.prob=T,OR=0))
  o <- dinucleotideFrequency(seqs, as.prob=T)[,'CG']
  oecg <- (o*2)/e ## expectation: Pr(GC|C,G) == Pr(CG|C,G), so normalize by 1/2
  return(oecg)
}
