### R code from vignette source 'xps.Rnw'

###################################################
### code chunk number 1: xps.Rnw:91-92
###################################################
library(xps)


###################################################
### code chunk number 2: xps.Rnw:120-121
###################################################
library(xps)


###################################################
### code chunk number 3: xps.Rnw:125-126
###################################################
celdir <- file.path(path.package("xps"), "raw")


###################################################
### code chunk number 4: xps.Rnw:131-132
###################################################
scheme.test3 <- root.scheme(file.path(path.package("xps"), "schemes", "SchemeTest3.root"))


###################################################
### code chunk number 5: xps.Rnw:136-138
###################################################
celfiles <- c("TestA1.CEL","TestA2.CEL")
data.test3 <- import.data(scheme.test3, "tmpdt_DataTest3", celdir=celdir, celfiles=celfiles, verbose=FALSE)


###################################################
### code chunk number 6: xps.Rnw:142-143
###################################################
unlist(treeNames(data.test3))


###################################################
### code chunk number 7: xps.Rnw:147-149
###################################################
celfiles <- c("TestB1.CEL","TestB2.CEL")
data.test3 <- addData(data.test3, celdir=celdir, celfiles=celfiles, verbose=FALSE)


###################################################
### code chunk number 8: xps.Rnw:155-156
###################################################
getTreeNames(rootFile(data.test3))


###################################################
### code chunk number 9: xps.Rnw:199-201
###################################################
tmp <- intensity(data.test3)
head(tmp)


###################################################
### code chunk number 10: xps.Rnw:205-206
###################################################
data.test3 <- attachInten(data.test3)


###################################################
### code chunk number 11: xps.Rnw:210-212
###################################################
tmp <- intensity(data.test3)
head(tmp)


###################################################
### code chunk number 12: xps.Rnw:217-220
###################################################
subdata.test3 <- attachInten(data.test3, c("TestB1.cel","TestA2"))
tmp <- intensity(subdata.test3)
head(tmp)


###################################################
### code chunk number 13: xps.Rnw:227-230
###################################################
data.test3 <- attachUnitNames(data.test3)
id <- transcriptID2unitID(data.test3, transcriptID="93822_at", as.list=FALSE)
id


###################################################
### code chunk number 14: xps.Rnw:234-236
###################################################
id <- symbol2unitID(data.test3, symbol="Rpl37a", as.list=FALSE)
id


###################################################
### code chunk number 15: xps.Rnw:240-242
###################################################
data <- validData(data.test3, which="pm", unitID=id)
data


###################################################
### code chunk number 16: xps.Rnw:247-248
###################################################
data.test3 <- attachMask(data.test3)


###################################################
### code chunk number 17: probesetplot
###################################################
probesetplot(data.test3, unitID="93822_at", unittype="transcript", which="both", names=c("TestA1","TestA2"), add.legend="topright")


###################################################
### code chunk number 18: xps.Rnw:263-266
###################################################
data.test3 <- removeInten(data.test3)
tmp <- intensity(data.test3)
head(tmp)


###################################################
### code chunk number 19: xps.Rnw:278-281
###################################################
library(xps)
scheme.test3 <- root.scheme(file.path(path.package("xps"), "schemes", "SchemeTest3.root"))
data.test3 <- root.data(scheme.test3, file.path(path.package("xps"),"rootdata", "DataTest3_cel.root"))


###################################################
### code chunk number 20: xps.Rnw:295-296
###################################################
data.rma <- rma(data.test3, "tmpdt_Test3RMA", verbose=FALSE)


###################################################
### code chunk number 21: xps.Rnw:307-308
###################################################
data.mas5 <- mas5(data.test3, "tmpdt_Test3MAS5", normalize=TRUE, sc=500, update=TRUE, verbose=FALSE)


###################################################
### code chunk number 22: xps.Rnw:314-316
###################################################
expr.rma  <- validData(data.rma)
expr.mas5 <- validData(data.mas5)


###################################################
### code chunk number 23: plot
###################################################
plot(expr.rma[,1],expr.mas5[,1],log="xy",xlim=c(1,20000),ylim=c(1,20000))


###################################################
### code chunk number 24: xps.Rnw:333-334
###################################################
call.mas5 <- mas5.call(data.test3,"tmpdt_Test3Call", verbose=FALSE)


###################################################
### code chunk number 25: xps.Rnw:338-339
###################################################
call.dabg <- dabg.call(data.test3,"tmpdt_Test3DABG", verbose=FALSE)


###################################################
### code chunk number 26: xps.Rnw:349-351
###################################################
pres.mas5 <- presCall(call.mas5)
head(pres.mas5)


###################################################
### code chunk number 27: xps.Rnw:354-356
###################################################
pval.mas5 <- pvalData(call.mas5)
head(pval.mas5)


###################################################
### code chunk number 28: hist
###################################################
hist(data.test3)


###################################################
### code chunk number 29: boxplot
###################################################
boxplot(data.test3, which="userinfo:fIntenQuant")


###################################################
### code chunk number 30: image
###################################################
image(data.test3, names="TestA1.cel")


###################################################
### code chunk number 31: xps.Rnw:429-431
###################################################
data.test3 <- attachMask(data.test3)
data.test3 <- attachInten(data.test3)


###################################################
### code chunk number 32: pmplot
###################################################
pmplot(data.test3)


###################################################
### code chunk number 33: xps.Rnw:447-449
###################################################
data.test3 <- removeInten(data.test3)
data.test3 <- removeMask(data.test3)


###################################################
### code chunk number 34: xps.Rnw:460-462
###################################################
data.test3 <- attachProbeContentGC(data.test3)
data.test3 <- attachMask(data.test3)


###################################################
### code chunk number 35: intensity2GCplot
###################################################
intensity2GCplot(data.test3, treename = "TestA1.cel", which="mm")


###################################################
### code chunk number 36: xps.Rnw:477-479
###################################################
data.test3 <- removeMask(data.test3)
data.test3 <- removeProbeContentGC(data.test3)


###################################################
### code chunk number 37: hist-rma
###################################################
hist(data.rma, add.legend=TRUE)


###################################################
### code chunk number 38: boxplot-rma
###################################################
boxplot(data.rma, bmar=list(b=9, cex.axis=0.8))


###################################################
### code chunk number 39: mvaplot
###################################################
mvaplot(data.rma, pch=20, ylim=c(-2,2), names="TestB1.mdp_LEVEL")


###################################################
### code chunk number 40: corplot-rma
###################################################
corplot(data.rma, add.legend=TRUE)


###################################################
### code chunk number 41: madplot-rma
###################################################
madplot(data.rma, add.legend=TRUE)


###################################################
### code chunk number 42: pcaplot-rma
###################################################
pcaplot(data.rma, group=c("GrpA","GrpA","GrpB","GrpB"), add.labels=TRUE, add.legend=TRUE)


###################################################
### code chunk number 43: xps.Rnw:594-595
###################################################
treeInfo(call.mas5, treetype="dc5", varlist ="userinfo:fPcAbsent:fPcMarginal:fPcPresent")


###################################################
### code chunk number 44: callplot
###################################################
callplot(call.mas5)


###################################################
### code chunk number 45: xps.Rnw:614-615
###################################################
rlm.all <- fitRLM(data.test3,"tmpdt_Test3RLM", qualopt="all", option="transcript", verbose=FALSE)


###################################################
### code chunk number 46: plotAffyRNAdeg-rlm
###################################################
rnadeg <- AffyRNAdeg(rlm.all)
plotAffyRNAdeg(rnadeg, add.legend=TRUE)


###################################################
### code chunk number 47: borderplot-rlm
###################################################
borderplot(rlm.all)


###################################################
### code chunk number 48: coiplot-rlm
###################################################
coiplot(rlm.all)


###################################################
### code chunk number 49: image-rlm
###################################################
image(rlm.all, type="weights", names="TestA1_raw.res", add.legend=FALSE)


###################################################
### code chunk number 50: nuseplot-rlm
###################################################
nuseplot(rlm.all, names="namepart")


###################################################
### code chunk number 51: xps.Rnw:701-702 (eval = FALSE)
###################################################
## nuseplot(rlm.all, names="namepart:normalized")


###################################################
### code chunk number 52: rleplot-rlm
###################################################
rleplot(rlm.all, names="namepart")


###################################################
### code chunk number 53: xps.Rnw:722-723 (eval = FALSE)
###################################################
## rleplot(rlm.all, names="namepart:normalized") 


###################################################
### code chunk number 54: xps.Rnw:766-768
###################################################
prefltr <- PreFilter(mad=c(0.5), lothreshold=c(7.0,0.02,"mean"), hithreshold=c(10.5,80.0,"percent"))
str(prefltr)


###################################################
### code chunk number 55: xps.Rnw:773-775
###################################################
data.rma@rootfile <- paste(path.package("xps"),"rootdata/tmp_Test3RMA.root",sep="/")
data.rma@filedir  <- paste(path.package("xps"),"rootdata",sep="/")


###################################################
### code chunk number 56: xps.Rnw:778-780
###################################################
rma.pfr <- prefilter(data.rma, "tmpdt_Test3Prefilter", getwd(),
                     filter=prefltr, minfilters=2, verbose=FALSE)


###################################################
### code chunk number 57: xps.Rnw:784-787
###################################################
tmp <- validData(rma.pfr)
head(tmp)
dim(tmp[tmp[,"FLAG"]==1,])


###################################################
### code chunk number 58: xps.Rnw:818-819
###################################################
unifltr <- UniFilter(foldchange=c(1.3,"both"), unifilter=c(0.1,"pval"))


###################################################
### code chunk number 59: xps.Rnw:826-828
###################################################
data.rma@rootfile <- paste(path.package("xps"),"rootdata/tmp_Test3RMA.root",sep="/")
data.rma@filedir  <- paste(path.package("xps"),"rootdata",sep="/")


###################################################
### code chunk number 60: xps.Rnw:831-834
###################################################
rma.ufr <- unifilter(data.rma, "tmpdt_Test3Unifilter", getwd(),
                     unifltr, group=c("GrpA","GrpA","GrpB","GrpB"),
                     xps.fltr=rma.pfr, verbose=FALSE)


###################################################
### code chunk number 61: xps.Rnw:838-840
###################################################
tmp <- validData(rma.ufr)
tmp


###################################################
### code chunk number 62: xps.Rnw:848-851
###################################################
msk <- validFilter(rma.ufr)
tmp <- validData(rma.ufr, which="UnitName")
tmp <- cbind(tmp, msk)


###################################################
### code chunk number 63: xps.Rnw:856-860
###################################################
tmp <- export.filter(rma.ufr, treetype="stt",
                     varlist="fUnitName:fName:fSymbol:fc:pval:flag",
                     as.dataframe=TRUE, verbose=FALSE)
head(tmp)


###################################################
### code chunk number 64: volcanoplot
###################################################
volcanoplot(rma.ufr, labels="fSymbol")


###################################################
### code chunk number 65: xps.Rnw:906-910 (eval = FALSE)
###################################################
## library(xps)
## libdir <- "/path/to/Affy/libraryfiles"
## anndir <- "/path/to/Affy/Annotation"
## scmdir <- "/path/to/CRAN/Workspaces/Schemes"


###################################################
### code chunk number 66: xps.Rnw:914-919 (eval = FALSE)
###################################################
## scheme.test3 <- import.expr.scheme("SchemeTest3",
##                      filedir    = scmdir,
##                      schemefile = file.path(libdir, "Test3.CDF"), 
##                      probefile  = file.path(libdir, "Test3_probe.tab"), 
##                      annotfile  = file.path(anndir, "Test3.na32.annot.csv"))


###################################################
### code chunk number 67: xps.Rnw:925-927 (eval = FALSE)
###################################################
## scmdir <- "/path/to/CRAN/Workspaces/Schemes"
## scheme.test3 <- root.scheme(file.path(scmdir,"SchemeTest3.root"))


###################################################
### code chunk number 68: xps.Rnw:946-947 (eval = FALSE)
###################################################
## scheme.test3 <- import.expr.scheme("SchemeTest3",..., add.mask=TRUE)


###################################################
### code chunk number 69: xps.Rnw:981-984 (eval = FALSE)
###################################################
## library(Biobase)
## expr.rma <- validData(data.rma)
## minimalSet <- new("ExpressionSet", exprs = as.matrix(expr.rma))


###################################################
### code chunk number 70: xps.Rnw:991-995 (eval = FALSE)
###################################################
## vv <- minimalSet[1:5,1:3]
## featureNames(vv)
## sampleNames(vv)
## exprs(vv)


###################################################
### code chunk number 71: xps.Rnw:1013-1014 (eval = FALSE)
###################################################
## root.image(data.exon, treename="BreastA.cel", zlim=c(3,11), w=400, h=400)


###################################################
### code chunk number 72: xps.Rnw:1034-1036 (eval = FALSE)
###################################################
## root.density(data.exon, "*", w=400, h=400)
## root.density(data.x.rma, "*", w=400, h=400)


###################################################
### code chunk number 73: xps.Rnw:1050-1051 (eval = FALSE)
###################################################
## root.profile(data.x.rma, w=640, h=400)


###################################################
### code chunk number 74: xps.Rnw:1070-1072 (eval = FALSE)
###################################################
## root.graph2D(data.exon, "BreastA.cel", "BreastB.cel")
## root.graph2D(data.x.rma, "BreastA.mdp", "BreastB.mdp")


###################################################
### code chunk number 75: xps.Rnw:1092-1095 (eval = FALSE)
###################################################
## root.hist2D(data.exon, "BreastA.cel", "BreastB.cel", option="COLZ")
## root.hist2D(data.x.rma, "BreastA.mdp", "BreastB.mdp", option="COLZ")
## root.hist2D(data.x.rma, "BreastA.mdp", "BreastB.mdp", option="SURF2")


###################################################
### code chunk number 76: xps.Rnw:1114-1116 (eval = FALSE)
###################################################
## root.hist3D(data.exon, "BreastA.cel", "BreastB.cel", "BreastC.cel", option="SCAT")
## root.hist3D(data.x.rma, "BreastA.mdp", "BreastB.mdp", "BreastC.mdp", option="SCAT")


###################################################
### code chunk number 77: xps.Rnw:1161-1162 (eval = FALSE)
###################################################
## data.farms <- farms(data.test3,"tmp_Test3FARMS",verbose=FALSE)


###################################################
### code chunk number 78: xps.Rnw:1167-1168 (eval = FALSE)
###################################################
## data.dfw <- dfw(data.test3,"tmp_Test3DFW",verbose=FALSE)


###################################################
### code chunk number 79: xps.Rnw:1183-1184 (eval = FALSE)
###################################################
## call.ini <- ini.call(data.test3,"tmp_Test3INI",verbose=FALSE)


