/*
 * Decompiled with CFR 0.152.
 */
package facs;

import facs.Illustration;
import facs.PlotRegion;
import facs.Representation;
import facs.scale.Scale;
import facs.scale.ScaleArgument;
import facs.scale.Scaling;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.util.ArrayList;

public final class CanvasSettings {
    public static final int BORDER_SIZE = 2;
    public static final int HEATMAP_SIZE = 25;
    public static final int HIST_BUFFER = 15;
    public static final int STATISTIC_IFRAME_WIDTH = 450;
    public static final int STATISTIC_IFRAME_HEIGHT = 250;
    public static final int STROKE_LENGTH = 6;
    public static final int PSEUDO_Z_HEIGHT = 20;
    public static final Font ARIAL_FONT_LARGE = new Font("Arial", 0, 14);
    public static final Font ARIAL_FONT_MEDIUM = new Font("Arial", 0, 12);
    public static final Font ARIAL_FONT = new Font("Arial", 0, 11);
    public static final Font ARIAL_FONT_SMALL = new Font("Arial", 0, 10);
    public static final Font ARIAL_FONT_TINY = new Font("Arial", 0, 8);
    public static final Font REGION_LABEL_FONT = new Font("Arial", 0, 9);
    public static final Font CRITICAL_LABEL_FONT = new Font("Arial", 0, 17);
    public static final DecimalFormat DOUBLE_FORMAT = new DecimalFormat("0.00");
    public static final DecimalFormat INT_FORMAT = new DecimalFormat("#,###,###,###,###");
    private static final Color[] DEFAULT_COLOR_SET_1D = new Color[]{new Color(0, 0, 0), new Color(204, 24, 0)};
    private static final Color[] GREYSCALE = new Color[]{new Color(0, 0, 0), new Color(255, 255, 255)};
    private static final Color[] EN_FUEGO = new Color[]{new Color(50, 0, 80), new Color(75, 0, 80), new Color(102, 0, 0), new Color(150, 0, 0), new Color(204, 0, 0), new Color(255, 67, 0), new Color(255, 102, 0), new Color(255, 186, 51), new Color(255, 217, 51), new Color(255, 255, 51), new Color(255, 255, 150)};
    private static final Color[] HETEROGENEITY_ON_FIRE = new Color[]{new Color(0, 0, 0), new Color(25, 0, 40), new Color(50, 0, 80), new Color(75, 0, 80), new Color(102, 0, 0), new Color(102, 0, 0), new Color(150, 0, 0), new Color(204, 0, 0), new Color(255, 67, 0), new Color(255, 102, 0), new Color(255, 186, 51), new Color(255, 217, 51), new Color(255, 255, 51), new Color(255, 255, 150)};
    private static final Color[] BLUE_TO_YELLOW = new Color[]{new Color(150, 150, 255), new Color(0, 0, 0), new Color(255, 255, 150)};
    private static final Color[] GREEN_TO_RED = new Color[]{new Color(0, 150, 0), new Color(0, 0, 0), new Color(200, 0, 0)};
    private static final Color[] RAINBOW = new Color[]{new Color(0, 0, 255), new Color(0, 255, 255), new Color(0, 255, 0), new Color(255, 255, 0), new Color(255, 0, 0)};
    private static final Color[] CHILL_OUT = new Color[]{new Color(66, 7, 101), new Color(52, 23, 126), new Color(0, 20, 239), new Color(42, 151, 132), new Color(37, 239, 67), new Color(60, 239, 150)};
    private static final Color[] DEFAULT_COLOR_SET_2D = EN_FUEGO;
    private static final Color[] RYANS_SIMPLE_COLOR_SET = new Color[]{new Color(210, 0, 0), new Color(255, 162, 0), new Color(255, 240, 0)};
    private static final Color[] JONATHANS_SIMPLE_COLOR_SET = EN_FUEGO;
    private static final Color[] WILLIAMS_SIMPLE_COLOR_SET = new Color[]{new Color(230, 255, 255), new Color(230, 255, 175), new Color(205, 255, 175), new Color(180, 255, 175), new Color(153, 255, 255), new Color(105, 255, 255), new Color(51, 255, 255), new Color(51, 231, 255), new Color(0, 188, 255), new Color(0, 153, 255), new Color(0, 69, 204), new Color(0, 38, 204), new Color(0, 0, 204), new Color(0, 0, 105)};
    private static final Color[] PALE_FIRE = new Color[]{new Color(0, 0, 105), new Color(0, 0, 204), new Color(0, 38, 204), new Color(0, 69, 204), new Color(0, 153, 255), new Color(0, 188, 255), new Color(51, 231, 255), new Color(51, 255, 255), new Color(105, 255, 255), new Color(153, 255, 255), new Color(180, 255, 175), new Color(205, 255, 175), new Color(230, 255, 175), new Color(230, 255, 255)};
    private static final Color[] NIKESHS_SIMPLE_COLOR_SET = new Color[]{new Color(0, 0, 153), new Color(255, 240, 0)};
    private static final Color[] MARKS_SIMPLE_COLOR_SET = new Color[]{new Color(0, 0, 0)};
    private static final Color[] PETERS_SIMPLE_COLOR_SET = new Color[]{new Color(0, 0, 0)};
    private static final Color[] GREEN_COLOR_SET = new Color[]{new Color(0, 0, 0), new Color(0, 255, 0)};
    private static final Color[] RED_COLOR_SET = new Color[]{new Color(0, 0, 0), new Color(255, 0, 0)};
    private static final Color[] BLUE_COLOR_SET = new Color[]{new Color(0, 0, 0), new Color(0, 0, 255)};
    private static final Color[] YELLOW_COLOR_SET = new Color[]{new Color(0, 0, 0), new Color(255, 255, 0)};
    private static final Color[] FUSCIA_COLOR_SET = new Color[]{new Color(0, 0, 0), new Color(255, 0, 255)};
    private static final Color[] CYAN_COLOR_SET = new Color[]{new Color(0, 0, 0), new Color(0, 255, 255)};
    private int plotWidth;
    private int plotHeight;
    private int canvasWidth;
    private int canvasHeight;
    private int bottomPad;
    private int topPad;
    private int leftPad;
    private int rightPad;
    private int canvasBottomPad;
    private int canvasTopPad;
    private int canvasLeftPad;
    private int canvasRightPad;
    private Color[] colorSet;
    private int numXBins;
    private int numYBins;
    private int rowCount;
    private int dotSize;
    private int columnCount;
    private int hSpacing;
    private int vSpacing;
    private int channelCount;
    private int xChannel;
    private int yChannel;
    private int plotType;
    private boolean blackBackgroundP;
    private boolean annotationP;
    private boolean scaleLabelP;
    private boolean scaleTickP;
    private boolean axisLabelP;
    private boolean longLabelP;
    private double smoothing;
    private double aspectRatio;
    private double contourPercent;
    private double contourStartPercent;
    private int populationType;
    private int eventCount;
    private int[] scaleFlags;
    private String[] scaleArguments;
    private double[] minimums;
    private double[] maximums;
    private ArrayList<PlotRegion> regions;

    private CanvasSettings(int numXBins, int numYBins, int hSpacing, int vSpacing, int channelCount, int xChannel, int yChannel, int plotType, int colorSet, boolean blackBackgroundP, boolean annotationP, boolean scaleLabelP, boolean scaleTickP, boolean axisLabelP, boolean longLabelP, int axisBins, double smoothing, double aspectRatio, double contourPercent, double contourStartPercent, int populationType, int eventCount, int dotSize) {
        this.numXBins = numXBins;
        this.numYBins = numYBins;
        this.dotSize = dotSize;
        this.plotWidth = numXBins;
        this.plotHeight = numYBins;
        this.hSpacing = hSpacing;
        this.vSpacing = vSpacing;
        this.channelCount = channelCount <= 0 ? 0 : channelCount;
        this.xChannel = xChannel;
        this.yChannel = yChannel;
        this.plotType = plotType;
        if (this.is1DPlot()) {
            this.colorSet = DEFAULT_COLOR_SET_1D;
            if (plotType == 1) {
                this.plotHeight = (int)((double)numYBins * aspectRatio);
            } else if (plotType == 2) {
                this.plotWidth = (int)((double)numXBins * aspectRatio);
            }
        } else {
            this.setColorSet(colorSet);
        }
        this.blackBackgroundP = blackBackgroundP;
        this.annotationP = annotationP;
        this.scaleLabelP = scaleLabelP;
        this.scaleTickP = scaleTickP;
        this.axisLabelP = axisLabelP;
        this.longLabelP = longLabelP;
        this.smoothing = smoothing;
        this.aspectRatio = aspectRatio;
        this.contourPercent = contourPercent;
        this.contourStartPercent = contourStartPercent;
        this.populationType = populationType;
        this.eventCount = eventCount;
        this.scaleFlags = new int[this.channelCount];
        this.scaleArguments = new String[this.channelCount];
        this.minimums = new double[this.channelCount];
        this.maximums = new double[this.channelCount];
        for (int i = 0; i < this.channelCount; ++i) {
            this.scaleFlags[i] = 1;
            this.minimums[i] = Double.NaN;
            this.maximums[i] = Double.NaN;
        }
        this.regions = new ArrayList();
        this.rowCount = 1;
        this.columnCount = 1;
        this.calculatePadding(this.rowCount, this.columnCount);
    }

    private void calculatePadding(int rowCount, int columnCount) {
        if (rowCount <= 0) {
            rowCount = 1;
        }
        if (columnCount <= 0) {
            columnCount = 1;
        }
        this.bottomPad = 0;
        this.topPad = 0;
        this.leftPad = 0;
        this.rightPad = 0;
        this.canvasBottomPad = 0;
        this.canvasTopPad = 0;
        this.canvasLeftPad = 0;
        this.canvasRightPad = 0;
        if (this.annotationP) {
            this.bottomPad = 2;
            this.topPad = 2;
            this.leftPad = 2;
            this.rightPad = 2;
            this.canvasBottomPad = 3;
            this.canvasTopPad = 3;
            this.canvasLeftPad = 3;
            this.canvasRightPad = 3;
            if (this.scaleLabelP) {
                if (this.plotType == 2) {
                    this.bottomPad += 4;
                } else {
                    this.bottomPad += 14;
                    this.rightPad += 3;
                }
                if (this.plotType == 101) {
                    this.canvasLeftPad += 3;
                }
                this.leftPad = this.plotType == 1 || this.plotType == 101 ? (this.leftPad += 4) : (this.leftPad += 18);
                if (!this.scaleTickP) {
                    this.bottomPad += 6;
                    this.leftPad += 6;
                }
            }
            if (this.scaleTickP) {
                this.bottomPad += 6;
                this.leftPad += 6;
            }
            if (this.axisLabelP) {
                if (this.plotType != 2) {
                    this.bottomPad += 22;
                }
                if (this.plotType != 1 && this.plotType != 101) {
                    this.leftPad += 20;
                }
                if (this.isPseudo3DPlot()) {
                    this.canvasTopPad += 20;
                }
            }
        }
        if (this.plotType == 101) {
            this.canvasWidth = this.canvasLeftPad + this.leftPad + this.plotWidth + this.rightPad + this.canvasRightPad;
            this.canvasHeight = this.canvasTopPad + this.topPad + this.plotHeight + this.bottomPad + this.vSpacing * (rowCount - 1) + this.canvasBottomPad;
        } else {
            this.canvasWidth = this.canvasLeftPad + (this.leftPad + this.plotWidth + this.rightPad + this.hSpacing) * columnCount - this.hSpacing + this.canvasRightPad;
            this.canvasHeight = this.canvasTopPad + (this.topPad + this.plotHeight + this.bottomPad + this.vSpacing) * rowCount - this.vSpacing + this.canvasBottomPad;
        }
    }

    public void setColorSet(int colorSet) {
        switch (colorSet) {
            case 1: {
                this.colorSet = EN_FUEGO;
                return;
            }
            case 301: {
                this.colorSet = HETEROGENEITY_ON_FIRE;
                return;
            }
            case 2: {
                this.colorSet = CHILL_OUT;
                return;
            }
            case 3: {
                this.colorSet = RAINBOW;
                return;
            }
            case 4: {
                this.colorSet = GREYSCALE;
                return;
            }
            case 5: {
                this.colorSet = PALE_FIRE;
                return;
            }
            case 6: {
                this.colorSet = GREEN_TO_RED;
                return;
            }
            case 7: {
                this.colorSet = BLUE_TO_YELLOW;
                return;
            }
            case 101: {
                this.colorSet = RYANS_SIMPLE_COLOR_SET;
                return;
            }
            case 102: {
                this.colorSet = WILLIAMS_SIMPLE_COLOR_SET;
                return;
            }
            case 103: {
                this.colorSet = NIKESHS_SIMPLE_COLOR_SET;
                return;
            }
            case 104: {
                this.colorSet = MARKS_SIMPLE_COLOR_SET;
                return;
            }
            case 105: {
                this.colorSet = PETERS_SIMPLE_COLOR_SET;
                return;
            }
            case 204: {
                this.colorSet = BLUE_COLOR_SET;
                return;
            }
            case 202: {
                this.colorSet = RED_COLOR_SET;
                return;
            }
            case 203: {
                this.colorSet = YELLOW_COLOR_SET;
                return;
            }
            case 201: {
                this.colorSet = GREEN_COLOR_SET;
                return;
            }
            case 205: {
                this.colorSet = FUSCIA_COLOR_SET;
                return;
            }
            case 206: {
                this.colorSet = CYAN_COLOR_SET;
                return;
            }
        }
        this.colorSet = DEFAULT_COLOR_SET_2D;
    }

    public boolean is1DPlot() {
        return this.plotType == 1 || this.plotType == 2 || this.plotType == 101;
    }

    public boolean isPseudo3DPlot() {
        return this.plotType == 201 || this.plotType == 202;
    }

    public boolean is2DPlot() {
        return !this.is1DPlot();
    }

    public void setRowCount(int rowCount) {
        if (rowCount > 0) {
            this.rowCount = rowCount;
            this.calculatePadding(this.rowCount, this.columnCount);
        }
    }

    public void setColumnCount(int columnCount) {
        if (columnCount > 0) {
            this.columnCount = columnCount;
            this.calculatePadding(this.rowCount, this.columnCount);
        }
    }

    public int getPlotWidth() {
        return this.plotWidth;
    }

    public int getPlotHeight() {
        return this.plotHeight;
    }

    public int getCanvasWidth() {
        return this.canvasWidth;
    }

    public int getCanvasHeight() {
        return this.canvasHeight;
    }

    public int getDotSize() {
        return this.dotSize;
    }

    public int getBottomPad() {
        return this.bottomPad;
    }

    public int getTopPad() {
        return this.topPad;
    }

    public int getLeftPad() {
        return this.leftPad;
    }

    public int getRightPad() {
        return this.rightPad;
    }

    public int getCanvasBottomPad() {
        return this.canvasBottomPad;
    }

    public int getCanvasTopPad() {
        return this.canvasTopPad;
    }

    public int getCanvasLeftPad() {
        return this.canvasLeftPad;
    }

    public int getCanvasRightPad() {
        return this.canvasRightPad;
    }

    public Color[] getColorSet() {
        return this.colorSet;
    }

    public int getNumXBins() {
        return this.numXBins;
    }

    public int getNumYBins() {
        return this.numYBins;
    }

    public int getNumZBins() {
        return this.numXBins;
    }

    public int getPlotHorizSpacing() {
        return this.hSpacing;
    }

    public int getPlotVertSpacing() {
        return this.vSpacing;
    }

    public void setChannelCount(int channelCount) {
        this.channelCount = channelCount <= 0 ? 0 : channelCount;
        this.scaleFlags = new int[this.channelCount];
        this.scaleArguments = new String[this.channelCount];
        this.minimums = new double[this.channelCount];
        this.maximums = new double[this.channelCount];
        for (int i = 0; i < this.channelCount; ++i) {
            this.scaleFlags[i] = 1;
            this.minimums[i] = Double.NaN;
            this.maximums[i] = Double.NaN;
        }
    }

    public int getXChannel() {
        return this.xChannel;
    }

    public int getYChannel() {
        return this.yChannel;
    }

    public int getPlotType() {
        return this.plotType;
    }

    public boolean useBlackBackground() {
        return this.blackBackgroundP;
    }

    public void setBlackBackgroundP(boolean blackBackgroundP) {
        this.blackBackgroundP = blackBackgroundP;
    }

    public boolean drawAnnotation() {
        return this.annotationP;
    }

    public boolean drawScaleLabel() {
        return this.scaleLabelP;
    }

    public boolean drawScaleTick() {
        return this.scaleTickP;
    }

    public boolean drawAxisLabel() {
        return this.axisLabelP;
    }

    public boolean useLongLabel() {
        return this.longLabelP;
    }

    public double getSmoothing() {
        return this.smoothing;
    }

    public double getAspectRatio() {
        return this.aspectRatio;
    }

    public double getContourPercent() {
        return this.contourPercent;
    }

    public double getContourStartPercent() {
        return this.contourStartPercent;
    }

    public int getPopulationType() {
        return this.populationType;
    }

    public int getEventCount() {
        return this.eventCount;
    }

    public Scale getScale(int channel) {
        if (channel < 0 || channel >= this.channelCount) {
            return null;
        }
        return Scaling.getScale(this.scaleFlags[channel]);
    }

    public int getScaleFlag(int channel) {
        if (channel < 0 || channel >= this.channelCount) {
            return 1;
        }
        return this.scaleFlags[channel];
    }

    public void setScaleFlag(int channel, int flag) {
        if (channel >= 0 && channel < this.channelCount) {
            this.scaleFlags[channel] = flag;
        }
    }

    public ScaleArgument getScaleArgument(int channel) {
        if (channel < 0 || channel >= this.channelCount) {
            return null;
        }
        return Scaling.getScaleArgument(this.scaleFlags[channel], this.scaleArguments[channel]);
    }

    public String getScaleArgumentString(int channel) {
        if (channel < 0 || channel >= this.channelCount) {
            return null;
        }
        return this.scaleArguments[channel];
    }

    public void setScaleArgumentString(int channel, String arg) {
        if (channel >= 0 && channel < this.channelCount) {
            this.scaleArguments[channel] = arg;
        }
    }

    public double getMinimum(int channel) {
        if (channel < 0 || channel >= this.channelCount) {
            return Double.NaN;
        }
        return this.minimums[channel];
    }

    public void setMinimum(int channel, double min) {
        if (channel >= 0 && channel < this.channelCount) {
            this.minimums[channel] = min;
        }
    }

    public double getMaximum(int channel) {
        if (channel < 0 || channel >= this.channelCount) {
            return Double.NaN;
        }
        return this.maximums[channel];
    }

    public void setMaximum(int channel, double max) {
        if (channel >= 0 && channel < this.channelCount) {
            this.maximums[channel] = max;
        }
    }

    public void setXChannel(int channel) {
        this.xChannel = channel;
    }

    public void setYChannel(int channel) {
        this.yChannel = channel;
    }

    public boolean addRegion(PlotRegion region) {
        if (region == null) {
            return false;
        }
        return this.regions.add(region);
    }

    public PlotRegion[] getRegions() {
        PlotRegion[] regionArray = new PlotRegion[this.regions.size()];
        this.regions.toArray(regionArray);
        return regionArray;
    }

    public Color getTextColor() {
        if (this.blackBackgroundP) {
            return Color.white;
        }
        return Color.black;
    }

    public Color getLineColor() {
        if (this.blackBackgroundP) {
            return Color.white;
        }
        return Color.black;
    }

    public Color getOutlierColor() {
        if (this.getPlotBackgroundColor() == Color.black) {
            return Color.white;
        }
        return Color.black;
    }

    public Color getBackgroundColor() {
        if (this.blackBackgroundP) {
            return Color.black;
        }
        return Color.white;
    }

    public Color getPlotBackgroundColor() {
        if (this.blackBackgroundP) {
            return Color.black;
        }
        return Color.white;
    }

    public Color getContourColor() {
        if (this.blackBackgroundP) {
            return Color.black;
        }
        return Color.white;
    }

    public int getStartX() {
        return this.getLeftX(0, 0);
    }

    public int getStartX(int row, int column) {
        return this.getLeftX(row, column);
    }

    public int getLeftX(int row, int column) {
        return this.canvasLeftPad + (this.leftPad + this.plotWidth + this.rightPad + this.hSpacing) * column + this.leftPad;
    }

    public int getRightX(int row, int column) {
        return this.getLeftX(row, column) + this.plotWidth;
    }

    public int getStartY() {
        return this.getTopY(0, 0);
    }

    public int getStartY(int row, int column) {
        return this.getTopY(row, column);
    }

    public int getTopY(int row, int column) {
        if (this.plotType == 101) {
            return this.canvasTopPad + this.topPad + this.vSpacing * row;
        }
        return this.canvasTopPad + (this.topPad + this.plotHeight + this.bottomPad + this.vSpacing) * row + this.topPad;
    }

    public int getBottomY(int row, int column) {
        return this.getTopY(row, column) + this.plotHeight;
    }

    public static CanvasSettings getCanvasSettings(int hSpacing, int vSpacing, int channelCount, int xChannel, int yChannel, int plotType, int colorSet, boolean blackBackgroundP, boolean annotationP, boolean scaleLabelP, boolean scaleTickP, boolean axisLabelP, boolean longLabelP, int axisBins, double smoothing, double aspectRatio, double contourPercent, double contourStartPercent, int populationType, int eventCount, int dotSize) {
        return new CanvasSettings(axisBins, axisBins, hSpacing, vSpacing, channelCount, xChannel, yChannel, plotType, colorSet, blackBackgroundP, annotationP, scaleLabelP, scaleTickP, axisLabelP, longLabelP, axisBins, smoothing, aspectRatio, contourPercent, contourStartPercent, populationType, eventCount, dotSize);
    }

    public static CanvasSettings getCanvasSettings(Representation representation) {
        return CanvasSettings.getCanvasSettings(representation, 0, 0);
    }

    public static CanvasSettings getCanvasSettings(Representation representation, int hSpacing, int vSpacing) {
        if (representation == null) {
            return null;
        }
        CanvasSettings cs = CanvasSettings.getCanvasSettings(hSpacing, vSpacing, representation.getChannelCount(), representation.getXChannel(), representation.getYChannel(), representation.getPlotType(), representation.getColorSet(), representation.useBlackBackground(), representation.drawAnnotation(), representation.drawScaleLabel(), representation.drawScaleTick(), representation.drawAxisLabel(), representation.useLongLabel(), representation.getAxisBins(), representation.getSmoothing(), representation.getAspectRatio(), representation.getContourPercent(), representation.getContourStartPercent(), representation.getPopulationType(), representation.getEventCount(), representation.getDotSize());
        int channelCount = representation.getChannelCount();
        for (int i = 0; i < channelCount; ++i) {
            cs.setScaleFlag(i, representation.getScaleFlag(i));
            cs.setScaleArgumentString(i, representation.getScaleArgumentString(i));
            cs.setMinimum(i, representation.getMinimum(i));
            cs.setMaximum(i, representation.getMaximum(i));
        }
        return cs;
    }

    public static CanvasSettings getCanvasSettings(Illustration illustration) {
        return CanvasSettings.getCanvasSettings(illustration, 0, 0);
    }

    public static CanvasSettings getCanvasSettings(Illustration illustration, int hSpacing, int vSpacing) {
        if (illustration == null) {
            return null;
        }
        CanvasSettings cs = CanvasSettings.getCanvasSettings(hSpacing, vSpacing, illustration.getChannelCount(), illustration.getXChannel(), illustration.getYChannel(), illustration.getPlotType(), illustration.getColorSet(), illustration.useBlackBackground(), illustration.drawAnnotation(), illustration.drawScaleLabel(), illustration.drawScaleTick(), illustration.drawAxisLabel(), illustration.useLongLabel(), illustration.getAxisBins(), illustration.getSmoothing(), illustration.getAspectRatio(), illustration.getContourPercent(), illustration.getContourStartPercent(), illustration.getPopulationType(), illustration.getEventCount(), illustration.getDotSize());
        int channelCount = illustration.getChannelCount();
        for (int i = 0; i < channelCount; ++i) {
            cs.setScaleFlag(i, illustration.getScaleFlag(i));
            cs.setScaleArgumentString(i, illustration.getScaleArgumentString(i));
            cs.setMinimum(i, illustration.getMinimum(i));
            cs.setMaximum(i, illustration.getMaximum(i));
        }
        return cs;
    }

    public static BufferedImage getTestPattern() {
        return CanvasSettings.getTestPattern(256, 256, DEFAULT_COLOR_SET_2D);
    }

    public static BufferedImage getTestPattern(int width, int height, Color[] colorSet) {
        if (width <= 0 || height <= 0) {
            return new BufferedImage(0, 0, 1);
        }
        BufferedImage image = new BufferedImage(width, height, 1);
        Graphics2D g = image.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(Color.white);
        g.fillRect(0, 0, width, height);
        if (colorSet != null && colorSet.length > 0) {
            int multiplier = height / colorSet.length;
            for (int i = 0; i < colorSet.length; ++i) {
                g.setColor(colorSet[i]);
                g.fillRect(0, i * multiplier, width, multiplier);
            }
        }
        g.dispose();
        return image;
    }
}

