/*
 * Decompiled with CFR 0.152.
 */
package facs;

import facs.ColorGradient;
import facs.UnidirectionalColorGradient;
import java.awt.Color;

public final class BidirectionalColorGradient
implements ColorGradient {
    private final UnidirectionalColorGradient leftGradient;
    private final UnidirectionalColorGradient rightGradient;
    private final double inflection;

    private BidirectionalColorGradient(UnidirectionalColorGradient leftGradient, UnidirectionalColorGradient rightGradient) {
        this.leftGradient = leftGradient;
        this.rightGradient = rightGradient;
        this.inflection = this.leftGradient.getMaximum();
    }

    public double getMinimum() {
        return this.leftGradient.getMinimum();
    }

    public double getMaximum() {
        return this.rightGradient.getMaximum();
    }

    double getInflection() {
        return this.inflection;
    }

    public Color getMinimumColor() {
        return this.leftGradient.getMinimumColor();
    }

    public Color getMaximumColor() {
        return this.rightGradient.getMaximumColor();
    }

    public Color getColor(double value) {
        if (value <= this.inflection) {
            return this.leftGradient.getColor(value);
        }
        return this.rightGradient.getColor(value);
    }

    public static BidirectionalColorGradient getBidirectionalColorGradient(int colorSet, double min, double inflection, double max) {
        UnidirectionalColorGradient leftGradient = UnidirectionalColorGradient.getUnidirectionalColorGradient(colorSet, true, min, inflection);
        UnidirectionalColorGradient rightGradient = UnidirectionalColorGradient.getUnidirectionalColorGradient(colorSet, false, inflection, max);
        if (leftGradient == null || rightGradient == null) {
            return null;
        }
        return new BidirectionalColorGradient(leftGradient, rightGradient);
    }

    public static void main(String[] args) {
        BidirectionalColorGradient gradient = BidirectionalColorGradient.getBidirectionalColorGradient(1, 0.0, 5.0, 10.0);
        for (int i = 0; i <= 10; ++i) {
            Color color = gradient.getColor(i);
            System.out.print(i);
            System.out.print(": (");
            System.out.print(color.getRed());
            System.out.print(", ");
            System.out.print(color.getGreen());
            System.out.print(", ");
            System.out.print(color.getBlue());
            System.out.println(")");
        }
    }
}

