### R code from vignette source 'segmentSeq.Rnw'

###################################################
### code chunk number 1: segmentSeq.Rnw:25-26
###################################################
  library(segmentSeq)


###################################################
### code chunk number 2: segmentSeq.Rnw:31-32
###################################################
cl <- makeCluster(8)


###################################################
### code chunk number 3: segmentSeq.Rnw:41-53
###################################################
chrlens <- c(1e6, 2e5)

datadir <- system.file("extdata", package = "segmentSeq")
libfiles <- c("SL9.txt", "SL10.txt", "SL26.txt", "SL32.txt")
libnames <- c("SL9", "SL10", "SL26", "SL32")
replicates <- c("AGO6", "AGO6", "AGO4", "AGO4")

aD <- readGeneric(files = libfiles, dir = datadir,
                  replicates = replicates, libnames = libnames, 
                  chrs = c(">Chr1", ">Chr2"), chrlens = chrlens,
                  polyLength = 10, header = TRUE, gap = 200)
aD


###################################################
### code chunk number 4: segmentSeq.Rnw:58-60
###################################################
sD <- processAD(aD, gap = 100, cl = cl)
sD


###################################################
### code chunk number 5: segmentSeq.Rnw:69-70
###################################################
clustSegs <- heuristicSeg(sD = sD, aD = aD, RKPM = 1000, largeness = 1e8, getLikes = TRUE, cl = cl)


###################################################
### code chunk number 6: segmentSeq.Rnw:82-86
###################################################
classSegs <- classifySeg(sD = sD, aD = aD, cD = clustSegs,
                         subRegion = NULL, getLikes = TRUE,
                         lociCutoff = 0.9, nullCutoff = 0.9, cl = cl)
classSegs


###################################################
### code chunk number 7: segPlot
###################################################
par(mfrow = c(2,1), mar = c(2,6,2,2))
plotGenome(aD, clustSegs, chr = ">Chr1", limits = c(1, 1e5),
           showNumber = FALSE, cap = 50)
plotGenome(aD, classSegs, chr = ">Chr1", limits = c(1, 1e5),
           showNumber = FALSE, cap = 50)


###################################################
### code chunk number 8: figSeg
###################################################
par(mfrow = c(2,1), mar = c(2,6,2,2))
plotGenome(aD, clustSegs, chr = ">Chr1", limits = c(1, 1e5),
           showNumber = FALSE, cap = 50)
plotGenome(aD, classSegs, chr = ">Chr1", limits = c(1, 1e5),
           showNumber = FALSE, cap = 50)


###################################################
### code chunk number 9: segmentSeq.Rnw:117-119
###################################################
loci <- selectLoci(classSegs, FDR = 0.05)
loci


###################################################
### code chunk number 10: <stopCluster
###################################################
stopCluster(cl)


