/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.HashSet;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitorEx;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataCardinalityRestriction;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDataVisitorEx;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectCardinalityRestriction;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NNF
implements OWLClassExpressionVisitorEx<OWLClassExpression>,
OWLDataVisitorEx<OWLDataRange>,
OWLAxiomVisitorEx<OWLAxiom> {
    private boolean negated;
    private OWLDataFactory dataFactory;

    public NNF(OWLDataFactory dataFactory) {
        this.dataFactory = dataFactory;
    }

    public void reset() {
        this.negated = false;
    }

    private OWLClassExpression getNegation(OWLClassExpression classExpression) {
        return this.dataFactory.getOWLObjectComplementOf(classExpression);
    }

    @Override
    public OWLClassExpression visit(OWLClass desc) {
        if (this.negated) {
            if (desc.isOWLNothing()) {
                return this.dataFactory.getOWLThing();
            }
            if (desc.isOWLThing()) {
                return this.dataFactory.getOWLNothing();
            }
            return this.getNegation(desc);
        }
        return desc;
    }

    @Override
    public OWLClassExpression visit(OWLObjectIntersectionOf desc) {
        HashSet<OWLClassExpression> ops = new HashSet<OWLClassExpression>();
        for (OWLClassExpression op : desc.getOperands()) {
            ops.add(op.accept(this));
        }
        if (this.negated) {
            return this.dataFactory.getOWLObjectUnionOf(ops);
        }
        return this.dataFactory.getOWLObjectIntersectionOf(ops);
    }

    @Override
    public OWLClassExpression visit(OWLObjectUnionOf desc) {
        HashSet<OWLClassExpression> ops = new HashSet<OWLClassExpression>();
        for (OWLClassExpression op : desc.getOperands()) {
            ops.add(op.accept(this));
        }
        if (this.negated) {
            return this.dataFactory.getOWLObjectIntersectionOf(ops);
        }
        return this.dataFactory.getOWLObjectUnionOf(ops);
    }

    @Override
    public OWLClassExpression visit(OWLObjectComplementOf desc) {
        if (this.negated) {
            boolean neg = this.negated;
            this.negated = false;
            OWLClassExpression negDesc = desc.getOperand().accept(this);
            this.negated = neg;
            return negDesc;
        }
        boolean neg = this.negated;
        this.negated = true;
        OWLClassExpression negDesc = desc.getOperand().accept(this);
        this.negated = neg;
        return negDesc;
    }

    @Override
    public OWLClassExpression visit(OWLObjectSomeValuesFrom desc) {
        OWLClassExpression filler = ((OWLClassExpression)desc.getFiller()).accept(this);
        if (this.negated) {
            return this.dataFactory.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)desc.getProperty(), filler);
        }
        return this.dataFactory.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)desc.getProperty(), filler);
    }

    @Override
    public OWLClassExpression visit(OWLObjectAllValuesFrom desc) {
        OWLClassExpression filler = ((OWLClassExpression)desc.getFiller()).accept(this);
        if (this.negated) {
            return this.dataFactory.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)desc.getProperty(), filler);
        }
        return this.dataFactory.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)desc.getProperty(), filler);
    }

    @Override
    public OWLClassExpression visit(OWLObjectHasValue desc) {
        return desc.asSomeValuesFrom().accept(this);
    }

    @Override
    public OWLClassExpression visit(OWLObjectMinCardinality desc) {
        boolean neg = this.negated;
        int card = desc.getCardinality();
        if (this.negated && (card = desc.getCardinality() - 1) < 0) {
            card = 0;
        }
        this.negated = false;
        OWLClassExpression filler = ((OWLClassExpression)desc.getFiller()).accept(this);
        OWLObjectCardinalityRestriction nnf = null;
        nnf = neg ? this.dataFactory.getOWLObjectMaxCardinality(card, (OWLObjectPropertyExpression)desc.getProperty(), filler) : this.dataFactory.getOWLObjectMinCardinality(card, (OWLObjectPropertyExpression)desc.getProperty(), filler);
        this.negated = neg;
        return nnf;
    }

    @Override
    public OWLClassExpression visit(OWLObjectExactCardinality desc) {
        return desc.asIntersectionOfMinMax().accept(this);
    }

    @Override
    public OWLClassExpression visit(OWLObjectMaxCardinality desc) {
        boolean neg = this.negated;
        int card = desc.getCardinality();
        if (this.negated) {
            card = desc.getCardinality() + 1;
        }
        this.negated = false;
        OWLClassExpression filler = ((OWLClassExpression)desc.getFiller()).accept(this);
        OWLObjectCardinalityRestriction nnf = null;
        nnf = neg ? this.dataFactory.getOWLObjectMinCardinality(card, (OWLObjectPropertyExpression)desc.getProperty(), filler) : this.dataFactory.getOWLObjectMaxCardinality(card, (OWLObjectPropertyExpression)desc.getProperty(), filler);
        this.negated = neg;
        return nnf;
    }

    @Override
    public OWLClassExpression visit(OWLObjectHasSelf desc) {
        if (this.negated) {
            return this.getNegation(desc);
        }
        return desc;
    }

    @Override
    public OWLClassExpression visit(OWLObjectOneOf desc) {
        if (desc.getIndividuals().size() == 1) {
            if (this.negated) {
                return this.getNegation(desc);
            }
            return desc;
        }
        return desc.asObjectUnionOf().accept(this);
    }

    @Override
    public OWLClassExpression visit(OWLDataSomeValuesFrom desc) {
        OWLDataRange filler = ((OWLDataRange)desc.getFiller()).accept(this);
        if (this.negated) {
            return this.dataFactory.getOWLDataAllValuesFrom((OWLDataPropertyExpression)desc.getProperty(), filler);
        }
        return this.dataFactory.getOWLDataSomeValuesFrom((OWLDataPropertyExpression)desc.getProperty(), filler);
    }

    @Override
    public OWLClassExpression visit(OWLDataAllValuesFrom desc) {
        OWLDataRange filler = ((OWLDataRange)desc.getFiller()).accept(this);
        if (this.negated) {
            return this.dataFactory.getOWLDataSomeValuesFrom((OWLDataPropertyExpression)desc.getProperty(), filler);
        }
        return this.dataFactory.getOWLDataAllValuesFrom((OWLDataPropertyExpression)desc.getProperty(), filler);
    }

    @Override
    public OWLClassExpression visit(OWLDataHasValue desc) {
        return desc.asSomeValuesFrom().accept(this);
    }

    @Override
    public OWLClassExpression visit(OWLDataExactCardinality desc) {
        return desc.asIntersectionOfMinMax().accept(this);
    }

    @Override
    public OWLClassExpression visit(OWLDataMaxCardinality desc) {
        boolean neg = this.negated;
        int card = desc.getCardinality();
        if (this.negated) {
            card = desc.getCardinality() + 1;
        }
        this.negated = false;
        OWLDataRange filler = ((OWLDataRange)desc.getFiller()).accept(this);
        OWLDataCardinalityRestriction nnf = null;
        nnf = neg ? this.dataFactory.getOWLDataMinCardinality(card, (OWLDataPropertyExpression)desc.getProperty(), filler) : this.dataFactory.getOWLDataMaxCardinality(card, (OWLDataPropertyExpression)desc.getProperty(), filler);
        this.negated = neg;
        return nnf;
    }

    @Override
    public OWLClassExpression visit(OWLDataMinCardinality desc) {
        boolean neg = this.negated;
        int card = desc.getCardinality();
        if (this.negated && (card = desc.getCardinality() - 1) < 0) {
            card = 0;
        }
        this.negated = false;
        OWLDataRange filler = ((OWLDataRange)desc.getFiller()).accept(this);
        OWLDataCardinalityRestriction nnf = null;
        nnf = neg ? this.dataFactory.getOWLDataMaxCardinality(card, (OWLDataPropertyExpression)desc.getProperty(), filler) : this.dataFactory.getOWLDataMinCardinality(card, (OWLDataPropertyExpression)desc.getProperty(), filler);
        this.negated = neg;
        return nnf;
    }

    @Override
    public OWLDataRange visit(OWLDatatype node) {
        if (this.negated) {
            return this.dataFactory.getOWLDataComplementOf(node);
        }
        return node;
    }

    @Override
    public OWLDataRange visit(OWLDataComplementOf node) {
        if (this.negated) {
            return node.getDataRange();
        }
        return node;
    }

    @Override
    public OWLDataRange visit(OWLDataOneOf node) {
        if (node.getValues().size() == 1) {
            if (this.negated) {
                return this.dataFactory.getOWLDataComplementOf(node);
            }
            return node;
        }
        HashSet<OWLDataOneOf> oneOfs = new HashSet<OWLDataOneOf>();
        for (OWLLiteral lit : node.getValues()) {
            oneOfs.add(this.dataFactory.getOWLDataOneOf(lit));
        }
        return this.dataFactory.getOWLDataUnionOf(oneOfs).accept(this);
    }

    @Override
    public OWLDataRange visit(OWLDataIntersectionOf node) {
        HashSet<OWLDataRange> ops = new HashSet<OWLDataRange>();
        for (OWLDataRange op : node.getOperands()) {
            ops.add(op.accept(this));
        }
        if (this.negated) {
            return this.dataFactory.getOWLDataUnionOf(ops);
        }
        return this.dataFactory.getOWLDataIntersectionOf(ops);
    }

    @Override
    public OWLDataRange visit(OWLDataUnionOf node) {
        HashSet<OWLDataRange> ops = new HashSet<OWLDataRange>();
        for (OWLDataRange op : node.getOperands()) {
            ops.add(op.accept(this));
        }
        if (this.negated) {
            return this.dataFactory.getOWLDataIntersectionOf(ops);
        }
        return this.dataFactory.getOWLDataUnionOf(ops);
    }

    @Override
    public OWLAxiom visit(OWLHasKeyAxiom axiom) {
        return null;
    }

    @Override
    public OWLDataRange visit(OWLDatatypeRestriction node) {
        if (this.negated) {
            return this.dataFactory.getOWLDataComplementOf(node);
        }
        return node;
    }

    @Override
    public OWLDataRange visit(OWLLiteral node) {
        return null;
    }

    @Override
    public OWLDataRange visit(OWLFacetRestriction node) {
        return null;
    }

    @Override
    public OWLAxiom visit(OWLSubClassOfAxiom axiom) {
        return this.dataFactory.getOWLSubClassOfAxiom(axiom.getSubClass().accept(this), axiom.getSuperClass().accept(this));
    }

    @Override
    public OWLAxiom visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLAsymmetricObjectPropertyAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLReflexiveObjectPropertyAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLDisjointClassesAxiom axiom) {
        HashSet<OWLClassExpression> ops = new HashSet<OWLClassExpression>();
        for (OWLClassExpression op : axiom.getClassExpressions()) {
            ops.add(op.accept(this));
        }
        return this.dataFactory.getOWLDisjointClassesAxiom(ops);
    }

    @Override
    public OWLAxiom visit(OWLDataPropertyDomainAxiom axiom) {
        return this.dataFactory.getOWLDataPropertyDomainAxiom((OWLDataPropertyExpression)axiom.getProperty(), axiom.getDomain().accept(this));
    }

    @Override
    public OWLAxiom visit(OWLObjectPropertyDomainAxiom axiom) {
        return this.dataFactory.getOWLObjectPropertyDomainAxiom((OWLObjectPropertyExpression)axiom.getProperty(), axiom.getDomain().accept(this));
    }

    @Override
    public OWLAxiom visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLDifferentIndividualsAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLDisjointDataPropertiesAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLDisjointObjectPropertiesAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLObjectPropertyRangeAxiom axiom) {
        return this.dataFactory.getOWLObjectPropertyRangeAxiom((OWLObjectPropertyExpression)axiom.getProperty(), ((OWLClassExpression)axiom.getRange()).accept(this));
    }

    @Override
    public OWLAxiom visit(OWLObjectPropertyAssertionAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLFunctionalObjectPropertyAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLSubObjectPropertyOfAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLDisjointUnionAxiom axiom) {
        HashSet<OWLClassExpression> descs = new HashSet<OWLClassExpression>();
        for (OWLClassExpression op : axiom.getClassExpressions()) {
            descs.add(op.accept(this));
        }
        return this.dataFactory.getOWLDisjointUnionAxiom(axiom.getOWLClass(), descs);
    }

    @Override
    public OWLAxiom visit(OWLDeclarationAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLAnnotationAssertionAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLSymmetricObjectPropertyAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLDataPropertyRangeAxiom axiom) {
        return this.dataFactory.getOWLDataPropertyRangeAxiom((OWLDataPropertyExpression)axiom.getProperty(), ((OWLDataRange)axiom.getRange()).accept(this));
    }

    @Override
    public OWLAxiom visit(OWLFunctionalDataPropertyAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLEquivalentDataPropertiesAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLClassAssertionAxiom axiom) {
        if (axiom.getClassExpression().isAnonymous()) {
            return this.dataFactory.getOWLClassAssertionAxiom(axiom.getClassExpression().accept(this), axiom.getIndividual());
        }
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLEquivalentClassesAxiom axiom) {
        HashSet<OWLClassExpression> ops = new HashSet<OWLClassExpression>();
        for (OWLClassExpression op : axiom.getClassExpressions()) {
            ops.add(op.accept(this));
        }
        return this.dataFactory.getOWLEquivalentClassesAxiom(ops);
    }

    @Override
    public OWLAxiom visit(OWLDataPropertyAssertionAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLTransitiveObjectPropertyAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLSubDataPropertyOfAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLSameIndividualAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLSubPropertyChainOfAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLInverseObjectPropertiesAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(SWRLRule rule) {
        return rule;
    }

    @Override
    public OWLAxiom visit(OWLAnnotationPropertyDomainAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLAnnotationPropertyRangeAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLSubAnnotationPropertyOfAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLDatatypeDefinitionAxiom axiom) {
        return axiom;
    }
}

