/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;
import org.semanticweb.HermiT.Prefixes;
import org.semanticweb.HermiT.model.AnnotatedEquality;
import org.semanticweb.HermiT.model.Atom;
import org.semanticweb.HermiT.model.AtomLexicalComparator;
import org.semanticweb.HermiT.model.AtomicConcept;
import org.semanticweb.HermiT.model.AtomicRole;
import org.semanticweb.HermiT.model.DLPredicate;
import org.semanticweb.HermiT.model.InternalDatatype;
import org.semanticweb.HermiT.model.Variable;

public class DLClause
implements Serializable {
    private static final long serialVersionUID = -4513910129515151732L;
    public static final Atom[][] EMPTY_HEAD = new Atom[0][];
    protected final boolean m_isKnownToBeAdmissible;
    protected final Atom[] m_headAtoms;
    protected final Atom[] m_bodyAtoms;
    protected final ClauseType m_clauseType;

    protected DLClause(boolean bl, Atom[] atomArray, Atom[] atomArray2, ClauseType clauseType) {
        this.m_isKnownToBeAdmissible = bl;
        this.m_headAtoms = atomArray;
        this.m_bodyAtoms = atomArray2;
        this.m_clauseType = clauseType;
    }

    public boolean isKnownToBeAdmissible() {
        return this.m_isKnownToBeAdmissible;
    }

    public int getHeadLength() {
        return this.m_headAtoms.length;
    }

    public Atom getHeadAtom(int n) {
        return this.m_headAtoms[n];
    }

    public Atom[] getHeadAtoms() {
        return (Atom[])this.m_headAtoms.clone();
    }

    public int getBodyLength() {
        return this.m_bodyAtoms.length;
    }

    public Atom getBodyAtom(int n) {
        return this.m_bodyAtoms[n];
    }

    public Atom[] getBodyAtoms() {
        return (Atom[])this.m_bodyAtoms.clone();
    }

    public DLClause getSafeVersion() {
        Object object;
        int n;
        Atom atom;
        int n2;
        HashSet<Variable> hashSet = new HashSet<Variable>();
        for (n2 = 0; n2 < this.m_headAtoms.length; ++n2) {
            atom = this.m_headAtoms[n2];
            for (n = 0; n < atom.getArity(); ++n) {
                object = atom.getArgumentVariable(n);
                if (object == null) continue;
                hashSet.add((Variable)object);
            }
        }
        for (n2 = 0; n2 < this.m_bodyAtoms.length; ++n2) {
            atom = this.m_bodyAtoms[n2];
            for (n = 0; n < atom.getArity(); ++n) {
                object = atom.getArgumentVariable(n);
                if (object == null) continue;
                hashSet.remove(object);
            }
        }
        if (this.m_headAtoms.length == 0 && this.m_bodyAtoms.length == 0) {
            hashSet.add(Variable.create("X"));
        }
        if (hashSet.isEmpty()) {
            return this;
        }
        Atom[] atomArray = new Atom[this.m_bodyAtoms.length + hashSet.size()];
        System.arraycopy(this.m_bodyAtoms, 0, atomArray, 0, this.m_bodyAtoms.length);
        int n3 = this.m_bodyAtoms.length;
        DLPredicate dLPredicate = this.m_clauseType == ClauseType.DATA_RANGE_INCLUSION ? InternalDatatype.RDFS_LITERAL : AtomicConcept.THING;
        for (Variable variable : hashSet) {
            atomArray[n3++] = Atom.create(dLPredicate, variable);
        }
        return DLClause.createEx(this.m_isKnownToBeAdmissible, this.m_headAtoms, atomArray, this.m_clauseType);
    }

    public DLClause getChangedDLClause(Atom[] atomArray, Atom[] atomArray2) {
        if (atomArray == null) {
            atomArray = this.m_headAtoms;
        }
        if (atomArray2 == null) {
            atomArray2 = this.m_bodyAtoms;
        }
        return DLClause.createEx(this.m_isKnownToBeAdmissible, atomArray, atomArray2, this.m_clauseType);
    }

    public boolean isFunctionalityAxiom() {
        Variable variable;
        DLPredicate dLPredicate;
        if (this.getBodyLength() == 2 && this.getHeadLength() == 1 && (dLPredicate = this.getBodyAtom(0).getDLPredicate()) instanceof AtomicRole && this.getBodyAtom(1).getDLPredicate().equals(dLPredicate) && this.getHeadAtom(0).getDLPredicate() instanceof AnnotatedEquality && (variable = this.getBodyAtom(0).getArgumentVariable(0)) != null && variable.equals(this.getBodyAtom(1).getArgument(0))) {
            Variable variable2 = this.getBodyAtom(0).getArgumentVariable(1);
            Variable variable3 = this.getBodyAtom(1).getArgumentVariable(1);
            Variable variable4 = this.getHeadAtom(0).getArgumentVariable(0);
            Variable variable5 = this.getHeadAtom(0).getArgumentVariable(1);
            if (variable2 != null && variable3 != null && !variable2.equals(variable3) && variable4 != null && variable5 != null && (variable2.equals(variable4) && variable3.equals(variable5) || variable2.equals(variable5) && variable3.equals(variable4))) {
                return true;
            }
        }
        return false;
    }

    public boolean isInverseFunctionalityAxiom() {
        Variable variable;
        DLPredicate dLPredicate;
        if (this.getBodyLength() == 2 && this.getHeadLength() == 1 && (dLPredicate = this.getBodyAtom(0).getDLPredicate()) instanceof AtomicRole && this.getBodyAtom(1).getDLPredicate().equals(dLPredicate) && this.getHeadAtom(0).getDLPredicate() instanceof AnnotatedEquality && (variable = this.getBodyAtom(0).getArgumentVariable(1)) != null && variable.equals(this.getBodyAtom(1).getArgument(1))) {
            Variable variable2 = this.getBodyAtom(0).getArgumentVariable(0);
            Variable variable3 = this.getBodyAtom(1).getArgumentVariable(0);
            Variable variable4 = this.getHeadAtom(0).getArgumentVariable(0);
            Variable variable5 = this.getHeadAtom(0).getArgumentVariable(1);
            if (variable2 != null && variable3 != null && !variable2.equals(variable3) && variable4 != null && variable5 != null && (variable2.equals(variable4) && variable3.equals(variable5) || variable2.equals(variable5) && variable3.equals(variable4))) {
                return true;
            }
        }
        return false;
    }

    public ClauseType getClauseType() {
        return this.m_clauseType;
    }

    public String toString(Prefixes prefixes) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < this.m_headAtoms.length; ++n) {
            if (n != 0) {
                stringBuffer.append(" v ");
            }
            stringBuffer.append(this.m_headAtoms[n].toString(prefixes));
        }
        stringBuffer.append(" :- ");
        for (n = 0; n < this.m_bodyAtoms.length; ++n) {
            if (n != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.m_bodyAtoms[n].toString(prefixes));
        }
        return stringBuffer.toString();
    }

    public String toOrderedString(Prefixes prefixes) {
        StringBuffer stringBuffer = new StringBuffer();
        TreeSet<Atom> treeSet = new TreeSet<Atom>(AtomLexicalComparator.INSTANCE);
        treeSet.addAll(Arrays.asList(this.m_headAtoms));
        boolean bl = true;
        for (Atom object2 : treeSet) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(" v ");
            }
            stringBuffer.append(object2.toString(prefixes));
        }
        stringBuffer.append(" :- ");
        TreeSet<Atom> treeSet2 = new TreeSet<Atom>(AtomLexicalComparator.INSTANCE);
        treeSet2.addAll(Arrays.asList(this.m_bodyAtoms));
        bl = true;
        Iterator iterator = treeSet2.iterator();
        while (iterator.hasNext()) {
            Atom atom = (Atom)iterator.next();
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(", ");
            }
            stringBuffer.append(atom.toString(prefixes));
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString(Prefixes.STANDARD_PREFIXES);
    }

    public static DLClause create(Atom[] atomArray, Atom[] atomArray2, ClauseType clauseType) {
        return DLClause.createEx(false, atomArray, atomArray2, clauseType);
    }

    public static DLClause createEx(boolean bl, Atom[] atomArray, Atom[] atomArray2, ClauseType clauseType) {
        return new DLClause(bl, atomArray, atomArray2, clauseType);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ClauseType {
        CONCEPT_INCLUSION,
        DATA_RANGE_INCLUSION,
        INVERSE_OBJECT_PROPERTY_INCLUSION,
        OBJECT_PROPERTY_INCLUSION,
        DATA_PROPERTY_INCLUSION,
        ASYMMETRY,
        REFLEXIVITY,
        IRREFLEXIVITY,
        DISJOINT_OBJECT_PROPERTIES,
        DISJOINT_DATA_PROPERTIES,
        HAS_KEY,
        SWRL_RULE,
        GRAPH_RULE,
        GRAPH_START_CLAUSE,
        OTHER;

    }
}

