/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.debugger;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class ConsoleTextArea
extends JTextArea {
    protected final ConsoleWriter m_writer;
    protected final ConsoleReader m_reader;
    protected int m_userTypedTextStart;

    public ConsoleTextArea() {
        this.setDocument(new ConsoleDocument());
        this.m_writer = new ConsoleWriter();
        this.m_reader = new ConsoleReader();
        this.enableEvents(8L);
    }

    public Writer getWriter() {
        return this.m_writer;
    }

    public Reader getReader() {
        return this.m_reader;
    }

    public void clear() {
        this.m_userTypedTextStart = 0;
        this.setText("");
    }

    protected void moveToEndIfNecessary() {
        int n = this.getSelectionStart();
        int n2 = this.getSelectionEnd();
        if (n2 < this.m_userTypedTextStart || n2 == this.m_userTypedTextStart && n != n2) {
            int n3 = this.getDocument().getLength();
            this.select(n3, n3);
        }
    }

    public void replaceSelection(String string) {
        this.moveToEndIfNecessary();
        super.replaceSelection(string);
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() != 10) {
            super.processKeyEvent(keyEvent);
        }
        if (keyEvent.getID() == 401 && keyEvent.getKeyCode() == 10) {
            String string;
            int n = this.getDocument().getLength();
            this.select(n, n);
            super.replaceSelection("\n");
            n = this.getDocument().getLength();
            try {
                string = this.getDocument().getText(this.m_userTypedTextStart, n - this.m_userTypedTextStart);
            }
            catch (BadLocationException badLocationException) {
                string = "";
            }
            this.m_reader.addToBuffer(string);
            this.m_userTypedTextStart = n;
            this.select(this.m_userTypedTextStart, this.m_userTypedTextStart);
        }
    }

    protected class ConsoleReader
    extends Reader {
        protected char[] m_buffer = new char[4096];
        protected int m_nextCharToRead = 0;
        protected int m_firstFreeChar = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addToBuffer(String string) {
            Object object = this.lock;
            synchronized (object) {
                if (this.m_nextCharToRead == this.m_firstFreeChar) {
                    this.m_nextCharToRead = 0;
                    this.m_firstFreeChar = 0;
                } else if (this.m_nextCharToRead != 0) {
                    System.arraycopy(this.m_buffer, this.m_nextCharToRead, this.m_buffer, 0, this.m_firstFreeChar - this.m_nextCharToRead);
                    this.m_nextCharToRead = 0;
                    this.m_firstFreeChar = 0;
                }
                if (this.m_firstFreeChar + string.length() > this.m_buffer.length) {
                    char[] cArray = new char[this.m_firstFreeChar + string.length()];
                    System.arraycopy(this.m_buffer, 0, cArray, 0, this.m_buffer.length);
                    this.m_buffer = cArray;
                }
                string.getChars(0, string.length(), this.m_buffer, this.m_firstFreeChar);
                this.m_firstFreeChar += string.length();
                this.notifyAll();
            }
        }

        public void close() throws IOException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(char[] cArray, int n, int n2) throws IOException {
            ConsoleTextArea.this.m_writer.flush();
            Object object = this.lock;
            synchronized (object) {
                while (this.m_nextCharToRead == this.m_firstFreeChar) {
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        throw new IOException("Read interruipted.");
                    }
                }
                int n3 = Math.min(this.m_firstFreeChar - this.m_nextCharToRead, n2);
                System.arraycopy(this.m_buffer, this.m_nextCharToRead, cArray, n, n3);
                this.m_nextCharToRead += n3;
                return n3;
            }
        }
    }

    protected class ConsoleWriter
    extends Writer
    implements ActionListener {
        protected final char[] m_buffer = new char[4096];
        protected final Timer m_timer = new Timer(500, this);
        protected int m_firstFreeChar;

        public ConsoleWriter() {
            this.m_timer.setRepeats(false);
            this.m_firstFreeChar = 0;
        }

        public void close() {
            this.flush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush() {
            Object object = this.lock;
            synchronized (object) {
                if (this.m_firstFreeChar > 0) {
                    final String string = new String(this.m_buffer, 0, this.m_firstFreeChar);
                    this.m_firstFreeChar = 0;
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ConsoleTextArea.this.replaceSelection(string);
                            ConsoleTextArea.this.m_userTypedTextStart = ConsoleTextArea.this.getDocument().getLength();
                            ConsoleTextArea.this.select(ConsoleTextArea.this.m_userTypedTextStart, ConsoleTextArea.this.m_userTypedTextStart);
                        }
                    });
                    this.m_timer.stop();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(char[] cArray, int n, int n2) {
            Object object = this.lock;
            synchronized (object) {
                int n3 = n + n2;
                while (n != n3) {
                    int n4 = Math.min(this.m_buffer.length - this.m_firstFreeChar, n2);
                    if (n4 == 0) continue;
                    System.arraycopy(cArray, n, this.m_buffer, this.m_firstFreeChar, n4);
                    n2 -= n4;
                    n += n4;
                    boolean bl = this.m_firstFreeChar == 0;
                    this.m_firstFreeChar += n4;
                    if (this.m_firstFreeChar >= this.m_buffer.length) {
                        this.flush();
                        continue;
                    }
                    if (!bl) continue;
                    this.m_timer.start();
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.flush();
        }
    }

    protected class ConsoleDocument
    extends PlainDocument {
        protected ConsoleDocument() {
        }

        public void remove(int n, int n2) throws BadLocationException {
            if (n >= ConsoleTextArea.this.m_userTypedTextStart) {
                super.remove(n, n2);
            }
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (n >= ConsoleTextArea.this.m_userTypedTextStart) {
                super.insertString(n, string, attributeSet);
            }
        }
    }
}

