/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.ontocat.virtual;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.log4j.Logger;
import uk.ac.ebi.ontocat.OntologyService;
import uk.ac.ebi.ontocat.OntologyServiceException;
import uk.ac.ebi.ontocat.OntologyTerm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortedSubsetDecorator
implements InvocationHandler {
    private Object target;
    private List<String> sortOrder;
    private static final Logger log = Logger.getLogger(SortedSubsetDecorator.class);

    private SortedSubsetDecorator(Object obj, List<String> sortOrder) {
        this.target = obj;
        this.sortOrder = sortOrder;
        Collections.reverse(this.sortOrder);
    }

    private static Object createProxy(Object obj, List<String> sortOrder) throws OntologyServiceException {
        try {
            obj.getClass().getMethod("searchAll", String.class, OntologyService.SearchOptions[].class);
            obj.getClass().getMethod("searchOntology", String.class, String.class, OntologyService.SearchOptions[].class);
        }
        catch (Exception e) {
            log.fatal("Signature has changed in proxy pattern!");
            throw new OntologyServiceException(e);
        }
        return Proxy.newProxyInstance(obj.getClass().getClassLoader(), obj.getClass().getInterfaces(), (InvocationHandler)new SortedSubsetDecorator(obj, sortOrder));
    }

    public static OntologyService getService(OntologyService os, List<String> sortOrder) throws OntologyServiceException {
        return (OntologyService)SortedSubsetDecorator.createProxy(os, sortOrder);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        List<OntologyTerm> result = null;
        try {
            if (method.getName().equalsIgnoreCase("searchOntology") && !this.sortOrder.contains(args[0])) {
                log.debug((String)args[0] + " ontology explicitly set outside scope");
                return null;
            }
            result = method.invoke(this.target, args);
            if (method.getName().equalsIgnoreCase("searchAll")) {
                result = this.searchAllRanked(result);
            }
        }
        catch (InvocationTargetException e) {
            log.error(method.getName() + " throws " + e.getCause());
        }
        return result;
    }

    private List<OntologyTerm> searchAllRanked(List<OntologyTerm> result) throws OntologyServiceException {
        for (int i = result.size() - 1; i >= 0; --i) {
            if (this.sortOrder.contains(result.get(i).getOntologyAccession())) continue;
            result.remove(i);
        }
        Collections.sort(result, new OntologyRankComparator());
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OntologyRankComparator
    implements Comparator<OntologyTerm> {
        private OntologyRankComparator() {
        }

        @Override
        public int compare(OntologyTerm term0, OntologyTerm term1) {
            if (SortedSubsetDecorator.this.sortOrder.indexOf(term0.getOntologyAccession()) > SortedSubsetDecorator.this.sortOrder.indexOf(term1.getOntologyAccession())) {
                return -1;
            }
            if (SortedSubsetDecorator.this.sortOrder.indexOf(term0.getOntologyAccession()) < SortedSubsetDecorator.this.sortOrder.indexOf(term1.getOntologyAccession())) {
                return 1;
            }
            return 0;
        }
    }
}

