
## ----setup, echo=FALSE---------------------------------------------------
suppressWarnings(suppressPackageStartupMessages(library(knitr)))
options(width=80)


## ----wrap-hook, echo=FALSE-----------------------------------------------
hook_output = knit_hooks$get('output')
knit_hooks$set(output = function(x, options) {
  # this hook is used only when the linewidth option is not NULL
  if (!is.null(n <- options$linewidth)) {
    x = knitr:::split_lines(x)
    # any lines wider than n should be wrapped
    if (any(nchar(x) > n)) x = strwrap(x, width = n)
    x = paste(x, collapse = '\n')
  }
  hook_output(x, options)
})


## ----interactiveDisplay-load, echo=FALSE---------------------------------
suppressWarnings(suppressPackageStartupMessages(library(interactiveDisplay)))


## ----SummarizedExperiment_demo, eval=FALSE-------------------------------
## data(se)
## display(se)


## ----GRanges_demo, eval=FALSE--------------------------------------------
## data(mmgr)
## display(mmgr)


## ----GRangesList_demo, eval=FALSE----------------------------------------
## data(mmgrl)
## display(mmgrl)


## ----ExpressionSet_demo, eval=FALSE--------------------------------------
## data(expr)
## display(expr)


## ----dataframe_demo, eval=FALSE------------------------------------------
## mtcars2 <- display(mtcars)


## ----gridsvgjs_demo, eval=FALSE------------------------------------------
## library(ggplot2)
## data(mtcars)
## qp <- qplot(mpg, data=mtcars, geom="density", fill=factor(cyl), alpha=I(.4))
## gridsvgjs(qp)


## ----bicgo_demo, eval=FALSE----------------------------------------------
## data(expr)
## bicgo(expr)


