### R code from vignette source 'inSilicoDb2.Rnw'

###################################################
### code chunk number 1: getDatasetInfo
###################################################

library("inSilicoDb");

eset = getDatasetInfo("GSE781", "GPL96");
print(eset);

## We check the availability of following normalizations for series GSE781 on platform GPL97
norms = c("FRMA", "ORIGINAL")
output = sapply(norms, function(n) {
	tryCatch({
			eset <- getDatasetInfo("GSE781", "GPL97", norm = n);
			eset$norm;
		}, error = function(e) {
			"Unavailable"
		});
	});

print(output);

# We can thus conclude that the series GSE781 on platform GPL97 does not support FRMA


###################################################
### code chunk number 2: getPlatformList
###################################################
platforms = getPlatformList();

print(platforms);

FRMAplatforms = getPlatformList(norm = "FRMA");

print(FRMAplatforms);



###################################################
### code chunk number 3: curated_dataset
###################################################
# without curated data
eset = getDataset("GSE4635", "GPL96", format = "ESET"); 
# with curated data
cureset = getDataset("GSE4635", "GPL96", format = "CURESET", curation = 9016);

print(phenoData(eset));
print(phenoData(cureset));


###################################################
### code chunk number 4: getCurationInfo
###################################################
default = getDefaultCuration("GSE4635");

print(default);


getCurationInfo("GSE4635");



###################################################
### code chunk number 5: SCAN_and_UPC
###################################################
scan = getDataset("GSE7670", "GPL96", norm = "SCAN", features = "gene");
# example of values in SCAN normalization
print(exprs(scan)[1:10, 1:5]);
upc = getDataset("GSE7670", "GPL96", norm = "UPC", features = "gene");
# example of values in UPC normalization
print(exprs(upc)[1:10, 1:5]);


###################################################
### code chunk number 6: inSilicoDb2.Rnw:135-136
###################################################
sessionInfo()


