/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.gaggle.experiment.metadata;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.systemsbiology.gaggle.experiment.metadata.Condition;
import org.systemsbiology.gaggle.experiment.metadata.DataSetDescription;
import org.systemsbiology.gaggle.experiment.metadata.MetaData;
import org.systemsbiology.gaggle.experiment.repository.ExperimentRepository;
import org.systemsbiology.gaggle.experiment.repository.ExperimentRepositoryFactory;

public class MetaDataNavigator {
    String repositoryUri;
    HashMap tree;
    HashMap titleToExperimentsHash;
    HashMap nameToExperimentsHash;
    HashMap perturbationsListToExperimentHash;
    Map<String, MetaData> conditionNameToExperimentHash = new HashMap<String, MetaData>();

    public MetaDataNavigator(String repositoryUri) throws Exception {
        this.repositoryUri = repositoryUri;
        this.tree = new HashMap();
        this.titleToExperimentsHash = new HashMap();
        this.nameToExperimentsHash = new HashMap();
        this.perturbationsListToExperimentHash = new HashMap();
        this.loadMetaData();
        this.buildSimpleTree();
    }

    public String getUriBase() {
        if (!this.repositoryUri.trim().endsWith(".xml")) {
            return this.repositoryUri;
        }
        int lastSeparator = this.repositoryUri.lastIndexOf(File.separator);
        if (lastSeparator > 0) {
            return this.repositoryUri.substring(0, lastSeparator);
        }
        return "";
    }

    public HashMap getPerturbationExperimentHash() {
        return this.perturbationsListToExperimentHash;
    }

    private void absolutizeDataSetUrisIfNecessary(MetaData experiment) {
        DataSetDescription[] dsds = experiment.getDataSetDescriptions();
        for (int i = 0; i < dsds.length; ++i) {
            String uri = dsds[i].getUri().trim();
            boolean hasProtocol = uri.indexOf("://") > 0;
            char firstChar = uri.charAt(0);
            if (hasProtocol || !Character.isLetterOrDigit(firstChar)) continue;
            String newUri = this.getUriBase() + "/" + uri;
            dsds[i].setUri(newUri);
        }
    }

    protected void loadMetaData() throws Exception {
        ExperimentRepository repos = ExperimentRepositoryFactory.create((String)this.repositoryUri);
        Object[] experimentNames = repos.getExperimentNames();
        Arrays.sort(experimentNames);
        for (int i = 0; i < experimentNames.length; ++i) {
            Object experimentName = experimentNames[i];
            MetaData experiment = repos.getMetaData((String)experimentNames[i]);
            String experimentTitle = experiment.getTitle();
            this.absolutizeDataSetUrisIfNecessary(experiment);
            if (this.titleToExperimentsHash.containsKey(experimentTitle)) {
                String msg = "warning!  skipping duplicate experiment title: " + experimentTitle + " found in metadata.";
                System.err.println(msg);
            }
            this.titleToExperimentsHash.put(experimentTitle, experiment);
            this.nameToExperimentsHash.put(experimentName, experiment);
            for (Condition cond : experiment.getConditions()) {
                this.conditionNameToExperimentHash.put(cond.getAlias(), experiment);
            }
        }
    }

    public Condition getConditionForSpecificExperiment(String conditionName, String experimentName) {
        MetaData md = (MetaData)this.titleToExperimentsHash.get(experimentName);
        return md.getCondition(conditionName);
    }

    public MetaData getMetaDataForCondition(String conditionName) {
        return this.conditionNameToExperimentHash.get(conditionName);
    }

    public String[] getExperimentNames() {
        return this.nameToExperimentsHash.keySet().toArray(new String[0]);
    }

    public String[] getExperimentTitles() {
        return this.titleToExperimentsHash.keySet().toArray(new String[0]);
    }

    public String[] getPerturbationStrings() {
        Object[] hashMapKeys = this.perturbationsListToExperimentHash.keySet().toArray(new String[0]);
        Arrays.sort(hashMapKeys);
        return hashMapKeys;
    }

    public HashMap getExperimentsHashedByName() {
        return this.nameToExperimentsHash;
    }

    public HashMap getExperimentsHashedByTitle() {
        return this.titleToExperimentsHash;
    }

    public MetaData getExperimentByTitle(String experimentTitle) {
        return (MetaData)this.titleToExperimentsHash.get(experimentTitle);
    }

    public MetaData getExperimentByName(String experimentName) {
        if (this.nameToExperimentsHash.containsKey(experimentName)) {
            return (MetaData)this.nameToExperimentsHash.get(experimentName);
        }
        return null;
    }

    protected String createColonSeparatedString(String[] perturbationList) {
        StringBuffer sb = new StringBuffer();
        sb.append(perturbationList[0]);
        for (int i = 1; i < perturbationList.length; ++i) {
            sb.append(":");
            sb.append(perturbationList[i]);
        }
        return sb.toString();
    }

    public ArrayList findExperimentKeyForPerturbation(String[] perturbationList) {
        ArrayList<String[]> result = new ArrayList<String[]>();
        if (perturbationList.length == 0) {
            return result;
        }
        String target = this.createColonSeparatedString(perturbationList);
        String[] perturbationStrings = this.getPerturbationStrings();
        for (int i = 0; i < perturbationStrings.length; ++i) {
            boolean isAColon;
            String oneExperimentsPerturbationString = perturbationStrings[i];
            if (target.equals(oneExperimentsPerturbationString)) {
                result.add(new String[]{oneExperimentsPerturbationString, null});
                continue;
            }
            if (target.indexOf(oneExperimentsPerturbationString) == 0) {
                char nextCharFollowingMatch = target.charAt(oneExperimentsPerturbationString.length());
                if (nextCharFollowingMatch != ':') continue;
                int start = oneExperimentsPerturbationString.length() + 1;
                String rawCondition = target.substring(start);
                result.add(new String[]{oneExperimentsPerturbationString, rawCondition});
                continue;
            }
            if (oneExperimentsPerturbationString.indexOf(target) != 0) continue;
            int nextCharPosition = target.length();
            char nextChar = oneExperimentsPerturbationString.charAt(nextCharPosition);
            boolean bl = isAColon = nextChar == ':';
            if (!isAColon) break;
            result.add(new String[]{oneExperimentsPerturbationString, null});
        }
        return result;
    }

    public MetaData[] getExperimentByPerturbationList(String perturbationString) {
        if (this.perturbationsListToExperimentHash.containsKey(perturbationString)) {
            ArrayList tmp = (ArrayList)this.perturbationsListToExperimentHash.get(perturbationString);
            return tmp.toArray(new MetaData[0]);
        }
        return new MetaData[0];
    }

    public HashMap getTree() {
        return this.tree;
    }

    protected void buildSimpleTree() {
        String[] experimentTitles = this.getExperimentTitles();
        for (int i = 0; i < experimentTitles.length; ++i) {
            String experimentTitle = experimentTitles[i];
            MetaData experiment = this.getExperimentByTitle(experimentTitle);
            HashMap predicates = experiment.getPredicates();
            Set keys = predicates.keySet();
            for (String key : keys) {
                this.addPerturbation(key, (String)predicates.get(key), experiment);
            }
        }
    }

    protected void addPerturbation(String key, String value, MetaData experiment) {
        if (key.contains("perturbation")) {
            String[] perturbations = value.split(":");
            ArrayList list = null;
            list = this.perturbationsListToExperimentHash.containsKey(value) ? (ArrayList)this.perturbationsListToExperimentHash.get(value) : new ArrayList();
            list.add(experiment);
            this.perturbationsListToExperimentHash.put(value, list);
            this.addToTree(experiment, perturbations);
        }
    }

    protected void addToTree(MetaData experiment, String[] perturbations) {
        HashMap currentBranch = this.tree;
        for (int i = 0; i < perturbations.length; ++i) {
            String category = perturbations[i];
            if (!currentBranch.containsKey(category)) {
                currentBranch.put(category, new HashMap());
            }
            currentBranch = (HashMap)currentBranch.get(category);
            if (i != perturbations.length - 1) continue;
            String[] factors = experiment.getVariableNames();
            for (int f = 0; f < factors.length; ++f) {
                String factor = factors[f];
                if (!currentBranch.containsKey(factor)) {
                    currentBranch.put(factor, new HashMap());
                }
                HashMap variableValues = experiment.getVariableValuesWithUnits(factor);
                String[] levels = variableValues.keySet().toArray(new String[0]);
                for (int j = 0; j < levels.length; ++j) {
                    HashMap tmp = (HashMap)currentBranch.get(factor);
                    tmp.put(levels[j], new HashMap());
                }
            }
        }
    }

    public void dumpTree(HashMap node, String currentIndent) {
        if (node.size() == 0) {
            return;
        }
        Object[] children = node.keySet().toArray(new String[0]);
        Arrays.sort(children);
        currentIndent = currentIndent + "  ";
        for (int i = 0; i < children.length; ++i) {
            Object kid = children[i];
            System.out.println(currentIndent + (String)kid);
            this.dumpTree((HashMap)node.get(kid), currentIndent);
        }
    }
}

