### R code from vignette source 'flowCL.Rnw'

###################################################
### code chunk number 1: loadlibs
###################################################
library("flowCL")


###################################################
### code chunk number 2: Parents_query_archive
###################################################
data(Parents_query_archive, Parents_Names)
dir.create ( paste(getwd(),"/flowCL_results/parents_query",sep=""), 
    showWarnings=FALSE, recursive=TRUE )
for (j in 1:length(Parents_Names))
    write.table(Parents_query_archive[[j]],paste(getwd(),"/flowCL_results/parents_query/",
    Parents_Names[[j]], sep=""), sep=",", row.names = FALSE)


###################################################
### code chunk number 3: Date
###################################################
Res <- flowCL("Date")


###################################################
### code chunk number 4: CCR7+CD45RA+_with_visual
###################################################
Res <- flowCL("CCR7+CD45RA+")
Res$Table
tmp <- Res$'CCR7+CD45RA+'
plot(tmp[[1]], nodeAttrs=tmp[[2]], edgeAttrs=tmp[[3]], attrs=tmp[[4]])


###################################################
### code chunk number 5: CCR7+CD45RA+_without_visual
###################################################
Res <- flowCL("CCR7+CD45RA+", VisualSkip = TRUE)


###################################################
### code chunk number 6: CCR7+CD45RA+CD8+
###################################################
Res <- flowCL("CCR7+CD45RA+CD8+", CompInfo = TRUE, OntolNamesTD = TRUE)
tmp <- Res$'CCR7+CD45RA+CD8+'
plot(tmp[[1]], nodeAttrs=tmp[[2]], edgeAttrs=tmp[[3]], attrs=tmp[[4]])


###################################################
### code chunk number 7: HIPC1
###################################################
Res <- flowCL("HIPC", Indices=c(73,54,50), MaxHitsPht=7)
tmp <- Res$'CD3+CD4+CD127-CD25+'
plot(tmp[[1]], nodeAttrs=tmp[[2]], edgeAttrs=tmp[[3]], attrs=tmp[[4]])


###################################################
### code chunk number 8: HIPC2
###################################################
tmp <- Res$'CD3+CD4+CD8-CCR7-CD45RA-'
plot(tmp[[1]], nodeAttrs=tmp[[2]], edgeAttrs=tmp[[3]], attrs=tmp[[4]])


###################################################
### code chunk number 9: HIPC3
###################################################
tmp <- Res$'CD3-CD19+CD20+CD38+CD24+'
plot(tmp[[1]], nodeAttrs=tmp[[2]], edgeAttrs=tmp[[3]], attrs=tmp[[4]])
Res$Table


###################################################
### code chunk number 10: CD3+CD4+CD8-CCR7-CD45RA-
###################################################
x <-"CD3+CD4+CD8-CCR7-CD45RA-"
Res <- flowCL(x)
Res$Cell_Label[[x]][[1]]


