### R code from vignette source 'chipenrich.Rnw'
### Encoding: ISO8859-1

###################################################
### code chunk number 1: chipenrich.Rnw:22-23
###################################################
options(width=60)


###################################################
### code chunk number 2: chipenrich_kegg_mappa
###################################################
library(chipenrich)
library(chipenrich.data)


###################################################
### code chunk number 3: load_peaks
###################################################
data(peaks_E2F4)


###################################################
### code chunk number 4: head_peaks
###################################################
data(peaks_E2F4)
head(peaks_E2F4)


###################################################
### code chunk number 5: list_genomes
###################################################
supported_genomes()


###################################################
### code chunk number 6: list_locusdefs
###################################################
supported_locusdefs()


###################################################
### code chunk number 7: list_genesets
###################################################
supported_genesets()


###################################################
### code chunk number 8: list_methods
###################################################
supported_methods()


###################################################
### code chunk number 9: list_mappas
###################################################
supported_read_lengths()


###################################################
### code chunk number 10: fig1
###################################################
plot_dist_to_tss(peaks = peaks_E2F4, genome = 'hg19')


###################################################
### code chunk number 11: fig2
###################################################
plot_spline_length(peaks = peaks_E2F4, locusdef = 'nearest_tss', genome = 'hg19')


###################################################
### code chunk number 12: fig3
###################################################
plot_spline_length(peaks = peaks_E2F4, locusdef = 'nearest_tss',  genome = 'hg19', use_mappability = T, read_length = 24)


###################################################
### code chunk number 13: chipenrich
###################################################
results = chipenrich(peaks = peaks_E2F4, genesets = "drug_bank", 
	locusdef = "nearest_tss", qc_plots = F, out_name = NULL)
results.ce = results$results[order(results$results$P.value),]
results.ce[1:5,1:5]


###################################################
### code chunk number 14: chipenrich_with_mappa
###################################################
results = chipenrich(peaks = peaks_E2F4,genesets = "kegg_pathway",
	locusdef = "nearest_tss", use_mappability=T, 
	read_length=24, qc_plots = F, out_name = NULL)
results.cem = results$results[order(results$results$P.value),]
results.cem[1:5,1:5]


###################################################
### code chunk number 15: chipenrich_fisher
###################################################
results = chipenrich(peaks = peaks_E2F4, genesets = c("kegg_pathway"), 
	locusdef = "5kb", method = "fet", fisher_alt = "two.sided", qc_plots = F, out_name = NULL)
results.fet = results$results[order(results$results$P.value),]
results.fet[1:5,1:5]


###################################################
### code chunk number 16: show_peaks
###################################################
peaks_to_genes = results$peaks
head(peaks_to_genes)


###################################################
### code chunk number 17: show_results_colnames
###################################################
colnames(results$results)


