## ----knitr, echo=FALSE, results="hide"-----------------------------------
library("knitr")
opts_chunk$set(tidy=FALSE,dev="png",fig.show="as.is",
               fig.width=10,fig.height=6,
               message=FALSE,eval=T,warning=FALSE)

## ----style, eval=TRUE, echo=F, results="asis"-------------------------------------------
BiocStyle::latex()

## ----options, echo=FALSE, eval=TRUE---------------------------------
options(width = 70)

## ----prelim, echo=FALSE, eval=TRUE----------------------------------
library(beadarray)

## ----readingTiff, eval=FALSE----------------------------------------
#  tiff <- readTIFF();
#  data <- readBeadLevelTextFile();

## ----standardProcessing, eval=FALSE---------------------------------
#  bg <- illuminaBackground(tiff, data[,3:4]);
#  tiffSharp <- illuminaSharpen(tiff);
#  fg <- illuminaForeground(tiffSharp, data[,3:4]);
#  finalIntensity <- fg - bg;

## ----creatingObject, eval=FALSE-------------------------------------
#  BLData <- new(Class = "beadLevelData");
#  BLData <- insertBeadData(BLData, array = 1, what = "Grn", data = finalIntensity)

## ----usingReadIllumina, eval=FALSE----------------------------------
#  BLData <- readIllumina();
#  BLData <- insertBeadData(BLData, array = 1, what = "Grn", data = finalIntensity)
#  BLData <- insertBeadData(BLData, array = 1, what = "GrnLog", data = log2(finalIntensity))

## ----alternativeMethods, eval=FALSE---------------------------------
#  bg <- medianBackground(tiff, data[,3:4]);

## ----sessionInfo----------------------------------------------------
sessionInfo()

