/*
 * Decompiled with CFR 0.152.
 */
package reder.application;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import reder.application.MainFrame;
import reder.application.graph.EdgeBank;
import reder.application.graph.LegendBank;
import reder.application.graph.NodeBank;

public class GraphTask
extends JPanel {
    private NodeBank nodeAccount = null;
    private EdgeBank edgeAccount = null;
    private float zoomInOut = 1.0f;
    private Graphics2D g2;
    private boolean nestOnBottom = false;
    private float xHead;
    private float yHead;

    public void setZoom(float zoomInOut) {
        this.zoomInOut = zoomInOut;
    }

    private AlphaComposite makeComposite(float alpha) {
        int type = 3;
        return AlphaComposite.getInstance(type, alpha);
    }

    @Override
    protected void paintComponent(Graphics g) {
        float yA;
        int i;
        boolean b2;
        super.paintComponent(g);
        this.g2 = (Graphics2D)g;
        if (!MainFrame.isSystemOpened() && !MainFrame.isRShell()) {
            ImageIcon icon = new ImageIcon(this.getClass().getResource("/reder/application/resources/front.png"));
            Image image = icon.getImage();
            this.g2.drawImage(image, 0, 0, null);
        }
        this.nestOnBottom = !MainFrame.isSelectedPushEdgeStack();
        int bigg = 100000;
        boolean b1 = MainFrame.EdgeList.size() < bigg;
        boolean bl = b2 = MainFrame.getZoom() >= 0.25;
        if (b1 || b2 || !MainFrame.isSelectedRenderingThreshold()) {
            this.g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        }
        this.g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        Stroke line = new BasicStroke(1.0f);
        this.g2.setStroke(line);
        this.plotLegends();
        if (this.nestOnBottom) {
            this.plotContainers();
        } else {
            this.loadBuffer();
        }
        Line2D.Float edgeline = new Line2D.Float();
        int size = MainFrame.EdgeList.size();
        for (i = 0; i < size && !MainFrame.lockMouse; ++i) {
            this.edgeAccount = MainFrame.EdgeList.get(i);
            if (this.edgeAccount.isToHideEdge() || !this.edgeAccount.isDefaultEdgeAssignmet() && this.nestOnBottom) continue;
            int a = this.edgeAccount.getA();
            NodeBank nodeAccount1 = MainFrame.NodeList.get(a);
            if (!MainFrame.isToShowTree() && this.edgeAccount.getEdgeAssociationType().equals("edgeTree")) continue;
            float xA = nodeAccount1.getBufferX();
            float yA2 = nodeAccount1.getBufferY();
            int b = this.edgeAccount.getB();
            NodeBank nodeAccount2 = MainFrame.NodeList.get(b);
            float xB = nodeAccount2.getBufferX();
            float yB = nodeAccount2.getBufferY();
            if (!MainFrame.getViewArea().contains(xA, yA2) || !MainFrame.getViewArea().contains(xB, yB)) continue;
            this.g2.setColor(this.edgeAccount.getColor());
            this.g2.setStroke(new BasicStroke(this.edgeAccount.getWidth() * this.zoomInOut));
            float xHeadA = xA;
            float yHeadA = yA2;
            float xHeadB = xB;
            float yHeadB = yB;
            if (MainFrame.getShowDirection()) {
                GeneralPath arrowB;
                GeneralPath arrowA;
                GeneralPath arrowB2;
                if (this.edgeAccount.getArrowDirection() == 1) {
                    arrowB2 = this.setArrow(xB, yB, xA, yA2, nodeAccount2.getNodeSize(), this.edgeAccount.getWidth(), nodeAccount2.getNodeShape(), this.edgeAccount.getArrowLength(), this.edgeAccount.getArrowAngle(), 1, nodeAccount2.getNodeLineWidth());
                    this.g2.fill(arrowB2);
                    this.g2.draw(arrowB2);
                    xHeadB = this.xHead;
                    yHeadB = this.yHead;
                } else if (this.edgeAccount.getArrowDirection() == -1) {
                    this.g2.setStroke(new BasicStroke(this.edgeAccount.getWidth() / 1.5f * this.zoomInOut));
                    arrowB2 = this.setArrow(xB, yB, xA, yA2, nodeAccount2.getNodeSize(), this.edgeAccount.getWidth(), nodeAccount2.getNodeShape(), (double)this.edgeAccount.getArrowLength() * 0.5, 90.0, -1, nodeAccount2.getNodeLineWidth());
                    this.g2.fill(arrowB2);
                    this.g2.draw(arrowB2);
                    xHeadB = this.xHead;
                    yHeadB = this.yHead;
                } else if (this.edgeAccount.getArrowDirection() == 2) {
                    arrowA = this.setArrow(xA, yA2, xB, yB, nodeAccount1.getNodeSize(), this.edgeAccount.getWidth(), nodeAccount1.getNodeShape(), this.edgeAccount.getArrowLength(), this.edgeAccount.getArrowAngle(), 1, nodeAccount1.getNodeLineWidth());
                    this.g2.fill(arrowA);
                    this.g2.draw(arrowA);
                    xHeadA = this.xHead;
                    yHeadA = this.yHead;
                } else if (this.edgeAccount.getArrowDirection() == -2) {
                    this.g2.setStroke(new BasicStroke(this.edgeAccount.getWidth() / 1.5f * this.zoomInOut));
                    arrowA = this.setArrow(xA, yA2, xB, yB, nodeAccount1.getNodeSize(), this.edgeAccount.getWidth(), nodeAccount1.getNodeShape(), (double)this.edgeAccount.getArrowLength() * 0.5, 90.0, -1, nodeAccount1.getNodeLineWidth());
                    this.g2.fill(arrowA);
                    this.g2.draw(arrowA);
                    xHeadA = this.xHead;
                    yHeadA = this.yHead;
                } else if (this.edgeAccount.getArrowDirection() == 3) {
                    arrowA = this.setArrow(xA, yA2, xB, yB, nodeAccount1.getNodeSize(), this.edgeAccount.getWidth(), nodeAccount1.getNodeShape(), this.edgeAccount.getArrowLength(), this.edgeAccount.getArrowAngle(), 1, nodeAccount1.getNodeLineWidth());
                    this.g2.fill(arrowA);
                    this.g2.draw(arrowA);
                    xHeadA = this.xHead;
                    yHeadA = this.yHead;
                    arrowB = this.setArrow(xB, yB, xA, yA2, nodeAccount2.getNodeSize(), this.edgeAccount.getWidth(), nodeAccount2.getNodeShape(), this.edgeAccount.getArrowLength(), this.edgeAccount.getArrowAngle(), 1, nodeAccount2.getNodeLineWidth());
                    this.g2.fill(arrowB);
                    this.g2.draw(arrowB);
                    xHeadB = this.xHead;
                    yHeadB = this.yHead;
                } else if (this.edgeAccount.getArrowDirection() == -3) {
                    this.g2.setStroke(new BasicStroke(this.edgeAccount.getWidth() / 1.5f * this.zoomInOut));
                    arrowA = this.setArrow(xA, yA2, xB, yB, nodeAccount1.getNodeSize(), this.edgeAccount.getWidth(), nodeAccount1.getNodeShape(), (double)this.edgeAccount.getArrowLength() * 0.5, 90.0, -1, nodeAccount1.getNodeLineWidth());
                    this.g2.fill(arrowA);
                    this.g2.draw(arrowA);
                    xHeadA = this.xHead;
                    yHeadA = this.yHead;
                    arrowB = this.setArrow(xB, yB, xA, yA2, nodeAccount2.getNodeSize(), this.edgeAccount.getWidth(), nodeAccount2.getNodeShape(), (double)this.edgeAccount.getArrowLength() * 0.5, 90.0, -1, nodeAccount2.getNodeLineWidth());
                    this.g2.fill(arrowB);
                    this.g2.draw(arrowB);
                    xHeadB = this.xHead;
                    yHeadB = this.yHead;
                } else if (this.edgeAccount.getArrowDirection() == 4) {
                    arrowB2 = this.setArrow(xB, yB, xA, yA2, nodeAccount2.getNodeSize(), this.edgeAccount.getWidth(), nodeAccount2.getNodeShape(), this.edgeAccount.getArrowLength(), this.edgeAccount.getArrowAngle(), 1, nodeAccount2.getNodeLineWidth());
                    this.g2.fill(arrowB2);
                    this.g2.draw(arrowB2);
                    xHeadB = this.xHead;
                    yHeadB = this.yHead;
                    this.g2.setStroke(new BasicStroke(this.edgeAccount.getWidth() / 1.5f * this.zoomInOut));
                    GeneralPath arrowA2 = this.setArrow(xA, yA2, xB, yB, nodeAccount1.getNodeSize(), this.edgeAccount.getWidth(), nodeAccount1.getNodeShape(), (double)this.edgeAccount.getArrowLength() * 0.5, 90.0, -1, nodeAccount1.getNodeLineWidth());
                    this.g2.fill(arrowA2);
                    this.g2.draw(arrowA2);
                    xHeadA = this.xHead;
                    yHeadA = this.yHead;
                } else if (this.edgeAccount.getArrowDirection() == -4) {
                    arrowA = this.setArrow(xA, yA2, xB, yB, nodeAccount1.getNodeSize(), this.edgeAccount.getWidth(), nodeAccount1.getNodeShape(), this.edgeAccount.getArrowLength(), this.edgeAccount.getArrowAngle(), 1, nodeAccount1.getNodeLineWidth());
                    this.g2.fill(arrowA);
                    this.g2.draw(arrowA);
                    xHeadA = this.xHead;
                    yHeadA = this.yHead;
                    this.g2.setStroke(new BasicStroke(this.edgeAccount.getWidth() / 1.5f * this.zoomInOut));
                    arrowB = this.setArrow(xB, yB, xA, yA2, nodeAccount2.getNodeSize(), this.edgeAccount.getWidth(), nodeAccount2.getNodeShape(), (double)this.edgeAccount.getArrowLength() * 0.5, 90.0, -1, nodeAccount2.getNodeLineWidth());
                    this.g2.fill(arrowB);
                    this.g2.draw(arrowB);
                    xHeadB = this.xHead;
                    yHeadB = this.yHead;
                }
            }
            edgeline.setLine(xHeadA, yHeadA, xHeadB, yHeadB);
            line = this.setLineType(this.edgeAccount.getWidth(), this.edgeAccount.getType(), this.zoomInOut);
            this.g2.setStroke(line);
            this.g2.draw(edgeline);
        }
        if (!this.nestOnBottom) {
            this.plotContainers();
        }
        for (i = 0; i < MainFrame.NodeList.size() && !MainFrame.lockMouse; ++i) {
            this.nodeAccount = MainFrame.NodeList.get(i);
            float rz = (float)this.nodeAccount.getRelativeSize();
            float xA = this.nodeAccount.getBufferX();
            yA = this.nodeAccount.getBufferY();
            int k = this.nodeAccount.getNumParceiros();
            if (!MainFrame.getShowIsoletedNodes() && k == 0 || this.nodeAccount.isContainer() || this.nodeAccount.isMock() || !MainFrame.getViewArea().contains(xA, yA)) continue;
            Shape node = this.getNode(this.nodeAccount.getNodeShape(), xA, yA, this.nodeAccount.getW(), this.nodeAccount.getH(), rz, this.zoomInOut);
            if (this.nodeAccount.isNodeGradient()) {
                GradientPaint MACwhiteToColor;
                float macH;
                float macW;
                float macY;
                float macX;
                if (this.nodeAccount.getNodeShape().equals("ELLIPSE") || this.nodeAccount.getNodeShape().equals("ROUNDED_RECTANGLE")) {
                    macX = xA - this.nodeAccount.getW() / 2.0f * this.zoomInOut * rz;
                    macY = yA - this.nodeAccount.getH() / 2.0f * this.zoomInOut * rz;
                    macW = macX + this.nodeAccount.getW() * this.zoomInOut * rz;
                    macH = macY + this.nodeAccount.getH() * this.zoomInOut * rz;
                    MACwhiteToColor = new GradientPaint(macX, macY, Color.WHITE, macW, macH, this.nodeAccount.getNodeColor());
                    this.g2.setPaint(MACwhiteToColor);
                } else {
                    macX = xA - this.nodeAccount.getW() / 2.0f * this.zoomInOut * rz;
                    macY = yA - this.nodeAccount.getH() / 2.0f * this.zoomInOut * rz;
                    macW = macX + this.nodeAccount.getW() * this.zoomInOut * rz;
                    macH = macY + this.nodeAccount.getH() * this.zoomInOut * rz;
                    MACwhiteToColor = new GradientPaint(macX, macY, Color.WHITE, macW, macH, this.nodeAccount.getNodeColor());
                    this.g2.setPaint(MACwhiteToColor);
                }
            } else {
                this.g2.setColor(this.nodeAccount.getNodeColor());
            }
            this.g2.fill(node);
            this.g2.setColor(this.nodeAccount.getLineColor());
            float sz = this.nodeAccount.getNodeLineWidth() * this.zoomInOut * rz;
            if (this.nodeAccount.getNodeShape().equals("RECTANGLE")) {
                this.g2.setStroke(new BasicStroke(sz, 2, 1));
            } else {
                this.g2.setStroke(new BasicStroke(sz, 0, 2));
            }
            this.g2.draw(node);
            if ((double)(this.nodeAccount.getNodeSize() * this.zoomInOut * rz) < MainFrame.getLabelThreshold() || MainFrame.isSelectedPerimeterEffect() || !((double)((float)this.nodeAccount.getFont().getSize() * this.zoomInOut * rz) >= 3.5) || !this.nodeAccount.legendIsOn()) continue;
            this.g2.setColor(this.nodeAccount.getFontColor());
            this.g2.setFont(new Font(this.nodeAccount.getFont().getFontName(), this.nodeAccount.getFont().getStyle(), (int)((float)this.nodeAccount.getFont().getSize() * this.zoomInOut * rz)));
            this.g2.drawString(this.nodeAccount.getAliases(), xA - this.nodeAccount.getW() * this.zoomInOut * rz / 2.0f * (this.nodeAccount.getFontX() / 10.0f), yA - this.nodeAccount.getH() * this.zoomInOut * rz / 2.0f * (this.nodeAccount.getFontY() / 10.0f));
        }
        if (MainFrame.isSelectedPerimeterEffect()) {
            for (i = 0; i < MainFrame.NodeList.size() && !MainFrame.lockMouse; ++i) {
                this.nodeAccount = MainFrame.NodeList.get(i);
                float rz = (float)this.nodeAccount.getRelativeSize();
                if ((double)(this.nodeAccount.getNodeSize() * this.zoomInOut * rz) < MainFrame.getLabelThreshold()) continue;
                float xA = this.nodeAccount.getBufferX();
                yA = this.nodeAccount.getBufferY();
                int k = this.nodeAccount.getNumParceiros();
                if (!MainFrame.getShowIsoletedNodes() && k == 0 || this.nodeAccount.isContainer() || this.nodeAccount.isMock() || !MainFrame.getViewArea().contains(xA, yA) || !((double)((float)this.nodeAccount.getFont().getSize() * this.zoomInOut * rz) >= 3.5) || !this.nodeAccount.legendIsOn()) continue;
                this.g2.setColor(this.nodeAccount.getFontColor());
                this.g2.setFont(new Font(this.nodeAccount.getFont().getFontName(), this.nodeAccount.getFont().getStyle(), (int)((float)this.nodeAccount.getFont().getSize() * this.zoomInOut * rz)));
                this.g2.drawString(this.nodeAccount.getAliases(), xA - this.nodeAccount.getW() * this.zoomInOut * rz / 2.0f * (this.nodeAccount.getFontX() / 10.0f), yA - this.nodeAccount.getH() * this.zoomInOut * rz / 2.0f * (this.nodeAccount.getFontY() / 10.0f));
            }
        }
        this.g2.setStroke(new BasicStroke(1.0f));
        if (MainFrame.getDragArea() != null) {
            Rectangle2D areaSelect = MainFrame.getDragArea();
            this.g2.setColor(new Color(255, 204, 0));
            this.g2.draw(areaSelect);
        }
    }

    private void loadBuffer() {
        for (int i = 0; i < MainFrame.NodeList.size(); ++i) {
            MainFrame.NodeList.get(i).loadBuffer();
        }
    }

    private void plotLegends() {
        Line2D.Float edgeline = new Line2D.Float();
        for (int i = 0; i < MainFrame.LegendList.size() && !MainFrame.lockMouse; ++i) {
            float mb;
            boolean notedge;
            LegendBank legAccount = MainFrame.LegendList.get(i);
            float rz = (float)legAccount.getRelativeSize();
            float legzoom = legAccount.getLegZoom();
            float xC = legAccount.getX();
            float yC = legAccount.getY();
            float hC = legAccount.getH();
            float wC = legAccount.getW();
            if (!legAccount.isVertical()) {
                wC = legAccount.getH();
                hC = legAccount.getW();
            }
            boolean bl = notedge = !legAccount.getLegType().equals("edgewidth") && !legAccount.getLegType().equals("edgeshape");
            if (notedge) {
                Shape node = this.getNode(legAccount.getLegShape(), xC, yC, legAccount.getW(), legAccount.getH(), rz, legzoom);
                this.g2.setColor(legAccount.getTrueNodeColor());
                this.g2.fill(node);
                this.g2.setColor(legAccount.getLineColor());
                float sz = legAccount.getNodeLineWidth() * legzoom * rz;
                this.g2.setStroke(new BasicStroke(sz, 0, 2));
                this.g2.draw(node);
            } else {
                float xA = xC;
                float yA = yC;
                float xB = xC;
                float yB = yC;
                if (legAccount.isVertical()) {
                    xA -= legAccount.getW() / 2.0f * legzoom;
                    xB += legAccount.getW() / 2.0f * legzoom;
                } else {
                    yA -= legAccount.getH() / 2.0f * legzoom;
                    yB += legAccount.getH() / 2.0f * legzoom;
                }
                this.g2.setColor(legAccount.getNodeLineColor());
                float xHeadA = xA;
                float yHeadA = yA;
                float xHeadB = xB;
                float yHeadB = yB;
                edgeline.setLine(xHeadA, yHeadA, xHeadB, yHeadB);
                Stroke line = this.setLineType(hC, legAccount.getLegShape(), legzoom);
                this.g2.setStroke(line);
                this.g2.draw(edgeline);
            }
            float ftsz = legAccount.getFont().getSize();
            if (ftsz * legzoom * rz < 6.0f && (mb = (float)legAccount.getMembership() / 2.0f) > (float)((int)mb)) continue;
            Font ft = new Font(legAccount.getFont().getFontName(), legAccount.getFont().getStyle(), (int)ftsz);
            this.g2.setFont(ft);
            FontMetrics fm = this.g2.getFontMetrics(legAccount.getFont());
            float newC = xC;
            if (!legAccount.isVertical() && legAccount.getPanelSideTB().equals("top")) {
                newC = xC - (float)fm.stringWidth(legAccount.getAliases()) * legzoom;
            } else if (legAccount.isVertical() && legAccount.getPanelSideRL().equals("right")) {
                newC = xC - (float)fm.stringWidth(legAccount.getAliases()) * legzoom;
            }
            this.g2.setColor(legAccount.getFontColor());
            int theta = 90;
            if (legAccount.isVertical()) {
                theta = 0;
            }
            this.g2.rotate(-Math.toRadians(theta), xC, yC);
            this.g2.drawString(legAccount.getAliases(), newC - wC * legzoom * rz / 2.0f * (legAccount.getFontX() / 10.0f), yC - hC * legzoom * rz / 2.0f * (legAccount.getFontY() / 10.0f));
            this.g2.rotate(Math.toRadians(theta), xC, yC);
            if (legAccount.getMembership() != 0) continue;
            ft = new Font(ft.getFontName(), 1, ft.getSize() + 2);
            this.g2.setFont(ft);
            fm = this.g2.getFontMetrics(ft);
            Rectangle2D st = fm.getStringBounds(legAccount.getLabx(), this.g2);
            float dx = 0.0f;
            float dy = 0.0f;
            if (legAccount.isVertical()) {
                theta = 90;
                dy = (float)(st.getWidth() / 2.0);
                if (legAccount.getPanelSideRL().equals("left")) {
                    dx = (float)st.getHeight();
                }
            } else {
                theta = 0;
                dx = -((float)(st.getWidth() / 2.0));
                if (legAccount.getPanelSideTB().equals("top")) {
                    dy = (float)st.getHeight();
                }
            }
            float tx = legAccount.getTitleX() + dx;
            float ty = legAccount.getTitleY() + dy;
            if (tx < 0.0f) {
                tx = 0.0f;
            }
            if (ty < 0.0f) {
                ty = 0.0f;
            }
            this.g2.rotate(-Math.toRadians(theta), tx, ty);
            this.g2.drawString(legAccount.getLabx(), tx, ty);
            this.g2.rotate(Math.toRadians(theta), tx, ty);
        }
    }

    private void plotContainers() {
        for (int i = 0; i < MainFrame.NodeList.size() && !MainFrame.lockMouse; ++i) {
            this.nodeAccount = MainFrame.NodeList.get(i);
            if (this.nestOnBottom) {
                this.nodeAccount.loadBuffer();
            }
            if (!this.nodeAccount.isContainer() || this.nodeAccount.isContainerHided() || !MainFrame.getShowContainers() && !this.nodeAccount.isSpot() || !MainFrame.getShowIsoletedNodes() && this.nodeAccount.isSpot()) continue;
            float rz = (float)this.nodeAccount.getRelativeSize();
            float xA = this.nodeAccount.getBufferX();
            float yA = this.nodeAccount.getBufferY();
            if (MainFrame.getViewArea().contains(xA, yA)) {
                if (this.nestOnBottom) {
                    this.plotContainerEdge(this.nodeAccount);
                }
                Shape node = this.getNode(this.nodeAccount.getNodeShape(), xA, yA, this.nodeAccount.getW(), this.nodeAccount.getH(), rz, this.zoomInOut);
                if (this.nodeAccount.isNodeGradient()) {
                    float macX = xA - this.nodeAccount.getW() / 2.0f * this.zoomInOut * rz;
                    float macY = yA - this.nodeAccount.getH() / 2.0f * this.zoomInOut * rz;
                    float macW = macX + this.nodeAccount.getW() * this.zoomInOut * rz;
                    float macH = macY + this.nodeAccount.getH() * this.zoomInOut * rz;
                    GradientPaint MACwhiteToColor = new GradientPaint(macX, macY, Color.WHITE, macW, macH, this.nodeAccount.getNodeColor());
                    MACwhiteToColor.getTransparency();
                    this.g2.setPaint(MACwhiteToColor);
                } else {
                    this.g2.setColor(this.nodeAccount.getNodeColor());
                }
                if (this.nodeAccount.isContainerTransparent()) {
                    this.g2.setComposite(this.makeComposite(0.5f));
                }
                this.g2.fill(node);
                this.g2.setColor(this.nodeAccount.getLineColor());
                float lw = this.nodeAccount.getNodeLineWidth();
                if (this.nodeAccount.getDestaque()) {
                    lw *= 3.0f;
                }
                this.g2.setStroke(new BasicStroke(lw * this.zoomInOut * rz));
                Stroke line = this.setContainerLineType(lw * rz, this.nodeAccount.getNodeLineType(), this.nodeAccount.getNodeShape());
                this.g2.setStroke(line);
                this.g2.draw(node);
                this.g2.setStroke(new BasicStroke(this.nodeAccount.getNodeLineWidth() * this.zoomInOut * rz));
                if ((float)this.nodeAccount.getFont().getSize() * this.zoomInOut * rz >= 4.0f && this.nodeAccount.legendIsOn()) {
                    this.g2.setColor(this.nodeAccount.getFontColor());
                    this.g2.setFont(new Font(this.nodeAccount.getFont().getFontName(), this.nodeAccount.getFont().getStyle(), (int)((float)this.nodeAccount.getFont().getSize() * this.zoomInOut * rz)));
                    this.g2.drawString(this.nodeAccount.getAliases(), xA - this.nodeAccount.getW() * this.zoomInOut * rz / 2.0f * (this.nodeAccount.getFontX() / 10.0f), yA - this.nodeAccount.getH() * this.zoomInOut * rz / 2.0f * (this.nodeAccount.getFontY() / 10.0f));
                }
            }
            if (!this.nodeAccount.isContainerTransparent()) continue;
            this.g2.setComposite(this.makeComposite(1.0f));
        }
    }

    private void plotContainerEdge(NodeBank containerAccount) {
        Line2D.Float edgeline = new Line2D.Float();
        int size = containerAccount.getContainerEdgeMapUnique().size();
        for (int i = 0; i < size; ++i) {
            int a;
            NodeBank nodeAccount1;
            int link = containerAccount.getContainerEdgeMapUnique().get(i);
            this.edgeAccount = MainFrame.EdgeList.get(link);
            if (this.edgeAccount.isDefaultEdgeAssignmet() || (nodeAccount1 = MainFrame.NodeList.get(a = this.edgeAccount.getA())).isContainerHided() || nodeAccount1.isContainerTransparent()) continue;
            float xA = nodeAccount1.getX();
            float yA = nodeAccount1.getY();
            int b = this.edgeAccount.getB();
            NodeBank nodeAccount2 = MainFrame.NodeList.get(b);
            if (nodeAccount2.isContainerHided() || nodeAccount2.isContainerTransparent()) continue;
            float xB = nodeAccount2.getX();
            float yB = nodeAccount2.getY();
            if (!MainFrame.getViewArea().contains(xA, yA) || !MainFrame.getViewArea().contains(xB, yB)) continue;
            this.g2.setColor(this.edgeAccount.getColor());
            float xHeadA = xA;
            float yHeadA = yA;
            float xHeadB = xB;
            float yHeadB = yB;
            if (MainFrame.getShowDirection()) {
                GeneralPath arrowB;
                GeneralPath arrowA;
                GeneralPath arrowB2;
                if (this.edgeAccount.getArrowDirection() == 1) {
                    this.g2.setStroke(new BasicStroke(this.edgeAccount.getWidth() * this.zoomInOut));
                    arrowB2 = this.setArrow(xB, yB, xA, yA, nodeAccount2.getNodeSize(), this.edgeAccount.getWidth(), nodeAccount2.getNodeShape(), this.edgeAccount.getArrowLength(), this.edgeAccount.getArrowAngle(), 1, nodeAccount2.getNodeLineWidth());
                    this.g2.fill(arrowB2);
                    this.g2.draw(arrowB2);
                    xHeadB = this.xHead;
                    yHeadB = this.yHead;
                } else if (this.edgeAccount.getArrowDirection() == -1) {
                    this.g2.setStroke(new BasicStroke(this.edgeAccount.getWidth() / 1.5f * this.zoomInOut));
                    arrowB2 = this.setArrow(xB, yB, xA, yA, nodeAccount2.getNodeSize(), this.edgeAccount.getWidth(), nodeAccount2.getNodeShape(), (double)this.edgeAccount.getArrowLength() * 0.5, 90.0, -1, nodeAccount2.getNodeLineWidth());
                    this.g2.fill(arrowB2);
                    this.g2.draw(arrowB2);
                    xHeadB = this.xHead;
                    yHeadB = this.yHead;
                } else if (this.edgeAccount.getArrowDirection() == 2) {
                    this.g2.setStroke(new BasicStroke(this.edgeAccount.getWidth() * this.zoomInOut));
                    arrowA = this.setArrow(xA, yA, xB, yB, nodeAccount1.getNodeSize(), this.edgeAccount.getWidth(), nodeAccount1.getNodeShape(), this.edgeAccount.getArrowLength(), this.edgeAccount.getArrowAngle(), 1, nodeAccount1.getNodeLineWidth());
                    this.g2.fill(arrowA);
                    this.g2.draw(arrowA);
                    xHeadA = this.xHead;
                    yHeadA = this.yHead;
                } else if (this.edgeAccount.getArrowDirection() == -2) {
                    this.g2.setStroke(new BasicStroke(this.edgeAccount.getWidth() / 1.5f * this.zoomInOut));
                    arrowA = this.setArrow(xA, yA, xB, yB, nodeAccount1.getNodeSize(), this.edgeAccount.getWidth(), nodeAccount1.getNodeShape(), (double)this.edgeAccount.getArrowLength() * 0.5, 90.0, -1, nodeAccount1.getNodeLineWidth());
                    this.g2.fill(arrowA);
                    this.g2.draw(arrowA);
                    xHeadA = this.xHead;
                    yHeadA = this.yHead;
                } else if (this.edgeAccount.getArrowDirection() == 3) {
                    this.g2.setStroke(new BasicStroke(this.edgeAccount.getWidth() * this.zoomInOut));
                    arrowA = this.setArrow(xA, yA, xB, yB, nodeAccount1.getNodeSize(), this.edgeAccount.getWidth(), nodeAccount1.getNodeShape(), this.edgeAccount.getArrowLength(), this.edgeAccount.getArrowAngle(), 1, nodeAccount1.getNodeLineWidth());
                    this.g2.fill(arrowA);
                    this.g2.draw(arrowA);
                    xHeadA = this.xHead;
                    yHeadA = this.yHead;
                    arrowB = this.setArrow(xB, yB, xA, yA, nodeAccount2.getNodeSize(), this.edgeAccount.getWidth(), nodeAccount2.getNodeShape(), this.edgeAccount.getArrowLength(), this.edgeAccount.getArrowAngle(), 1, nodeAccount2.getNodeLineWidth());
                    this.g2.fill(arrowB);
                    this.g2.draw(arrowB);
                    xHeadB = this.xHead;
                    yHeadB = this.yHead;
                } else if (this.edgeAccount.getArrowDirection() == -3) {
                    this.g2.setStroke(new BasicStroke(this.edgeAccount.getWidth() / 1.5f * this.zoomInOut));
                    arrowA = this.setArrow(xA, yA, xB, yB, nodeAccount1.getNodeSize(), this.edgeAccount.getWidth(), nodeAccount1.getNodeShape(), (double)this.edgeAccount.getArrowLength() * 0.5, 90.0, -1, nodeAccount1.getNodeLineWidth());
                    this.g2.fill(arrowA);
                    this.g2.draw(arrowA);
                    xHeadA = this.xHead;
                    yHeadA = this.yHead;
                    arrowB = this.setArrow(xB, yB, xA, yA, nodeAccount2.getNodeSize(), this.edgeAccount.getWidth(), nodeAccount2.getNodeShape(), (double)this.edgeAccount.getArrowLength() * 0.5, 90.0, -1, nodeAccount2.getNodeLineWidth());
                    this.g2.fill(arrowB);
                    this.g2.draw(arrowB);
                    xHeadB = this.xHead;
                    yHeadB = this.yHead;
                } else if (this.edgeAccount.getArrowDirection() == 4) {
                    this.g2.setStroke(new BasicStroke(this.edgeAccount.getWidth() * this.zoomInOut));
                    arrowB2 = this.setArrow(xB, yB, xA, yA, nodeAccount2.getNodeSize(), this.edgeAccount.getWidth(), nodeAccount2.getNodeShape(), this.edgeAccount.getArrowLength(), this.edgeAccount.getArrowAngle(), 1, nodeAccount2.getNodeLineWidth());
                    this.g2.fill(arrowB2);
                    this.g2.draw(arrowB2);
                    xHeadB = this.xHead;
                    yHeadB = this.yHead;
                    this.g2.setStroke(new BasicStroke(this.edgeAccount.getWidth() / 1.5f * this.zoomInOut));
                    GeneralPath arrowA2 = this.setArrow(xA, yA, xB, yB, nodeAccount1.getNodeSize(), this.edgeAccount.getWidth(), nodeAccount1.getNodeShape(), (double)this.edgeAccount.getArrowLength() * 0.5, 90.0, -1, nodeAccount1.getNodeLineWidth());
                    this.g2.fill(arrowA2);
                    this.g2.draw(arrowA2);
                    xHeadA = this.xHead;
                    yHeadA = this.yHead;
                } else if (this.edgeAccount.getArrowDirection() == -4) {
                    this.g2.setStroke(new BasicStroke(this.edgeAccount.getWidth() * this.zoomInOut));
                    arrowA = this.setArrow(xA, yA, xB, yB, nodeAccount1.getNodeSize(), this.edgeAccount.getWidth(), nodeAccount1.getNodeShape(), this.edgeAccount.getArrowLength(), this.edgeAccount.getArrowAngle(), 1, nodeAccount1.getNodeLineWidth());
                    this.g2.fill(arrowA);
                    this.g2.draw(arrowA);
                    xHeadA = this.xHead;
                    yHeadA = this.yHead;
                    this.g2.setStroke(new BasicStroke(this.edgeAccount.getWidth() / 1.5f * this.zoomInOut));
                    arrowB = this.setArrow(xB, yB, xA, yA, nodeAccount2.getNodeSize(), this.edgeAccount.getWidth(), nodeAccount2.getNodeShape(), (double)this.edgeAccount.getArrowLength() * 0.5, 90.0, -1, nodeAccount2.getNodeLineWidth());
                    this.g2.fill(arrowB);
                    this.g2.draw(arrowB);
                    xHeadB = this.xHead;
                    yHeadB = this.yHead;
                }
            }
            edgeline.setLine(xHeadA, yHeadA, xHeadB, yHeadB);
            Stroke line = this.setLineType(this.edgeAccount.getWidth(), this.edgeAccount.getType(), this.zoomInOut);
            this.g2.setStroke(line);
            this.g2.draw(edgeline);
        }
    }

    private GeneralPath setArrow(float xHead, float yHead, float xTail, float yTail, float nodeSize, float edgeWidth, String nodeType, double ARROW_RELATIVE_LENGTH, double OPENING_ANGLE, int arrowtype, float edgenodewitdh) {
        if (arrowtype < 0 && ARROW_RELATIVE_LENGTH < (double)edgeWidth * 1.5) {
            ARROW_RELATIVE_LENGTH = (double)edgeWidth * 1.5;
        }
        double ARROW_LENGTH = ARROW_RELATIVE_LENGTH * (double)this.zoomInOut;
        double EDGE_TIP_POSITION = ARROW_LENGTH / 2.0;
        double lenToTarget = (double)nodeSize * 20.0 / 2.0 + (double)edgeWidth;
        if (nodeType.equals("RECTANGLE") || nodeType.equals("ROUNDED_RECTANGLE") || nodeType.equals("TRIANGLE")) {
            lenToTarget = (double)nodeSize * 20.0 * Math.sqrt(2.0) / 2.0 + (double)edgeWidth;
        }
        if (arrowtype > 0) {
            lenToTarget *= 1.1;
        } else if (arrowtype < 0) {
            lenToTarget = lenToTarget - (double)edgeWidth * 0.8 + (double)edgenodewitdh;
        }
        lenToTarget *= (double)this.zoomInOut;
        double dx = (double)xHead - (double)xTail;
        double dy = (double)yHead - (double)yTail;
        double ddx = 0.0;
        double ddy = 0.0;
        double xCap = 0.0;
        double yCap = 0.0;
        double h = Math.sqrt(dx * dx + dy * dy);
        double dR = lenToTarget + (5.0 + Math.sqrt(edgeWidth)) * (double)this.zoomInOut;
        if (Math.abs(dx) <= Math.abs(dy)) {
            ddx = dR * Math.abs(dx / h);
            ddy = dR * Math.abs(dy / h);
            xCap = EDGE_TIP_POSITION * Math.abs(dx / h);
            yCap = EDGE_TIP_POSITION * Math.abs(dy / h);
        } else {
            ddx = dR * Math.abs(dx / h);
            ddy = dR * Math.abs(dy / h);
            xCap = EDGE_TIP_POSITION * Math.abs(dx / h);
            yCap = EDGE_TIP_POSITION * Math.abs(dy / h);
        }
        if (xHead > xTail && yHead > yTail) {
            xCap = (dx -= ddx) - xCap;
            yCap = (dy -= ddy) - yCap;
        } else if (xHead < xTail && yHead < yTail) {
            xCap = (dx += ddx) + xCap;
            yCap = (dy += ddy) + yCap;
        } else if (xHead < xTail && yHead > yTail) {
            xCap = (dx += ddx) + xCap;
            yCap = (dy -= ddy) - yCap;
        } else if (xHead > xTail && yHead < yTail) {
            xCap = (dx -= ddx) - xCap;
            yCap = (dy += ddy) + yCap;
        } else if (xHead == xTail && yHead > yTail) {
            yCap = (dy -= ddy) - yCap;
        } else if (xHead == xTail && yHead < yTail) {
            yCap = (dy += ddy) + yCap;
        } else if (yHead == yTail && xHead > xTail) {
            xCap = (dx -= ddx) - xCap;
        } else if (yHead == yTail && xHead < xTail) {
            xCap = (dx += ddx) + xCap;
        }
        xHead = xTail + (float)dx;
        yHead = yTail + (float)dy;
        this.xHead = xTail + (float)xCap;
        this.yHead = yTail + (float)yCap;
        double EDGE_ANGLE = Math.atan2(dy, dx);
        GeneralPath arrow = this.createArrow(ARROW_LENGTH, OPENING_ANGLE, EDGE_ANGLE, xHead, yHead);
        return arrow;
    }

    private GeneralPath createArrow(double ARROW_LENGTH, double OPENING_ANGLE, double EDGE_ANGLE, double xHead, double yHead) {
        OPENING_ANGLE = Math.PI / 180 * OPENING_ANGLE;
        float x1 = (float)(xHead - ARROW_LENGTH * Math.cos(EDGE_ANGLE - OPENING_ANGLE));
        float y1 = (float)(yHead - ARROW_LENGTH * Math.sin(EDGE_ANGLE - OPENING_ANGLE));
        float x2 = (float)(xHead - ARROW_LENGTH * Math.cos(EDGE_ANGLE + OPENING_ANGLE));
        float y2 = (float)(yHead - ARROW_LENGTH * Math.sin(EDGE_ANGLE + OPENING_ANGLE));
        GeneralPath arrow = new GeneralPath();
        arrow.moveTo(x1, y1);
        arrow.lineTo((float)xHead, (float)yHead);
        arrow.lineTo(x2, y2);
        arrow.closePath();
        return arrow;
    }

    private Stroke setLineType(float lineWidth, String type, float zoom) {
        float[] dot;
        float size = lineWidth * zoom;
        String shapeType = type;
        BasicStroke line = null;
        if (shapeType.equals("LONG_DASH")) {
            float[] dash = new float[]{size * 8.0f};
            line = new BasicStroke(size, 2, 2, 10.0f, dash, 0.0f);
        }
        if (shapeType.equals("SOLID")) {
            line = new BasicStroke(size, 0, 2);
        }
        if (shapeType.equals("DOTTED")) {
            dot = new float[]{size * 1.0f, size * 4.0f};
            line = new BasicStroke(size, 2, 2, 10.0f, dot, 0.0f);
        }
        if (shapeType.equals("DOTTED_SHORT")) {
            dot = new float[]{size * 0.1f, size * 4.0f};
            line = new BasicStroke(size, 1, 2, 10.0f, dot, 0.0f);
        }
        return line;
    }

    private Stroke setContainerLineType(float lineWidth, String linetype, String nodetype) {
        float[] dot;
        float size = lineWidth * this.zoomInOut;
        String lineShapeType = linetype;
        String nodeShapeType = nodetype;
        BasicStroke line = null;
        int cap = 2;
        int joint = 1;
        if (nodeShapeType.equals("RECTANGLE")) {
            cap = 2;
            joint = 1;
        }
        if (lineShapeType.equals("LONG_DASH")) {
            float[] dash = new float[]{size * 8.0f};
            line = new BasicStroke(size, cap, joint, 10.0f, dash, 0.0f);
        }
        if (lineShapeType.equals("SOLID")) {
            line = new BasicStroke(size, cap, joint);
        }
        if (lineShapeType.equals("DOTTED")) {
            dot = new float[]{size * 1.0f, size * 4.0f};
            line = new BasicStroke(size, cap, joint, 10.0f, dot, 0.0f);
        }
        if (lineShapeType.equals("DOTTED_SHORT")) {
            dot = new float[]{size * 0.1f, size * 4.0f};
            line = new BasicStroke(size, cap, joint, 10.0f, dot, 0.0f);
        }
        return line;
    }

    public Shape getNode(String nodeType, float x, float y, float w, float h, float rz, float zoom) {
        w = w * zoom * rz;
        h = h * zoom * rz;
        Shape node = nodeType.equals("ELLIPSE") ? this.circleRectangle(x, y, w, h, 1.0f) : (nodeType.equals("RECTANGLE") ? this.circleRectangle(x, y, w, h, 0.0f) : (nodeType.equals("ROUNDED_RECTANGLE") ? this.circleRectangle(x, y, w, h, 0.7f) : (nodeType.equals("TRIANGLE") ? this.triangle(x, y, w, h) : (nodeType.equals("DIAMOND") ? this.diamond(x, y, w, h) : this.circleRectangle(x, y, w, h, 1.0f)))));
        return node;
    }

    private Shape triangle(float x, float y, float w, float h) {
        GeneralPath p0 = new GeneralPath(1);
        p0.moveTo(x - w / 2.0f, y + h / 2.0f);
        p0.lineTo(x, y - h / 2.0f);
        p0.lineTo(x + w / 2.0f, y + h / 2.0f);
        p0.closePath();
        return p0;
    }

    private Shape diamond(float x, float y, float w, float h) {
        GeneralPath p0 = new GeneralPath(1);
        p0.moveTo(x - w / 2.0f, y);
        p0.lineTo(x, y + h / 2.0f);
        p0.lineTo(x + w / 2.0f, y);
        p0.lineTo(x, y - h / 2.0f);
        p0.closePath();
        return p0;
    }

    private Shape circleRectangle(float x, float y, float w, float h, float arc) {
        RoundRectangle2D.Float node = new RoundRectangle2D.Float(x - w / 2.0f, y - h / 2.0f, w, h, w * arc, h * arc);
        return node;
    }
}

