
## ----include=FALSE-------------------------------------------------------
library(DOSE)
library(ReactomePA)
library(clusterProfiler)
library(knitr)
opts_chunk$set(tidy=TRUE,tidy.opts=list(keep.blank.line=FALSE, width.cutoff=50),out.truncate=80,out.lines=6,cache=TRUE,dev='pdf',include=TRUE,fig.width=6,fig.height=6,resolution=150)


## ----options,results='hide',echo=FALSE-----------------------------------
options(digits=3, width=80, prompt=" ", continue=" ")


## ----load sample data----------------------------------------------------
require(DOSE)
data(geneList)
de <- names(geneList)[abs(geneList) > 1]
head(de)
require(ReactomePA)
x <- enrichPathway(gene=de,pvalueCutoff=0.05, readable=T)
head(summary(x))


## ----barplot, fig.cap="barplot of Reactome Pathway enrichment result.", fig.align="center", fig.height=5, fig.width=8, out.width="0.8\\textwidth", fig.pos="h"----
barplot(x, showCategory=8)


## ----cnetplot, fig.cap="cnetplot of Reactome Pathway enrichment result.", fig.align="center", fig.height=16, fig.width=16, out.width="0.9\\textwidth", fig.pos="h"----
cnetplot(x, categorySize="pvalue", foldChange=geneList)


## ----clusterProfiler, fig.cap="ReactomePA with clusterProfiler.", fig.align="center", fig.height=6, fig.width=11, out.width="0.9\\textwidth", fig.pos="h"----
require(clusterProfiler)
data(gcSample)
res <- compareCluster(gcSample, fun="enrichPathway")
plot(res)


## ----GSEA analysis-------------------------------------------------------
y <- gseAnalyzer(geneList, nPerm=100, 
                  minGSSize=120, pvalueCutoff=0.05, 
                  pAdjustMethod="BH", verbose=FALSE)
res <- summary(y)
head(res)


## ----gseaplot, fig.cap="plotting gsea result", fig.align="center", fig.height=6, fig.width=6, out.width="0.6\\textwidth", fig.pos="h"----
topID <- res[1,1]
topID
plot(y, geneSetID = topID)


## ----viewPathway, fig.cap="Reactome Pathway visualization.", fig.align="center", fig.height=16, fig.width=16, out.width="0.9\\textwidth", fig.pos="h"----
viewPathway("E2F mediated regulation of DNA replication", readable=TRUE, foldChange=geneList)


## ----sessInfo, results='asis', echo=FALSE--------------------------------
toLatex(sessionInfo())


