/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.saaj;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.impl.llom.OMTextImpl;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.OperationClient;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.DispatchPhase;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.saaj.SOAPMessageImpl;
import org.apache.axis2.saaj.util.IDGenerator;
import org.apache.axis2.saaj.util.SAAJUtil;
import org.apache.axis2.saaj.util.UnderstandAllHeadersHandler;

public class SOAPConnectionImpl
extends SOAPConnection {
    private boolean closed = false;
    private ServiceClient serviceClient;
    private HashMap unaccessedAttachments = new HashMap();

    public SOAPMessage call(SOAPMessage request, Object endpoint) throws SOAPException {
        OperationClient opClient;
        URL url;
        if (this.closed) {
            throw new SOAPException("SOAPConnection closed");
        }
        try {
            url = endpoint instanceof URL ? (URL)endpoint : new URL(endpoint.toString());
        }
        catch (MalformedURLException e) {
            throw new SOAPException(e.getMessage());
        }
        Options options = new Options();
        options.setTo(new EndpointReference(url.toString()));
        try {
            this.serviceClient = new ServiceClient();
            this.disableMustUnderstandProcessing(this.serviceClient.getAxisConfiguration());
            opClient = this.serviceClient.createClient(ServiceClient.ANON_OUT_IN_OP);
        }
        catch (AxisFault e) {
            throw new SOAPException((Throwable)e);
        }
        options.setProperty("CHARACTER_SET_ENCODING", request.getProperty("javax.xml.soap.character-set-encoding"));
        opClient.setOptions(options);
        if (request.countAttachments() != 0) {
            opClient.getOptions().setProperty("enableMTOM", (Object)"true");
            return this.handleSOAPMessage(request, opClient);
        }
        return this.handleSOAPMessage(request, opClient);
    }

    private void disableMustUnderstandProcessing(AxisConfiguration config) {
        DispatchPhase phase = SOAPConnectionImpl.getDispatchPhase(this.serviceClient.getAxisConfiguration().getInFlowPhases());
        if (phase != null) {
            phase.addHandler((Handler)new UnderstandAllHeadersHandler());
        }
        if ((phase = SOAPConnectionImpl.getDispatchPhase(this.serviceClient.getAxisConfiguration().getInFaultFlowPhases())) != null) {
            phase.addHandler((Handler)new UnderstandAllHeadersHandler());
        }
    }

    private static DispatchPhase getDispatchPhase(List phases) {
        for (Object phase : phases) {
            if (!(phase instanceof DispatchPhase)) continue;
            return (DispatchPhase)phase;
        }
        return null;
    }

    public void close() throws SOAPException {
        if (this.serviceClient != null) {
            try {
                this.serviceClient.cleanup();
            }
            catch (AxisFault axisFault) {
                throw new SOAPException(axisFault.getMessage());
            }
        }
        if (this.closed) {
            throw new SOAPException("SOAPConnection Closed");
        }
        this.closed = true;
    }

    private SOAPMessage handleSOAPMessage(SOAPMessage request, OperationClient opClient) throws SOAPException {
        MessageContext requestMsgCtx = new MessageContext();
        try {
            requestMsgCtx.setEnvelope(this.toOMSOAPEnvelope(request));
            opClient.addMessageContext(requestMsgCtx);
            opClient.execute(true);
            MessageContext msgCtx = opClient.getMessageContext("In");
            SOAPMessage sOAPMessage = this.getSOAPMessage(msgCtx.getEnvelope());
            return sOAPMessage;
        }
        catch (Exception e) {
            throw new SOAPException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                requestMsgCtx.getTransportOut().getSender().cleanup(requestMsgCtx);
            }
            catch (Exception e) {}
        }
    }

    private SOAPMessage getSOAPMessage(SOAPEnvelope respOMSoapEnv) throws SOAPException {
        MessageFactory mf = MessageFactory.newInstance();
        SOAPMessage response = mf.createMessage();
        SOAPPart sPart = response.getSOAPPart();
        javax.xml.soap.SOAPEnvelope env = sPart.getEnvelope();
        SOAPBody body = env.getBody();
        javax.xml.soap.SOAPHeader header = env.getHeader();
        SOAPHeader header2 = respOMSoapEnv.getHeader();
        if (header2 != null) {
            Iterator hbIter = header2.examineAllHeaderBlocks();
            while (hbIter.hasNext()) {
                SOAPHeaderBlock hb = (SOAPHeaderBlock)hbIter.next();
                QName hbQName = hb.getQName();
                SOAPHeaderElement headerEle = header.addHeaderElement(env.createName(hbQName.getLocalPart(), hbQName.getPrefix(), hbQName.getNamespaceURI()));
                Iterator attribIter = hb.getAllAttributes();
                while (attribIter.hasNext()) {
                    OMAttribute attr = (OMAttribute)attribIter.next();
                    QName attrQName = attr.getQName();
                    headerEle.addAttribute(env.createName(attrQName.getLocalPart(), attrQName.getPrefix(), attrQName.getNamespaceURI()), attr.getAttributeValue());
                }
                String role = hb.getRole();
                if (role != null) {
                    headerEle.setActor(role);
                }
                headerEle.setMustUnderstand(hb.getMustUnderstand());
                this.toSAAJElement((SOAPElement)headerEle, (OMNode)hb, response);
            }
        }
        this.toSAAJElement((SOAPElement)body, (OMNode)respOMSoapEnv.getBody(), response);
        if (!this.unaccessedAttachments.isEmpty()) {
            Collection attachments = this.unaccessedAttachments.values();
            for (AttachmentPart attachment : attachments) {
                response.addAttachmentPart(attachment);
            }
        }
        return response;
    }

    private void toSAAJElement(SOAPElement saajEle, OMNode omNode, SOAPMessage saajSOAPMsg) throws SOAPException {
        if (omNode instanceof OMText) {
            return;
        }
        if (omNode instanceof OMElement) {
            OMElement omEle = (OMElement)omNode;
            Iterator childIter = omEle.getChildren();
            while (childIter.hasNext()) {
                OMNode omChildNode = (OMNode)childIter.next();
                SOAPElement saajChildEle = null;
                if (omChildNode instanceof OMText) {
                    OMText omText = (OMText)omChildNode;
                    if (omText.isOptimized()) {
                        DataHandler datahandler = (DataHandler)omText.getDataHandler();
                        AttachmentPart attachment = saajSOAPMsg.createAttachmentPart(datahandler);
                        String id = IDGenerator.generateID();
                        attachment.setContentId(id);
                        attachment.setContentType(datahandler.getContentType());
                        saajSOAPMsg.addAttachmentPart(attachment);
                        saajEle.addAttribute(saajSOAPMsg.getSOAPPart().getEnvelope().createName("href"), "cid:" + id);
                    } else {
                        saajChildEle = saajEle.addTextNode(omText.getText());
                    }
                } else if (omChildNode instanceof OMElement) {
                    OMElement omChildEle = (OMElement)omChildNode;
                    QName omChildQName = omChildEle.getQName();
                    saajChildEle = saajEle.addChildElement(omChildQName.getLocalPart(), omChildQName.getPrefix(), omChildQName.getNamespaceURI());
                    Iterator attribIter = omChildEle.getAllAttributes();
                    while (attribIter.hasNext()) {
                        OMAttribute attr = (OMAttribute)attribIter.next();
                        QName attrQName = attr.getQName();
                        saajChildEle.addAttribute(saajSOAPMsg.getSOAPPart().getEnvelope().createName(attrQName.getLocalPart(), attrQName.getPrefix(), attrQName.getNamespaceURI()), attr.getAttributeValue());
                    }
                }
                this.toSAAJElement(saajChildEle, omChildNode, saajSOAPMsg);
            }
        }
    }

    protected SOAPEnvelope toOMSOAPEnvelope(SOAPMessage saajSOAPMsg) throws SOAPException {
        SOAPEnvelope omSOAPEnv = SAAJUtil.toOMSOAPEnvelope(saajSOAPMsg.getSOAPPart().getDocumentElement());
        HashMap<String, AttachmentPart> attachmentMap = new HashMap<String, AttachmentPart>();
        Iterator attachments = saajSOAPMsg.getAttachments();
        while (attachments.hasNext()) {
            AttachmentPart attachment = (AttachmentPart)attachments.next();
            if (attachment.getContentId() == null || attachment.getContentId().trim().length() == 0) {
                attachment.setContentId(IDGenerator.generateID());
            }
            if (attachment.getDataHandler() == null) {
                throw new SOAPException("Attachment with NULL DataHandler");
            }
            attachmentMap.put(attachment.getContentId(), attachment);
        }
        Set keySet = attachmentMap.keySet();
        Iterator keySetItr = keySet.iterator();
        HashMap<String, String> keyAccessStatus = new HashMap<String, String>();
        while (keySetItr.hasNext()) {
            String key = (String)keySetItr.next();
            keyAccessStatus.put(key, "not-accessed");
        }
        this.insertAttachmentNodes(attachmentMap, (OMElement)omSOAPEnv, keyAccessStatus);
        this.unaccessedAttachments = this.getUnReferencedAttachmentNodes(attachmentMap, (OMElement)omSOAPEnv, keyAccessStatus);
        return omSOAPEnv;
    }

    private void insertAttachmentNodes(Map attachments, OMElement omEnvelope, HashMap keyAccessStatus) throws SOAPException {
        Iterator childIter = omEnvelope.getChildElements();
        while (childIter.hasNext()) {
            OMElement child = (OMElement)childIter.next();
            OMAttribute hrefAttr = child.getAttribute(new QName("href"));
            String contentID = this.getContentID(hrefAttr);
            if (contentID != null) {
                child.build();
                AttachmentPart ap = (AttachmentPart)attachments.get(contentID.trim());
                keyAccessStatus.put(contentID.trim(), "accessed");
                OMTextImpl text = new OMTextImpl((Object)ap.getDataHandler(), true, omEnvelope.getOMFactory());
                child.removeAttribute(hrefAttr);
                child.addChild((OMNode)text);
                continue;
            }
            this.insertAttachmentNodes(attachments, child, keyAccessStatus);
        }
    }

    private HashMap getUnReferencedAttachmentNodes(Map attachments, OMElement omEnvelope, HashMap keyAccessStatus) throws SOAPException {
        HashMap<String, AttachmentPart> unaccessedAttachments = new HashMap<String, AttachmentPart>();
        Set keySet = keyAccessStatus.keySet();
        for (String key : keySet) {
            String keyStatus = (String)keyAccessStatus.get(key);
            if (!"not-accessed".equals(keyStatus)) continue;
            AttachmentPart ap = (AttachmentPart)attachments.get(key);
            unaccessedAttachments.put(key, ap);
            keyAccessStatus.put(key, "accessed");
        }
        return unaccessedAttachments;
    }

    private String getContentID(OMAttribute attr) {
        if (attr == null) {
            return null;
        }
        String contentId = attr.getAttributeValue();
        if (contentId.startsWith("cid:")) {
            contentId = contentId.substring(4);
            return contentId;
        }
        return null;
    }

    public SOAPMessage get(Object to) throws SOAPException {
        int responseCode;
        URL url = null;
        try {
            url = to instanceof URL ? (URL)to : new URL(to.toString());
        }
        catch (MalformedURLException e) {
            throw new SOAPException((Throwable)e);
        }
        boolean isFailure = false;
        HttpURLConnection httpCon = null;
        try {
            httpCon = (HttpURLConnection)url.openConnection();
            httpCon.setDoOutput(true);
            httpCon.setDoInput(true);
            httpCon.setUseCaches(false);
            httpCon.setRequestMethod("GET");
            HttpURLConnection.setFollowRedirects(true);
            httpCon.connect();
            responseCode = httpCon.getResponseCode();
            if (responseCode == 500) {
                isFailure = true;
            } else if (responseCode / 100 != 2) {
                throw new SOAPException("Error response: (" + responseCode + httpCon.getResponseMessage());
            }
        }
        catch (IOException e) {
            throw new SOAPException((Throwable)e);
        }
        SOAPMessageImpl soapMessage = null;
        if (responseCode == 200) {
            try {
                MimeHeaders mimeHeaders = new MimeHeaders();
                int i = 1;
                while (true) {
                    String key = httpCon.getHeaderFieldKey(i);
                    String value = httpCon.getHeaderField(i);
                    if (key == null && value == null) break;
                    if (key != null) {
                        StringTokenizer values = new StringTokenizer(value, ",");
                        while (values.hasMoreTokens()) {
                            mimeHeaders.addHeader(key, values.nextToken().trim());
                        }
                    }
                    ++i;
                }
                InputStream httpInputStream = isFailure ? httpCon.getErrorStream() : httpCon.getInputStream();
                soapMessage = new SOAPMessageImpl(httpInputStream, mimeHeaders);
                httpInputStream.close();
                httpCon.disconnect();
            }
            catch (SOAPException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SOAPException(e.getMessage());
            }
        }
        return soapMessage;
    }
}

