
## ----include=FALSE-------------------------------------------------------
library(knitr)
if(.Platform$OS.type=="windows")
{
    device="pdf"
} else {
    device="jpeg"
}    
opts_chunk$set(dev=device, tidy=TRUE)
opts_chunk$set(progress=TRUE, verbose=TRUE)


## ----include=FALSE-------------------------------------------------------
opts_chunk$set(concordance=TRUE)


## ----echo=FALSE----------------------------------------------------------
options(stringsAsFactors = FALSE);
library(OmicCircos); 
data(UCSC.hg18.chr);
head(UCSC.hg18.chr);


## ----echo=FALSE----------------------------------------------------------
options(stringsAsFactors = FALSE);
library(OmicCircos); 
data(TCGA.BC.gene.exp.2k.60);
head(TCGA.BC.gene.exp.2k.60[,c(1:6)]);


## ----echo=FALSE----------------------------------------------------------
options(stringsAsFactors = FALSE);
library(OmicCircos); 
data(TCGA.BC.fus);
head(TCGA.BC.fus[,c(1:6)]);


## ----echo=FALSE----------------------------------------------------------
options(stringsAsFactors = FALSE);
library(OmicCircos); 
data(UCSC.hs_cyto_mm);
head(UCSC.hs_cyto_mm);


## ----echo=FALSE----------------------------------------------------------
options(stringsAsFactors = FALSE);
library(OmicCircos);
seg.num     <- 10;
ind.num     <- 20;
seg.po      <- c(20:50);
link.num    <- 10;
link.pg.num <- 10;
sim.out     <- sim.circos(seg=seg.num, po=seg.po, ind=ind.num, link=link.num, link.pg=link.pg.num);


## ----echo=FALSE----------------------------------------------------------
head(sim.out$seg.frame[,c(1:3)])


## ----echo=FALSE----------------------------------------------------------
head(sim.out$seg.mapping[,c(1:5)])


## ----echo=FALSE----------------------------------------------------------
head(sim.out$seg.link)


## ----echo=FALSE----------------------------------------------------------
head(sim.out$seg.link.pg)


## ----echo=FALSE----------------------------------------------------------
options(stringsAsFactors = FALSE);
library(OmicCircos);
seg.num     <- 10;
ind.num     <- 20;
seg.po      <- c(20:50);
link.num    <- 10;
link.pg.num <- 10;
sim.out     <- sim.circos(seg=seg.num, po=seg.po, ind=ind.num, link=link.num, link.pg=link.pg.num);
seg.f    <- sim.out$seg.frame;
seg.name <- paste("chr", 1:seg.num, sep="");
db       <- segAnglePo(seg.f, seg=seg.name);
db[,2]   <- round(as.numeric(db[,2]), 3);
db[,3]   <- round(as.numeric(db[,3]), 3);
db


## ----echo=FALSE----------------------------------------------------------
options(stringsAsFactors = FALSE);
library(OmicCircos);
set.seed(1234);
seg.num     <- 10;
ind.num     <- 20;
seg.po      <- c(20:50);
link.num    <- 10;
link.pg.num <- 10;
sim.out <- sim.circos(seg=seg.num, po=seg.po, ind=ind.num, link=link.num, 
  link.pg=link.pg.num);
seg.f     <- sim.out$seg.frame;
seg.v     <- sim.out$seg.mapping;
link.v    <- sim.out$seg.link
link.pg.v <- sim.out$seg.link.pg
seg.num   <- length(unique(seg.f[,1]));
seg.name <- paste("chr", 1:seg.num, sep="");
db       <- segAnglePo(seg.f, seg=seg.name);
colors   <- rainbow(seg.num, alpha=0.5);


## ----OmicCircos4vignette1, echo=FALSE, fig.width=8, fig.height=8---------
par(mar=c(2, 2, 2, 2));
plot(c(1,800), c(1,800), type="n", axes=F, xlab="", ylab="", main="");
circos(R=400, cir=db, type="chr",  col=colors, print.chr.lab=T, W=4, scale=T);
circos(R=360, cir=db, W=40, mapping=seg.v, col.v=3, type="l",   B=T, col=colors[1], lwd=0.1, scale=T);
circos(R=320, cir=db, W=40, mapping=seg.v, col.v=3, type="ls",  B=F, col=colors[3], lwd=0.1, scale=T);
circos(R=280, cir=db, W=40, mapping=seg.v, col.v=3, type="lh",  B=T, col=colors[7], lwd=0.1, scale=T);
circos(R=240, cir=db, W=40, mapping=seg.v, col.v=19, type="ml",  B=F, col=colors, lwd=0.1, scale=T);
circos(R=200, cir=db, W=40, mapping=seg.v, col.v=19, type="ml2", B=T, col=colors, lwd=0.1);
circos(R=160, cir=db, W=40, mapping=seg.v, col.v=19, type="ml3", B=F, cutoff=5, lwd=0.1);
circos(R=150, cir=db, W=40, mapping=link.v, type="link", lwd=2, col=colors);
circos(R=150, cir=db, W=40, mapping=link.pg.v, type="link.pg", lwd=2, col=colors);


## ----echo=FALSE----------------------------------------------------------
options(stringsAsFactors = FALSE);
library(OmicCircos);
set.seed(1234);

## initial
seg.num     <- 10;
ind.num     <- 20;
seg.po      <- c(20:50);
link.num    <- 10;
link.pg.num <- 10;

sim.out <- sim.circos(seg=seg.num, po=seg.po, ind=ind.num, link=link.num, 
  link.pg=link.pg.num);

seg.f     <- sim.out$seg.frame;
seg.v     <- sim.out$seg.mapping;
link.v    <- sim.out$seg.link
link.pg.v <- sim.out$seg.link.pg
seg.num   <- length(unique(seg.f[,1]));

## select segments
seg.name <- paste("chr", 1:seg.num, sep="");
db       <- segAnglePo(seg.f, seg=seg.name);

colors   <- rainbow(seg.num, alpha=0.5);


## ----OmicCircos4vignette2, echo=FALSE, fig.width=8, fig.height=8---------
par(mar=c(2, 2, 2, 2));

plot(c(1,800), c(1,800), type="n", axes=F, xlab="", ylab="", main="");
circos(R=400, type="chr", cir=db, col=colors, print.chr.lab=T, W=4, scale=T);
circos(R=360, cir=db, W=40, mapping=seg.v, col.v=8, type="box",   B=T, col=colors[1], lwd=0.1, scale=T);
circos(R=320, cir=db, W=40, mapping=seg.v, col.v=8, type="hist",  B=T, col=colors[3], lwd=0.1, scale=T);
circos(R=280, cir=db, W=40, mapping=seg.v, col.v=8, type="ms",  B=T, col=colors[7], lwd=0.1, scale=T);
circos(R=240, cir=db, W=40, mapping=seg.v, col.v=3, type="h",  B=F,  col=colors[2], lwd=0.1);
circos(R=200, cir=db, W=40, mapping=seg.v, col.v=3, type="s", B=T, col=colors, lwd=0.1);
circos(R=160, cir=db, W=40, mapping=seg.v, col.v=3, type="b", B=F, col=colors, lwd=0.1);
circos(R=150, cir=db, W=40, mapping=link.v, type="link", lwd=2, col=colors);
circos(R=150, cir=db, W=40, mapping=link.pg.v, type="link.pg", lwd=2, col=colors);


## ----echo=FALSE----------------------------------------------------------
options(stringsAsFactors = FALSE);
library(OmicCircos);
set.seed(1234);
seg.num     <- 10;
ind.num     <- 20;
seg.po      <- c(20:50);
link.num    <- 10;
link.pg.num <- 10;
sim.out <- sim.circos(seg=seg.num, po=seg.po, ind=ind.num, link=link.num, 
  link.pg=link.pg.num);
seg.f     <- sim.out$seg.frame;
seg.v     <- sim.out$seg.mapping;
link.v    <- sim.out$seg.link
link.pg.v <- sim.out$seg.link.pg
seg.num   <- length(unique(seg.f[,1]));
seg.name <- paste("chr", 1:seg.num, sep="");
db       <- segAnglePo(seg.f, seg=seg.name);
colors   <- rainbow(seg.num, alpha=0.5);


## ----OmicCircos4vignette3, echo=FALSE, fig.width=8, fig.height=8---------
par(mar=c(2, 2, 2, 2));
plot(c(1,800), c(1,800), type="n", axes=F, xlab="", ylab="", main="");

circos(R=400, type="chr", cir=db, col=colors, print.chr.lab=T, W=4, scale=T);
circos(R=360, cir=db, W=40, mapping=seg.v, col.v=8, type="quant90", B=F, col=colors, lwd=0.1, scale=T);
circos(R=320, cir=db, W=40, mapping=seg.v, col.v=3, type="sv", B=T, col=colors[7], lwd=0.1, scale=T);
circos(R=280, cir=db, W=40, mapping=seg.v, col.v=3, type="ss", B=F, col=colors[3], lwd=0.1, scale=T);
circos(R=240, cir=db, W=40, mapping=seg.v, col.v=8, type="heatmap", lwd=3);
circos(R=200, cir=db, W=40, mapping=seg.v, col.v=3, type="s.sd", B=F, col=colors[4], lwd=0.1);
circos(R=160, cir=db, W=40, mapping=seg.v, col.v=3, type="ci95", B=T, col=colors[4], lwd=0.1);
circos(R=150, cir=db, W=40, mapping=link.v, type="link", lwd=2, col=colors);
circos(R=150, cir=db, W=40, mapping=link.pg.v, type="link.pg", lwd=2, col=colors);

the.col1=rainbow(10, alpha=0.3)[3];
highlight <- c(160, 410, 6, 2, 6, 10, the.col1, the.col1);
circos(R=110, cir=db, W=40, mapping=highlight, type="hl", lwd=2);

the.col1=rainbow(10, alpha=0.01)[3];
the.col2=rainbow(10, alpha=0.8)[1];
highlight <- c(160, 410, 6, 12, 7, 10, the.col1, the.col2);
circos(R=110, cir=db, W=40, mapping=highlight, type="hl", lwd=2);



## ----echo=FALSE----------------------------------------------------------
options(stringsAsFactors = FALSE);
library(OmicCircos);

data("TCGA.PAM50_genefu_hg18");
data("TCGA.BC.fus");
data("TCGA.BC.cnv.2k.60");
data("TCGA.BC.gene.exp.2k.60");
data("TCGA.BC.sample60");
data("TCGA.BC_Her2_cnv_exp");

pvalue <- -1 * log10(TCGA.BC_Her2_cnv_exp[,5]);
pvalue <- cbind(TCGA.BC_Her2_cnv_exp[,c(1:3)], pvalue);

Her2.i <- which(TCGA.BC.sample60[,2] == "Her2");
Her2.n <- TCGA.BC.sample60[Her2.i,1];

Her2.j <- which(colnames(TCGA.BC.cnv.2k.60) %in% Her2.n);
cnv    <- TCGA.BC.cnv.2k.60[,c(1:3,Her2.j)]; 
cnv.m  <- cnv[,c(4:ncol(cnv))];
cnv.m[cnv.m >  2] <- 2;
cnv.m[cnv.m < -2] <- -2;
cnv <- cbind(cnv[,1:3], cnv.m);

Her2.j   <- which(colnames(TCGA.BC.gene.exp.2k.60) %in% Her2.n);
gene.exp <- TCGA.BC.gene.exp.2k.60[,c(1:3,Her2.j)]; 
colors <- rainbow(10, alpha=0.5);


## ----OmicCircos4vignette4, echo=FALSE, fig.width=8, fig.height=8---------
par(mar=c(2, 2, 2, 2));
plot(c(1,800), c(1,800), type="n", axes=F, xlab="", ylab="", main="");
circos(R=300, type="chr", cir="hg18", print.chr.lab=F, W=4);
circos(R=310, cir="hg18", W=20, mapping=TCGA.PAM50_genefu_hg18, type="label", side="out", col="black");
circos(R=250, cir="hg18", W=50, mapping=cnv, col.v=4, type="ml3", B=F, col=colors[7], cutoff=0, scale=T);
circos(R=200, cir="hg18", W=50, mapping=gene.exp, col.v=4, type="ml3", B=T, col=colors[3], cutoff=0, scale=T);
circos(R=140, cir="hg18", W=50, mapping=pvalue, col.v=4, type="l", B=F, col=colors[1], scale=T);
circos(R=132, cir="hg18", W=50, mapping=TCGA.BC.fus, type="link", lwd=2);


## ----OmicCircos4vignette5, echo=FALSE, fig.width=8, fig.height=8---------
par(mar=c(2, 2, 2, 2));
plot(c(1,800), c(1,800), type="n", axes=F, xlab="", ylab="", main="");
circos(R=300, type="chr", cir="hg18", col=T, print.chr.lab=F, W=4);
circos(R=290, cir="hg18", W=20, mapping=TCGA.PAM50_genefu_hg18, type="label", side="in", col="blue");
circos(R=310, cir="hg18", W=50, mapping=cnv, col.v=4, type="ml3", B=T, col=colors[7], cutoff=0, scale=T);
circos(R=150, cir="hg18", W=50, mapping=gene.exp, col.v=4, type="ml3", B=T, col=colors[3], cutoff=0, scale=T);
circos(R=90,  cir="hg18", W=50, mapping=pvalue, col.v=4, type="l", B=F, col=colors[1], scale=T);
circos(R=82, cir="hg18", W=50, mapping=TCGA.BC.fus, type="link", lwd=2); 


## ----echo=FALSE----------------------------------------------------------
options(stringsAsFactors = FALSE);
library(OmicCircos);

data("TCGA.PAM50_genefu_hg18");
data("TCGA.BC.fus");
data("TCGA.BC.cnv.2k.60");
data("TCGA.BC.gene.exp.2k.60");
data("TCGA.BC.sample60");
data("TCGA.BC_Her2_cnv_exp");

pvalue <- -1 * log10(TCGA.BC_Her2_cnv_exp[,5]);
pvalue <- cbind(TCGA.BC_Her2_cnv_exp[,c(1:3)], pvalue);

Her2.i <- which(TCGA.BC.sample60[,2] == "Her2");
Her2.n <- TCGA.BC.sample60[Her2.i,1];

Her2.j <- which(colnames(TCGA.BC.cnv.2k.60) %in% Her2.n);
cnv    <- TCGA.BC.cnv.2k.60[,c(1:3,Her2.j)]; 
cnv.m  <- cnv[,c(4:ncol(cnv))];
cnv.m[cnv.m >  2] <- 2;
cnv.m[cnv.m < -2] <- -2;
cnv <- cbind(cnv[,1:3], cnv.m);

Her2.j   <- which(colnames(TCGA.BC.gene.exp.2k.60) %in% Her2.n);
gene.exp <- TCGA.BC.gene.exp.2k.60[,c(1:3,Her2.j)]; 

colors <- rainbow(10, alpha=0.5);


## ----OmicCircos4vignette6, echo=FALSE, fig.width=8, fig.height=8---------
par(mar=c(2, 2, 2, 2));

plot(c(1,800), c(1,800), type="n", axes=F, xlab="", ylab="", main="");

circos(R=400, cir="hg18", W=4,   type="chr", print.chr.lab=T, scale=T);
circos(R=300, cir="hg18", W=100, mapping=gene.exp,  col.v=4,  type="heatmap2", cluster=T, col.bar=T, lwd=0.01);
circos(R=220, cir="hg18", W=80,  mapping=cnv,   col.v=4,   type="ml3", B=F, lwd=1, cutoff=0);
circos(R=140, cir="hg18", W=80,  mapping=pvalue,  col.v=4,    type="l",   B=T, lwd=1, col=colors[1]);
circos(R=130, cir="hg18", W=10,  mapping=TCGA.BC.fus, type="link", lwd=2);



## ----echo=FALSE----------------------------------------------------------
options(stringsAsFactors = FALSE);
library(OmicCircos);

data("TCGA.BC.fus");
data("TCGA.BC.cnv.2k.60");
data("TCGA.BC.gene.exp.2k.60");
data("TCGA.BC.sample60");

## gene expression data for PCA
exp.m   <- TCGA.BC.gene.exp.2k.60[,c(4:ncol(TCGA.BC.gene.exp.2k.60))];
cnv     <- TCGA.BC.cnv.2k.60;
type.n  <- unique(TCGA.BC.sample60[,2]);
colors  <- rainbow(length(type.n), alpha=0.5);

## sub-type colors
pca.col <- rep(NA, nrow(TCGA.BC.sample60));
for (i in 1:length(type.n)){
  n   <- type.n[i];
  n.i <- which(TCGA.BC.sample60[,2] == n);
  n.n <- TCGA.BC.sample60[n.i,1];
  g.i <- which(colnames(exp.m) %in% n.n);
  pca.col[g.i] <- colors[i];
}

## run PCA
exp.m   <- na.omit(exp.m);
pca.out <- prcomp(t(exp.m), scale = TRUE);

## subtype cnv
cnv.i <- c();
for (i in 1:length(type.n)){
  n     <- type.n[i];
  n.i   <- which(TCGA.BC.sample60[,2] == n);
  n.n   <- TCGA.BC.sample60[n.i,1];
  cnv.i <- which(colnames(cnv) %in% n.n);
}


## ----OmicCircos4vignette7, echo=FALSE, fig.width=8, fig.height=8---------

## PCA is plotting. 
plot(pca.out$x[,1]*5, pca.out$x[,2]*5, pch=19, col=pca.col, main="",  
     cex=2, xlab="PC1", ylab="PC2", ylim=c(-200, 460), xlim=c(-200,460));
legend(200,0, c("Basal","Her2","LumA","LumB"), pch=19, col=colors[c(2,4,1,3)], cex=1, 
     title ="Gene Expression (PCA)", box.col="white");

## It is going to plot the circos.
circos(xc=280, yc=280, R=168, cir="hg18", W=4,     type="chr", print.chr.lab=T);
R.v <- 135;
for (i in 1:length(type.n)){
  n     <- type.n[i];
  n.i   <- which(TCGA.BC.sample60[,2] == n);
  n.n   <- TCGA.BC.sample60[n.i,1];
  cnv.i <- which(colnames(cnv) %in% n.n);
  cnv.v <- cnv[,cnv.i];
  cnv.v[cnv.v > 2]  <- 2;
  cnv.v[cnv.v < -2] <- -2;
  cnv.m <- cbind(cnv[,c(1:3)], cnv.v);
  circos(xc=280, yc=280, R=R.v, cir="hg18", W=34, mapping=cnv.m, col.v=4,  type="ml3", B=F, lwd=0.5, cutoff=0);
  R.v <- R.v - 25;
}

legend(-80,460, c("1 Basal", "2 Her2", "3 LumA", "4 LumB", "(center)"), cex=1, 
     title ="CNV (OmicCircos)", box.col="white");


## ----OmicCircos4vignette8, echo=FALSE, fig.width=8, fig.height=8---------

plot(c(1,800), c(1,800), type="n", axes=F, xlab="", ylab="", main="");

legend(680,800, c("Basal","Her2","LumA","LumB"), pch=19, col=colors[c(2,4,1,3)], cex=0.5, 
     title ="Gene Expression (PCA)", box.col="white");

legend(5,800, c("1 Basal", "2 Her2", "3 LumA", "4 LumB", "(center)"), cex=0.5, 
     title ="CNV (OmicCircos)", box.col="white");

circos(xc=400, yc=400, R=390, cir="hg18", W=4,  type="chr", print.chr.lab=T, scale=T);
R.v <- 330;
for (i in 1:length(type.n)){
  n     <- type.n[i];
  n.i   <- which(TCGA.BC.sample60[,2] == n);
  n.n   <- TCGA.BC.sample60[n.i,1];
  cnv.i <- which(colnames(cnv) %in% n.n);
  cnv.v <- cnv[,cnv.i];
  cnv.v[cnv.v > 2]  <- 2;
  cnv.v[cnv.v < -2] <- -2;
  cnv.m <- cbind(cnv[,c(1:3)], cnv.v);
  circos(xc=400, yc=400, R=R.v, cir="hg18", W=60, mapping=cnv.m, col.v=4,  type="ml3", B=F, lwd=1, cutoff=0, scale=T);
  R.v <- R.v - 60;
}

points(pca.out$x[,1]*3.6+400, pca.out$x[,2]*3.6+400, pch=19, col=pca.col, cex=2);



## ----echo=FALSE----------------------------------------------------------
options(stringsAsFactors = FALSE);
library(OmicCircos);

data("TCGA.PAM50_genefu_hg18");
data("TCGA.BC.fus");
data("TCGA.BC.cnv.2k.60");
data("TCGA.BC.gene.exp.2k.60");
data("TCGA.BC.sample60");
data("TCGA.BC_Her2_cnv_exp");
data("TCGA.PAM50_genefu_hg18");

pvalue <- -1 * log10(TCGA.BC_Her2_cnv_exp[,5]);
pvalue <- cbind(TCGA.BC_Her2_cnv_exp[,c(1:3)], pvalue);

Her2.i <- which(TCGA.BC.sample60[,2] == "Her2");
Her2.n <- TCGA.BC.sample60[Her2.i,1];

Her2.j <- which(colnames(TCGA.BC.cnv.2k.60) %in% Her2.n);
cnv    <- TCGA.BC.cnv.2k.60[,c(1:3,Her2.j)]; 
cnv.m  <- cnv[,c(4:ncol(cnv))];
cnv.m[cnv.m >  2] <- 2;
cnv.m[cnv.m < -2] <- -2;
cnv <- cbind(cnv[,1:3], cnv.m);

gene.exp <- TCGA.BC.gene.exp.2k.60[,c(1:3,Her2.j)]; 

colors <- rainbow(10, alpha=0.5);


## ----OmicCircos4vignette9, eval=FALSE, echo=FALSE, fig.width=8, fig.height=8----
## par(mar=c(2, 2, 2, 2));
## 
## plot(c(1,800), c(1,800), type="n", axes=F, xlab="", ylab="", main="");
## 
## zoom <- c(1, 22, 939245.5, 154143883, 0, 180);
## circos(R=400, cir="hg18", W=4,   type="chr", print.chr.lab=T, scale=T, zoom=zoom);
## circos(R=300, cir="hg18", W=100, mapping=gene.exp, col.v=4,  type="heatmap2", cluster=T, col.bar=T, col.bar.po = "bottomright", lwd=0.01, zoom=zoom);
## circos(R=220, cir="hg18", W=80,  mapping=cnv,      col.v=4,  type="ml3", B=F, lwd=1, cutoff=0, zoom=zoom);
## circos(R=140, cir="hg18", W=80,  mapping=pvalue,   col.v=4,  type="l",   B=T, lwd=1, col=colors[1], zoom=zoom);
## circos(R=130, cir="hg18", W=10,  mapping=TCGA.BC.fus, type="link", lwd=2, zoom=zoom);
## 
## the.col1=rainbow(10, alpha=0.5)[1];
## 
## highlight <- c(140, 400, 11, 282412.5, 11, 133770314.5, the.col1, the.col1);
## circos(R=110, cir="hg18", W=40, mapping=highlight, type="hl", lwd=2, zoom=zoom);
## the.col2=rainbow(10, alpha=0.5)[6];
## highlight <- c(140, 400, 17, 739525, 17, 78385909, the.col2, the.col2);
## circos(R=110, cir="hg18", W=40, mapping=highlight, type="hl", lwd=2, zoom=zoom);
## 
## highlight.link1 <- c(400, 400, 140, 376.8544, 384.0021, 450, 540.5);
## circos(cir="hg18", mapping=highlight.link1, type="highlight.link", col=the.col1, lwd=1);
## highlight.link2 <- c(400, 400, 140, 419.1154, 423.3032, 543, 627);
## circos(cir="hg18", mapping=highlight.link2, type="highlight.link", col=the.col2, lwd=1);
## 
## zoom <- c(11, 11, 282412.5, 133770314.5, 180, 270);
## circos(R=400, cir="hg18", W=4,   type="chr", print.chr.lab=T, scale=T, zoom=zoom);
## circos(R=300, cir="hg18", W=100, mapping=gene.exp, col.v=4,  type="heatmap2", cluster=T, lwd=0.01, zoom=zoom);
## circos(R=220, cir="hg18", W=80,  mapping=cnv,      col.v=4,  type="ml3", B=F, lwd=1, cutoff=0, zoom=zoom);
## circos(R=140, cir="hg18", W=80,  mapping=pvalue,   col.v=4,  type="l",   B=T, lwd=1, col=colors[1], zoom=zoom);
## 
## gene.names <- c("ERBB2","CDC6");
## PAM50.17   <- which(TCGA.PAM50_genefu_hg18[,3]==gene.names);
## TCGA.PAM50 <- TCGA.PAM50_genefu_hg18[PAM50.17,];
## 
## zoom <- c(17, 17, 739525, 78385909, 274, 356);
## circos(R=400, cir="hg18", W=4,   type="chr", print.chr.lab=T, scale=T, zoom=zoom);
## circos(R=300, cir="hg18", W=100, mapping=gene.exp, col.v=4,  type="heatmap2", cluster=T, lwd=0.01, zoom=zoom);
## circos(R=220, cir="hg18", W=80,  mapping=cnv,      col.v=4,  type="ml3", B=F, lwd=1, cutoff=0, zoom=zoom);
## circos(R=140, cir="hg18", W=80,  mapping=pvalue,   col.v=4,  type="l",   B=T, lwd=1, col=colors[1], zoom=zoom);
## circos(R=410, cir="hg18", W=40,  mapping=TCGA.PAM50, type="label", side="out", col="blue", zoom=zoom);


