/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.converter;

import cytoscape.visual.converter.ColorConverter;
import cytoscape.visual.converter.FontConverter;
import cytoscape.visual.converter.NodeShapeConverter;
import cytoscape.visual.converter.ObjectPositionConverter;
import cytoscape.visual.converter.ValueToStringConverter;
import ding.view.ObjectPositionImpl;
import java.util.HashMap;
import java.util.Map;

public class ValueToStringConverterManager {
    public static final ValueToStringConverterManager manager = new ValueToStringConverterManager();
    private final Map<Class<?>, ValueToStringConverter> converters = new HashMap();

    private ValueToStringConverterManager() {
        this.registerDefaultConverters();
    }

    public void register(ValueToStringConverter converter) {
        this.converters.put(converter.getType(), converter);
    }

    public String toString(Object value) {
        if (value == null) {
            return "";
        }
        ValueToStringConverter converter = this.converters.get(value.getClass());
        if (converter == null) {
            return value.toString();
        }
        return converter.toString(value);
    }

    private void registerDefaultConverters() {
        ColorConverter color = new ColorConverter();
        this.converters.put(color.getType(), color);
        NodeShapeConverter nodeShape = new NodeShapeConverter();
        this.converters.put(nodeShape.getType(), nodeShape);
        ObjectPositionConverter objectPosition = new ObjectPositionConverter();
        this.converters.put(objectPosition.getType(), objectPosition);
        this.converters.put(ObjectPositionImpl.class, objectPosition);
        FontConverter font = new FontConverter();
        this.converters.put(font.getType(), font);
    }
}

