/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual;

import cytoscape.Cytoscape;
import cytoscape.logger.CyLogger;
import cytoscape.visual.Appearance;
import cytoscape.visual.ArrowShape;
import cytoscape.visual.EdgeAppearance;
import cytoscape.visual.EdgeAppearanceCalculator;
import cytoscape.visual.LineStyle;
import cytoscape.visual.NodeAppearance;
import cytoscape.visual.NodeAppearanceCalculator;
import cytoscape.visual.NodeShape;
import cytoscape.visual.VisualProperty;
import cytoscape.visual.VisualStyle;
import cytoscape.visual.calculators.Calculator;
import cytoscape.visual.customgraphic.CyCustomGraphics;
import cytoscape.visual.parsers.ArrowShapeParser;
import cytoscape.visual.parsers.BooleanParser;
import cytoscape.visual.parsers.ColorParser;
import cytoscape.visual.parsers.DoubleParser;
import cytoscape.visual.parsers.FloatParser;
import cytoscape.visual.parsers.FontParser;
import cytoscape.visual.parsers.GraphicsParser;
import cytoscape.visual.parsers.LineStyleParser;
import cytoscape.visual.parsers.NodeShapeParser;
import cytoscape.visual.parsers.ObjectPositionParser;
import cytoscape.visual.parsers.StringParser;
import cytoscape.visual.parsers.ValueParser;
import cytoscape.visual.properties.EdgeColorProp;
import cytoscape.visual.properties.EdgeFontFaceProp;
import cytoscape.visual.properties.EdgeFontSizeProp;
import cytoscape.visual.properties.EdgeLabelColorProp;
import cytoscape.visual.properties.EdgeLabelOpacityProp;
import cytoscape.visual.properties.EdgeLabelPositionProp;
import cytoscape.visual.properties.EdgeLabelProp;
import cytoscape.visual.properties.EdgeLabelWidthProp;
import cytoscape.visual.properties.EdgeLineStyleProp;
import cytoscape.visual.properties.EdgeLineWidthProp;
import cytoscape.visual.properties.EdgeOpacityProp;
import cytoscape.visual.properties.EdgeSourceArrowColorProp;
import cytoscape.visual.properties.EdgeSourceArrowOpacityProp;
import cytoscape.visual.properties.EdgeSourceArrowShapeProp;
import cytoscape.visual.properties.EdgeTargetArrowColorProp;
import cytoscape.visual.properties.EdgeTargetArrowOpacityProp;
import cytoscape.visual.properties.EdgeTargetArrowShapeProp;
import cytoscape.visual.properties.EdgeToolTipProp;
import cytoscape.visual.properties.NodeBorderColorProp;
import cytoscape.visual.properties.NodeBorderOpacityProp;
import cytoscape.visual.properties.NodeCustomGraphicsPositionProp;
import cytoscape.visual.properties.NodeCustomGraphicsProp;
import cytoscape.visual.properties.NodeFillColorProp;
import cytoscape.visual.properties.NodeFontFaceProp;
import cytoscape.visual.properties.NodeFontSizeProp;
import cytoscape.visual.properties.NodeHeightProp;
import cytoscape.visual.properties.NodeLabelColorProp;
import cytoscape.visual.properties.NodeLabelOpacityProp;
import cytoscape.visual.properties.NodeLabelPositionProp;
import cytoscape.visual.properties.NodeLabelProp;
import cytoscape.visual.properties.NodeLabelWidthProp;
import cytoscape.visual.properties.NodeLineStyleProp;
import cytoscape.visual.properties.NodeLineWidthProp;
import cytoscape.visual.properties.NodeOpacityProp;
import cytoscape.visual.properties.NodeShapeProp;
import cytoscape.visual.properties.NodeShowNestedNetworkProp;
import cytoscape.visual.properties.NodeSizeProp;
import cytoscape.visual.properties.NodeToolTipProp;
import cytoscape.visual.properties.NodeWidthProp;
import cytoscape.visual.ui.EditorDisplayer;
import cytoscape.visual.ui.editors.continuous.ContinuousMappingEditorPanel;
import giny.view.ObjectPosition;
import java.awt.Color;
import java.awt.Font;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum VisualPropertyType {
    NODE_FILL_COLOR("Node Color", "nodeFillColorCalculator", "node.fillColor", "defaultNodeFillColor", Color.class, new NodeFillColorProp(), new ColorParser(), true, true),
    NODE_BORDER_COLOR("Node Border Color", "nodeBorderColorCalculator", "node.borderColor", "defaultNodeBorderColor", Color.class, new NodeBorderColorProp(), new ColorParser(), true, true),
    NODE_LINETYPE("Node Line Type", "nodeLineTypeCalculator", "node.lineType", "defaultNodeLineType", LineStyle.class, new NodeLineStyleProp(), new LineStyleParser(), true, false),
    NODE_SHAPE("Node Shape", "nodeShapeCalculator", "node.shape", "defaultNodeShape", NodeShape.class, new NodeShapeProp(), new NodeShapeParser(), true, true),
    NODE_SIZE("Node Size", "nodeUniformSizeCalculator", "node.size", "defaultNodeSize", Number.class, new NodeSizeProp(), new DoubleParser(), true, true),
    NODE_WIDTH("Node Width", "nodeWidthCalculator", "node.width", "defaultNodeWidth", Number.class, new NodeWidthProp(), new DoubleParser(), true, true),
    NODE_HEIGHT("Node Height", "nodeHeightCalculator", "node.height", "defaultNodeHight", Number.class, new NodeHeightProp(), new DoubleParser(), true, true),
    NODE_LABEL("Node Label", "nodeLabelCalculator", "node.label", "defaultNodeLabel", String.class, new NodeLabelProp(), new StringParser(), true, true),
    NODE_FONT_FACE("Node Font Face", "nodeFontFaceCalculator", "node.font", "defaultNodeFont", Font.class, new NodeFontFaceProp(), new FontParser(), true, true),
    NODE_FONT_SIZE("Node Font Size", "nodeFontSizeCalculator", "node.fontSize", "defaultNodeFontSize", Number.class, new NodeFontSizeProp(), new DoubleParser(), true, true),
    NODE_LABEL_COLOR("Node Label Color", "nodeLabelColor", "node.labelColor", "defaultNodeLabelColor", Color.class, new NodeLabelColorProp(), new ColorParser(), true, true),
    NODE_TOOLTIP("Node Tooltip", "nodeTooltipCalculator", "node.toolTip", "defaultNodeToolTip", String.class, new NodeToolTipProp(), new StringParser(), true, true),
    NODE_LABEL_POSITION("Node Label Position", "nodeLabelPositionCalculator", "node.labelPosition", "defaultNodeLabelPosition", ObjectPosition.class, new NodeLabelPositionProp(), new ObjectPositionParser(), true, true),
    EDGE_COLOR("Edge Color", "edgeColorCalculator", "edge.color", "defaultEdgeColor", Color.class, new EdgeColorProp(), new ColorParser(), false, true),
    EDGE_LINETYPE("Edge Line Type", "edgeLineTypeCalculator", "edge.lineType", "defaultEdgeLineType", LineStyle.class, new EdgeLineStyleProp(), new LineStyleParser(), false, false),
    EDGE_SRCARROW("Edge Source Arrow", "edgeSourceArrowCalculator", "edge.sourceArrow", "defaultEdgeSourceArrow", ArrowShape.class, new EdgeSourceArrowShapeProp(), new ArrowShapeParser(), false, false),
    EDGE_TGTARROW("Edge Target Arrow", "edgeTargetArrowCalculator", "edge.targetArrow", "defaultEdgeTargetArrow", ArrowShape.class, new EdgeTargetArrowShapeProp(), new ArrowShapeParser(), false, false),
    EDGE_LABEL("Edge Label", "edgeLabelCalculator", "edge.label", "defaultEdgeLabel", String.class, new EdgeLabelProp(), new StringParser(), false, true),
    EDGE_FONT_FACE("Edge Font Face", "edgeFontFaceCalculator", "edge.font", "defaultEdgeFont", Font.class, new EdgeFontFaceProp(), new FontParser(), false, true),
    EDGE_FONT_SIZE("Edge Font Size", "edgeFontSizeCalculator", "edge.fontSize", "defaultEdgeFontSize", Number.class, new EdgeFontSizeProp(), new DoubleParser(), false, true),
    EDGE_LABEL_COLOR("Edge Label Color", "edgeLabelColorCalculator", "edge.labelColor", "defaultEdgeLabelColor", Color.class, new EdgeLabelColorProp(), new ColorParser(), false, true),
    EDGE_TOOLTIP("Edge Tooltip", "edgeTooltipCalculator", "edge.toolTip", "defaultEdgeToolTip", String.class, new EdgeToolTipProp(), new StringParser(), false, true),
    NODE_LINE_WIDTH("Node Line Width", "nodeLineWidthCalculator", "node.lineWidth", "defaultNodeLineWidth", Number.class, new NodeLineWidthProp(), new FloatParser(), true, true),
    EDGE_LINE_WIDTH("Edge Line Width", "edgeLineWidthCalculator", "edge.lineWidth", "defaultEdgeLineWidth", Number.class, new EdgeLineWidthProp(), new FloatParser(), false, true),
    NODE_LINE_STYLE("Node Line Style", "nodeLineStyleCalculator", "node.lineStyle", "defaultNodeLineStyle", LineStyle.class, new NodeLineStyleProp(), new LineStyleParser(), true, true),
    EDGE_LINE_STYLE("Edge Line Style", "edgeLineStyleCalculator", "edge.lineStyle", "defaultEdgeLineStyle", LineStyle.class, new EdgeLineStyleProp(), new LineStyleParser(), false, true),
    EDGE_SRCARROW_SHAPE("Edge Source Arrow Shape", "edgeSourceArrowShapeCalculator", "edge.sourceArrowShape", "defaultEdgeSourceArrowShape", ArrowShape.class, new EdgeSourceArrowShapeProp(), new ArrowShapeParser(), false, true),
    EDGE_TGTARROW_SHAPE("Edge Target Arrow Shape", "edgeTargetArrowShapeCalculator", "edge.targetArrowShape", "defaultEdgeTargetArrowShape", ArrowShape.class, new EdgeTargetArrowShapeProp(), new ArrowShapeParser(), false, true),
    EDGE_SRCARROW_COLOR("Edge Source Arrow Color", "edgeSourceArrowColorCalculator", "edge.sourceArrowColor", "defaultEdgeSourceArrowColor", Color.class, new EdgeSourceArrowColorProp(), new ColorParser(), false, true),
    EDGE_TGTARROW_COLOR("Edge Target Arrow Color", "edgeTargetArrowColorCalculator", "edge.targetArrowColor", "defaultEdgeTargetArrowColor", Color.class, new EdgeTargetArrowColorProp(), new ColorParser(), false, true),
    NODE_OPACITY("Node Opacity", "nodeOpacityCalculator", "node.opacity", "defaultNodeOpacity", Number.class, new NodeOpacityProp(), new FloatParser(), true, true),
    EDGE_OPACITY("Edge Opacity", "edgeOpacityCalculator", "edge.opacity", "defaultEdgeOpacity", Number.class, new EdgeOpacityProp(), new FloatParser(), false, true),
    NODE_LABEL_OPACITY("Node Label Opacity", "nodeLabelOpacityCalculator", "node.LabelOpacity", "defaultNodeLabelOpacity", Number.class, new NodeLabelOpacityProp(), new FloatParser(), true, true),
    EDGE_LABEL_OPACITY("Edge Label Opacity", "edgeLabelOpacityCalculator", "edge.labelOpacity", "defaultEdgeLabelOpacity", Number.class, new EdgeLabelOpacityProp(), new FloatParser(), false, true),
    NODE_BORDER_OPACITY("Node Border Opacity", "nodeBorderOpacityCalculator", "node.borderOpacity", "defaultNodeBorderOpacity", Number.class, new NodeBorderOpacityProp(), new FloatParser(), true, true),
    EDGE_SRCARROW_OPACITY("Edge Source Arrow Opacity", "edgeSourceArrowOpacityCalculator", "edge.sourceArrowOpacity", "defaultEdgeSourceArrowOpacity", Number.class, new EdgeSourceArrowOpacityProp(), new FloatParser(), false, true),
    EDGE_TGTARROW_OPACITY("Edge Target Arrow Opacity", "edgeTargetArrowOpacityCalculator", "edge.targetArrowOpacity", "defaultEdgeTargetArrowOpacity", Number.class, new EdgeTargetArrowOpacityProp(), new FloatParser(), false, true),
    EDGE_LABEL_POSITION("Edge Label Position", "edgeLabelPositionCalculator", "edge.labelPosition", "defaultEdgeLabelPosition", null, new EdgeLabelPositionProp(), new ObjectPositionParser(), false, false),
    NODE_LABEL_WIDTH("Node Label Width", "nodeLabelWidthCalculator", "node.labelWidth", "defaultNodeLabelWidth", Number.class, new NodeLabelWidthProp(), new FloatParser(), true, true),
    EDGE_LABEL_WIDTH("Edge Label Width", "edgeLabelWidthCalculator", "edge.labelWidth", "defaultEdgeLabelWidth", Number.class, new EdgeLabelWidthProp(), new FloatParser(), false, true),
    NODE_SHOW_NESTED_NETWORK("Node Show Nested Network", "nodeShowNestedNetwork", "node.showNestedNetwork", "defaultNodeShowNestedNetwork", Boolean.class, new NodeShowNestedNetworkProp(), new BooleanParser(), true, true),
    NODE_CUSTOM_GRAPHICS_1("Node Custom Graphics 1", "nodeCustomGraphics1", "node.customGraphics1", "defaultNodeCustomGraphics1", CyCustomGraphics.class, new NodeCustomGraphicsProp(1), new GraphicsParser(), true, true),
    NODE_CUSTOM_GRAPHICS_2("Node Custom Graphics 2", "nodeCustomGraphics2", "node.customGraphics2", "defaultNodeCustomGraphics2", CyCustomGraphics.class, new NodeCustomGraphicsProp(2), new GraphicsParser(), true, true),
    NODE_CUSTOM_GRAPHICS_3("Node Custom Graphics 3", "nodeCustomGraphics3", "node.customGraphics3", "defaultNodeCustomGraphics3", CyCustomGraphics.class, new NodeCustomGraphicsProp(3), new GraphicsParser(), true, true),
    NODE_CUSTOM_GRAPHICS_4("Node Custom Graphics 4", "nodeCustomGraphics4", "node.customGraphics4", "defaultNodeCustomGraphics4", CyCustomGraphics.class, new NodeCustomGraphicsProp(4), new GraphicsParser(), true, true),
    NODE_CUSTOM_GRAPHICS_5("Node Custom Graphics 5", "nodeCustomGraphics5", "node.customGraphics5", "defaultNodeCustomGraphics5", CyCustomGraphics.class, new NodeCustomGraphicsProp(5), new GraphicsParser(), true, true),
    NODE_CUSTOM_GRAPHICS_6("Node Custom Graphics 6", "nodeCustomGraphics6", "node.customGraphics6", "defaultNodeCustomGraphics6", CyCustomGraphics.class, new NodeCustomGraphicsProp(6), new GraphicsParser(), true, true),
    NODE_CUSTOM_GRAPHICS_7("Node Custom Graphics 7", "nodeCustomGraphics7", "node.customGraphics7", "defaultNodeCustomGraphics7", CyCustomGraphics.class, new NodeCustomGraphicsProp(7), new GraphicsParser(), true, true),
    NODE_CUSTOM_GRAPHICS_8("Node Custom Graphics 8", "nodeCustomGraphics8", "node.customGraphics8", "defaultNodeCustomGraphics8", CyCustomGraphics.class, new NodeCustomGraphicsProp(8), new GraphicsParser(), true, true),
    NODE_CUSTOM_GRAPHICS_9("Node Custom Graphics 9", "nodeCustomGraphics9", "node.customGraphics9", "defaultNodeCustomGraphics9", CyCustomGraphics.class, new NodeCustomGraphicsProp(9), new GraphicsParser(), true, true),
    NODE_CUSTOM_GRAPHICS_POSITION_1("Node Custom Graphics Position 1", "nodeCustomGraphicsPosition1", "node.customGraphicsPosition1", "defaultNodeCustomGraphicsPosition1", ObjectPosition.class, new NodeCustomGraphicsPositionProp(1), new ObjectPositionParser(), true, true),
    NODE_CUSTOM_GRAPHICS_POSITION_2("Node Custom Graphics Position 2", "nodeCustomGraphicsPosition2", "node.customGraphicsPosition2", "defaultNodeCustomGraphicsPosition2", ObjectPosition.class, new NodeCustomGraphicsPositionProp(2), new ObjectPositionParser(), true, true),
    NODE_CUSTOM_GRAPHICS_POSITION_3("Node Custom Graphics Position 3", "nodeCustomGraphicsPosition3", "node.customGraphicsPosition3", "defaultNodeCustomGraphicsPosition3", ObjectPosition.class, new NodeCustomGraphicsPositionProp(3), new ObjectPositionParser(), true, true),
    NODE_CUSTOM_GRAPHICS_POSITION_4("Node Custom Graphics Position 4", "nodeCustomGraphicsPosition4", "node.customGraphicsPosition4", "defaultNodeCustomGraphicsPosition4", ObjectPosition.class, new NodeCustomGraphicsPositionProp(4), new ObjectPositionParser(), true, true),
    NODE_CUSTOM_GRAPHICS_POSITION_5("Node Custom Graphics Position 5", "nodeCustomGraphicsPosition5", "node.customGraphicsPosition5", "defaultNodeCustomGraphicsPosition5", ObjectPosition.class, new NodeCustomGraphicsPositionProp(5), new ObjectPositionParser(), true, true),
    NODE_CUSTOM_GRAPHICS_POSITION_6("Node Custom Graphics Position 6", "nodeCustomGraphicsPosition6", "node.customGraphicsPosition6", "defaultNodeCustomGraphicsPosition6", ObjectPosition.class, new NodeCustomGraphicsPositionProp(6), new ObjectPositionParser(), true, true),
    NODE_CUSTOM_GRAPHICS_POSITION_7("Node Custom Graphics Position 7", "nodeCustomGraphicsPosition7", "node.customGraphicsPosition7", "defaultNodeCustomGraphicsPosition7", ObjectPosition.class, new NodeCustomGraphicsPositionProp(7), new ObjectPositionParser(), true, true),
    NODE_CUSTOM_GRAPHICS_POSITION_8("Node Custom Graphics Position 8", "nodeCustomGraphicsPosition8", "node.customGraphicsPosition8", "defaultNodeCustomGraphicsPosition8", ObjectPosition.class, new NodeCustomGraphicsPositionProp(8), new ObjectPositionParser(), true, true),
    NODE_CUSTOM_GRAPHICS_POSITION_9("Node Custom Graphics Position 9", "nodeCustomGraphicsPosition9", "node.customGraphicsPosition9", "defaultNodeCustomGraphicsPosition9", ObjectPosition.class, new NodeCustomGraphicsPositionProp(9), new ObjectPositionParser(), true, true);

    private final String calcName;
    private String propertyLabel;
    private String bypassAttrName;
    private String defaultPropertyLabel;
    private Class<?> dataType;
    private VisualProperty vizProp;
    private ValueParser valueParser;
    private boolean isNodeProp;
    private boolean isAllowed;
    private static final CyLogger logger;
    private static final VisualPropertyType[] CUSTOM_GRAPHICS_PROPS;
    private static final VisualPropertyType[] CUSTOM_GRAPHICS_POSITION_PROPS;

    private VisualPropertyType(String calcName, String propertyLabel, String bypassAttrName, String defaultPropertyLabel, Class<?> dataType, VisualProperty vizProp, ValueParser valueParser, boolean isNodeProp, boolean isAllowed) {
        this.calcName = calcName;
        this.propertyLabel = propertyLabel;
        this.bypassAttrName = bypassAttrName;
        this.defaultPropertyLabel = defaultPropertyLabel;
        this.dataType = dataType;
        this.vizProp = vizProp;
        this.valueParser = valueParser;
        this.isNodeProp = isNodeProp;
        this.isAllowed = isAllowed;
    }

    public String getName() {
        return this.calcName;
    }

    public String getPropertyLabel() {
        return this.propertyLabel;
    }

    public String getBypassAttrName() {
        return this.bypassAttrName;
    }

    public String getDefaultPropertyLabel() {
        return this.defaultPropertyLabel;
    }

    public String getDefaultPropertyKey(String baseKey) {
        return baseKey + "." + this.defaultPropertyLabel;
    }

    public Class<?> getDataType() {
        return this.dataType;
    }

    public boolean isNodeProp() {
        return this.isNodeProp;
    }

    public boolean isAllowed() {
        return this.isAllowed;
    }

    public static List<VisualPropertyType> getNodeVisualPropertyList() {
        ArrayList<VisualPropertyType> list = new ArrayList<VisualPropertyType>();
        for (VisualPropertyType type : VisualPropertyType.values()) {
            if (!type.isNodeProp() || !type.isAllowed()) continue;
            list.add(type);
        }
        return list;
    }

    public static List<VisualPropertyType> getEdgeVisualPropertyList() {
        ArrayList<VisualPropertyType> list = new ArrayList<VisualPropertyType>();
        for (VisualPropertyType type : VisualPropertyType.values()) {
            if (type.isNodeProp() || !type.isAllowed()) continue;
            list.add(type);
        }
        return list;
    }

    private Object showEditor(EditorDisplayer action) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException {
        Method method;
        Object ret;
        if (EditorDisplayer.DISCRETE_OBJECT_POSITION == action) {
            action.setParameters(new Object[]{Cytoscape.getDesktop(), this.getDefault(Cytoscape.getVisualMappingManager().getVisualStyle()), this});
        }
        if ((ret = (method = action.getActionClass().getMethod(action.getCommand(), action.getParamTypes())).invoke(null, action.getParameters())) == null) {
            return null;
        }
        if (ret instanceof ContinuousMappingEditorPanel) {
            return ret;
        }
        if (ret instanceof String) {
            ret = this.valueParser.parseStringValue((String)ret);
        }
        if (this.vizProp.isValidValue(ret)) {
            return ret;
        }
        logger.warn("Invalid value specified for " + this.toString() + " : " + ret);
        return null;
    }

    public Object showDiscreteEditor() throws Exception {
        return this.showEditor(EditorDisplayer.getEditor(this, EditorDisplayer.EditorType.DISCRETE));
    }

    public Object showContinuousEditor() throws Exception {
        EditorDisplayer editor = EditorDisplayer.getEditor(this, EditorDisplayer.EditorType.CONTINUOUS);
        if (editor == EditorDisplayer.CONTINUOUS_COLOR) {
            editor.setParameters(new Object[]{450, 180, "Gradient Editor for " + this.calcName, this});
        } else if (editor == EditorDisplayer.CONTINUOUS_CONTINUOUS) {
            editor.setParameters(new Object[]{450, 350, "Continuous Editor for " + this.calcName, this});
        } else {
            editor.setParameters(new Object[]{450, 300, "Continuous Editor for " + this.calcName, this});
        }
        return this.showEditor(editor);
    }

    public VisualProperty getVisualProperty() {
        return this.vizProp;
    }

    public Object getDefault(VisualStyle style) {
        if (style == null) {
            return null;
        }
        Appearance a = null;
        a = this.isNodeProp() ? style.getNodeAppearanceCalculator().getDefaultAppearance() : style.getEdgeAppearanceCalculator().getDefaultAppearance();
        return a.get(this);
    }

    public void setDefault(VisualStyle style, Object c) {
        if (style == null || c == null) {
            return;
        }
        if (!this.vizProp.isValidValue(c)) {
            logger.warn("Invalid default value specified for " + this.toString() + " : " + c);
            return;
        }
        if (this.isNodeProp()) {
            NodeAppearanceCalculator nodeCalc = style.getNodeAppearanceCalculator();
            NodeAppearance na = nodeCalc.getDefaultAppearance();
            na.set(this, c);
            nodeCalc.setDefaultAppearance(na);
        } else {
            EdgeAppearanceCalculator edgeCalc = style.getEdgeAppearanceCalculator();
            EdgeAppearance ea = edgeCalc.getDefaultAppearance();
            ea.set(this, c);
            edgeCalc.setDefaultAppearance(ea);
        }
    }

    public Calculator getCurrentCalculator(VisualStyle style) {
        if (style == null) {
            return null;
        }
        if (this.isNodeProp()) {
            return style.getNodeAppearanceCalculator().getCalculator(this);
        }
        return style.getEdgeAppearanceCalculator().getCalculator(this);
    }

    public void setCurrentCalculator(VisualStyle style, Calculator c) {
        if (style == null) {
            return;
        }
        if (this.isNodeProp()) {
            if (c == null) {
                style.getNodeAppearanceCalculator().removeCalculator(this);
            } else {
                style.getNodeAppearanceCalculator().setCalculator(c);
            }
        } else if (c == null) {
            style.getEdgeAppearanceCalculator().removeCalculator(this);
        } else {
            style.getEdgeAppearanceCalculator().setCalculator(c);
        }
    }

    public ValueParser getValueParser() {
        return this.valueParser;
    }

    public static VisualPropertyType getCustomGraphicsType(int index) {
        return CUSTOM_GRAPHICS_PROPS[index];
    }

    public static VisualPropertyType getCustomGraphicsPositionType(int index) {
        return CUSTOM_GRAPHICS_POSITION_PROPS[index];
    }

    static {
        logger = CyLogger.getLogger(VisualPropertyType.class);
        CUSTOM_GRAPHICS_PROPS = new VisualPropertyType[]{NODE_CUSTOM_GRAPHICS_1, NODE_CUSTOM_GRAPHICS_2, NODE_CUSTOM_GRAPHICS_3, NODE_CUSTOM_GRAPHICS_4, NODE_CUSTOM_GRAPHICS_5, NODE_CUSTOM_GRAPHICS_6, NODE_CUSTOM_GRAPHICS_7, NODE_CUSTOM_GRAPHICS_8, NODE_CUSTOM_GRAPHICS_9};
        CUSTOM_GRAPHICS_POSITION_PROPS = new VisualPropertyType[]{NODE_CUSTOM_GRAPHICS_POSITION_1, NODE_CUSTOM_GRAPHICS_POSITION_2, NODE_CUSTOM_GRAPHICS_POSITION_3, NODE_CUSTOM_GRAPHICS_POSITION_4, NODE_CUSTOM_GRAPHICS_POSITION_5, NODE_CUSTOM_GRAPHICS_POSITION_6, NODE_CUSTOM_GRAPHICS_POSITION_7, NODE_CUSTOM_GRAPHICS_POSITION_8, NODE_CUSTOM_GRAPHICS_POSITION_9};
    }
}

