/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.render.immed.nodeshape;

import cytoscape.render.immed.nodeshape.AbstractNodeShape;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;

public class EllipseNodeShape
extends AbstractNodeShape {
    private final Ellipse2D.Float ellipse = new Ellipse2D.Float(0.0f, 0.0f, 1.0f, 1.0f);

    public EllipseNodeShape() {
        super((byte)2);
    }

    public Shape getShape(float xMin, float yMin, float xMax, float yMax) {
        this.ellipse.setFrame(xMin, yMin, xMax - xMin, yMax - yMin);
        return this.ellipse;
    }

    public boolean computeEdgeIntersection(float xMin, float yMin, float xMax, float yMax, float ptX, float ptY, float[] returnVal) {
        double centerX = ((double)xMax + (double)xMin) / 2.0;
        double centerY = ((double)yMax + (double)yMin) / 2.0;
        if (centerX == (double)ptX && centerY == (double)ptY) {
            return false;
        }
        double ptPrimeX = (double)ptX - centerX;
        double ptPrimeY = (double)ptY - centerY;
        double ellpW = (double)xMax - (double)xMin;
        double ellpH = (double)yMax - (double)yMin;
        double xScaleFactor = 2.0 / ellpW;
        double yScaleFactor = 2.0 / ellpH;
        double xformedPtPrimeX = ptPrimeX * xScaleFactor;
        double xformedPtPrimeY = ptPrimeY * yScaleFactor;
        double xformedDist = Math.sqrt(xformedPtPrimeX * xformedPtPrimeX + xformedPtPrimeY * xformedPtPrimeY);
        double xsectXformedPtPrimeX = xformedPtPrimeX / xformedDist;
        double xsectXformedPtPrimeY = xformedPtPrimeY / xformedDist;
        double xsectPtPrimeX = xsectXformedPtPrimeX / xScaleFactor;
        double xsectPtPrimeY = xsectXformedPtPrimeY / yScaleFactor;
        returnVal[0] = (float)(xsectPtPrimeX + centerX);
        returnVal[1] = (float)(xsectPtPrimeY + centerY);
        return true;
    }
}

