/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual;

import cytoscape.CyEdge;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import cytoscape.visual.Appearance;
import cytoscape.visual.ArrowShape;
import cytoscape.visual.LineStyle;
import cytoscape.visual.VisualPropertyType;
import ding.view.ObjectPositionImpl;
import giny.view.Justification;
import giny.view.Position;
import java.awt.Color;
import java.awt.Font;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class BypassHelperTest
extends TestCase {
    CyNode homer;
    CyNode marge;
    CyEdge lisa;
    CyAttributes nodeAttrs;
    CyAttributes edgeAttrs;
    String id;

    public BypassHelperTest(String name) {
        super(name);
    }

    public void setUp() {
        this.homer = Cytoscape.getCyNode("homer", true);
        this.marge = Cytoscape.getCyNode("marge", true);
        this.lisa = Cytoscape.getCyEdge(this.homer, this.marge, "interaction", "pp", true);
        this.nodeAttrs = Cytoscape.getNodeAttributes();
        this.edgeAttrs = Cytoscape.getEdgeAttributes();
        this.id = this.homer.getIdentifier();
        this.nodeAttrs.setAttribute(this.id, "node.fillColor", "25,31,244");
        this.nodeAttrs.setAttribute(this.id, "node.borderColor", "junk");
        this.nodeAttrs.setAttribute(this.id, "node.size", "22.0");
        this.nodeAttrs.setAttribute(this.id, "node.labelPosition", "NE,W,c,13,-1");
        this.nodeAttrs.setAttribute(this.id, "node.font", "SansSerif,italic,10");
        this.nodeAttrs.setAttribute(this.id, "node.lineStyle", "LONG_DASH");
        this.nodeAttrs.setAttribute(this.id, "node.shape", "DIAMOND");
        this.edgeAttrs.setAttribute(this.lisa.getIdentifier(), "edge.sourceArrowShape", "WHITE_DELTA");
    }

    public void testGetBypass() {
        Object o = null;
        o = Appearance.getBypass(this.nodeAttrs, this.id, VisualPropertyType.NODE_FILL_COLOR);
        System.out.println("id " + this.id);
        System.out.println("o " + o.toString());
        BypassHelperTest.assertTrue("color equals", ((Color)o).equals(new Color(25, 31, 244)));
        o = Appearance.getBypass(this.nodeAttrs, this.id, VisualPropertyType.NODE_SIZE);
        BypassHelperTest.assertEquals("size equals", 22.0, (Double)o, 1.0E-4);
        o = Appearance.getBypass(this.nodeAttrs, this.id, VisualPropertyType.NODE_LABEL_POSITION);
        System.out.println("lab pos " + o.toString());
        ObjectPositionImpl nlp = new ObjectPositionImpl(Position.NORTH_EAST, Position.WEST, Justification.JUSTIFY_CENTER, 13.0, -1.0);
        System.out.println("new lab pos " + ((Object)nlp).toString());
        BypassHelperTest.assertTrue("label position equals", ((Object)nlp).equals(o));
        o = Appearance.getBypass(this.nodeAttrs, this.id, VisualPropertyType.NODE_FONT_FACE);
        BypassHelperTest.assertTrue("font equals", new Font("SansSerif", 2, 10).equals((Font)o));
        o = Appearance.getBypass(this.nodeAttrs, this.id, VisualPropertyType.NODE_LINE_STYLE);
        BypassHelperTest.assertTrue("linestyle equals", LineStyle.LONG_DASH.equals((Object)((LineStyle)((Object)o))));
        o = Appearance.getBypass(this.edgeAttrs, this.lisa.getIdentifier(), VisualPropertyType.EDGE_SRCARROW_SHAPE);
        BypassHelperTest.assertTrue("arrow equals", ArrowShape.DELTA == (ArrowShape)((Object)o));
    }

    public void testGetColorBypass() {
        Color c = (Color)Appearance.getBypass(this.nodeAttrs, this.id, VisualPropertyType.NODE_FILL_COLOR);
        BypassHelperTest.assertTrue("color equals", c.equals(new Color(25, 31, 244)));
        c = (Color)Appearance.getBypass(this.nodeAttrs, this.id, VisualPropertyType.NODE_BORDER_COLOR);
        System.out.print("should be null: ");
        System.out.println(c);
        BypassHelperTest.assertNull("border color null ", c);
    }

    public static void main(String[] args) {
        TestRunner.run(new TestSuite(BypassHelperTest.class));
    }
}

