### R code from vignette source 'GOSim.Rnw'
### Encoding: ISO8859-1

###################################################
### code chunk number 1: GOSim.Rnw:41-43
###################################################
library(GOSim)
genes=c("207","208","596","901","780","3169","9518","2852","26353","8614","7494")


###################################################
### code chunk number 2: GOSim.Rnw:46-47
###################################################
getGOInfo(genes)


###################################################
### code chunk number 3: GOSim.Rnw:53-54
###################################################
getTermSim(c("GO:0007166","GO:0007267","GO:0007584","GO:0007165","GO:0007186"),method="Resnik",verbose=FALSE)


###################################################
### code chunk number 4: GOSim.Rnw:67-69
###################################################
data("ICsBPhumanall")
IC[c("GO:0007166","GO:0007267","GO:0007584","GO:0007165","GO:0007186")]


###################################################
### code chunk number 5: GOSim.Rnw:76-77
###################################################
getTermSim(c("GO:0007166","GO:0007267","GO:0007584","GO:0007165","GO:0007186"),verbose=FALSE)


###################################################
### code chunk number 6: GOSim.Rnw:86-87
###################################################
getTermSim(c("GO:0007166","GO:0007267","GO:0007584","GO:0007165","GO:0007186"),method="Lin",verbose=FALSE)


###################################################
### code chunk number 7: GOExample
###################################################
library(igraph)
G = getGOGraph(c("GO:0007166","GO:0007267"))
G2 = igraph.from.graphNEL(G)
plot(G2, vertex.label=V(G2)$name)


###################################################
### code chunk number 8: GOSim.Rnw:101-102
###################################################
getMinimumSubsumer("GO:0007166","GO:0007267")


###################################################
### code chunk number 9: GOSim.Rnw:113-114
###################################################
getDisjCommAnc("GO:0007166","GO:0007267")


###################################################
### code chunk number 10: GOSim.Rnw:123-124
###################################################
getTermSim(c("GO:0007166","GO:0007267","GO:0007584","GO:0007165","GO:0007186"),method="CoutoResnik",verbose=FALSE)


###################################################
### code chunk number 11: GOSim.Rnw:128-130
###################################################
setEnrichmentFactors(alpha=0.5,beta=0.3)
getTermSim(c("GO:0007166","GO:0007267","GO:0007584","GO:0007165","GO:0007186"),method="CoutoEnriched",verbose=FALSE)


###################################################
### code chunk number 12: GOSim.Rnw:137-138
###################################################
getTermSim(c("GO:0007166","GO:0007267","GO:0007584","GO:0007165","GO:0007186"),method="relevance",verbose=FALSE)


###################################################
### code chunk number 13: GOSim.Rnw:192-193
###################################################
getGOInfo(c("8614","2852"))


###################################################
### code chunk number 14: GOSim.Rnw:212-213
###################################################
getGeneSim(c("8614","2852"),similarity="OA",similarityTerm="Lin",avg=FALSE, verbose=TRUE)


###################################################
### code chunk number 15: GOSim.Rnw:217-219
###################################################
getGeneSim(c("8614","2852"),similarity="max",similarityTerm="Lin",verbose=FALSE)
getGeneSim(c("8614","2852"),similarity="funSimMax",similarityTerm="Lin",verbose=FALSE)


###################################################
### code chunk number 16: GOSim.Rnw:232-233
###################################################
getGeneSim(c("8614","2852"),similarity="hausdorff",similarityTerm="Lin",verbose=FALSE)


###################################################
### code chunk number 17: GOSim.Rnw:242-243
###################################################
getGeneSim(c("8614","2852"),similarity="dot",method="Tanimoto", verbose=FALSE)


###################################################
### code chunk number 18: GOSim.Rnw:246-247
###################################################
features = getGeneFeatures(c("8614","2852"))


###################################################
### code chunk number 19: GOSim.Rnw:254-255
###################################################
proto = selectPrototypes(n=5,verbose=FALSE)


###################################################
### code chunk number 20: GOSim.Rnw:265-266
###################################################
PHI = getGeneFeaturesPrototypes(genes,prototypes=proto,verbose=FALSE)


###################################################
### code chunk number 21: GOPCAExample
###################################################
x=seq(min(PHI$features[,1]),max(PHI$features[,1]),length.out=100)
y=seq(min(PHI$features[,2]),max(PHI$features[,2]),length.out=100)
plot(x,y,xlab="principal component 1",ylab="principal component 2",type="n")
text(PHI$features[,1],PHI$features[,2],labels=genes)


###################################################
### code chunk number 22: GOSim.Rnw:287-290 (eval = FALSE)
###################################################
## sim = getGeneSimPrototypes(genes,prototypes=proto,similarityTerm="Resnik",verbose=FALSE)
## h=hclust(as.dist(1-sim$similarity),"ward")
## plot(h,xlab="")


###################################################
### code chunk number 23: GOSim.Rnw:316-318 (eval = FALSE)
###################################################
## ev = evaluateClustering(c(2,3,2,3,1,2,1,1,3,1,2), sim$similarity)
## plot(ev$clustersil,main="")


###################################################
### code chunk number 24: GOSim.Rnw:332-336
###################################################
library(org.Hs.eg.db)
library(topGO)
allgenes = union(c("8614", "9518", "780", "2852"), sample(keys(org.Hs.egGO), 1000)) # suppose these are all genes 
GOenrichment(c("8614", "9518", "780", "2852"), allgenes) # print out what cluster 1 is about


