## ----bioconductor, message=FALSE, warning=FALSE, eval=FALSE--------------
#  source("http://bioconductor.org/biocLite.R")
#  biocLite("DMRcate")

## ----libr, message=FALSE, warning=FALSE----------------------------------
library(DMRcate)

## ----loaddata------------------------------------------------------------
data(dmrcatedata)
myMs <- logit2(myBetas)

## ----filter--------------------------------------------------------------
nrow(illuminaSNPs)
nrow(myMs)
myMs.noSNPs <- rmSNPandCH(myMs, dist=2, mafcut=0.05)
nrow(myMs.noSNPs)

## ----annotate------------------------------------------------------------
patient <- factor(sub("-.*", "", colnames(myMs)))
type <- factor(sub(".*-", "", colnames(myMs)))
design <- model.matrix(~patient + type) 
myannotation <- cpg.annotate(myMs.noSNPs, analysis.type="differential",
    design=design, coef=39)

## ----dmrcate-------------------------------------------------------------
dmrcoutput <- dmrcate(myannotation, lambda=1000, C=2)

## ----plotting------------------------------------------------------------
head(dmrcoutput$results)
DMR.plot(dmrcoutput=dmrcoutput, dmr=2, betas=myBetas, 
         phen.col=c(rep("orange", 38), rep("blue", 38)), 
         pch=16, toscale=TRUE, plotmedians=TRUE)

## ----sessionInfo---------------------------------------------------------
sessionInfo()

