### R code from vignette source 'supraHex_vignettes.Rnw'

###################################################
### code chunk number 1: supraHex_vignettes.Rnw:99-104
###################################################
library("supraHex")
pdf("supraHex_vignettes-suprahex.pdf", width=6, height=6)
sTopol <- sTopology(xdim=15, ydim=15, lattice="hexa", shape="suprahex")
visHexMapping(sTopol,mappingType="indexes",newpage=F)
dev.off()


###################################################
### code chunk number 2: supraHex_vignettes.Rnw:127-130 (eval = FALSE)
###################################################
## source("http://bioconductor.org/biocLite.R")
## biocLite("supraHex",depend=TRUE)
## library(supraHex) # load the package


###################################################
### code chunk number 3: supraHex_vignettes.Rnw:134-136 (eval = FALSE)
###################################################
## library(help="supraHex") # real-time help
## help.start() # html help (follow the links to supraHex)


###################################################
### code chunk number 4: supraHex_vignettes.Rnw:140-141 (eval = FALSE)
###################################################
## browseVignettes("supraHex")


###################################################
### code chunk number 5: supraHex_vignettes.Rnw:145-146 (eval = FALSE)
###################################################
## citation("supraHex") # cite the package


###################################################
### code chunk number 6: startup
###################################################
data <- cbind(
matrix(rnorm(1000*3,mean=0.5,sd=1), nrow=1000, ncol=3), 
matrix(rnorm(1000*3,mean=-0.5,sd=1), nrow=1000, ncol=3)
)
colnames(data) <- c("S1","S1","S1","S2","S2","S2")


###################################################
### code chunk number 7: supraHex_vignettes.Rnw:233-234
###################################################
data[1:5,]


###################################################
### code chunk number 8: supraHex_vignettes.Rnw:239-240 (eval = FALSE)
###################################################
## data <- read.table(file="you_input_data_file", header=T, row.names=1, sep="\t")


###################################################
### code chunk number 9: supraHex_vignettes.Rnw:262-263
###################################################
sMap <- sPipeline(data=data)


###################################################
### code chunk number 10: supraHex_vignettes.Rnw:268-271
###################################################
# it will also write out a file ('Output.txt') into your disk
output <- sWriteData(sMap=sMap, data=data, filename="Output.txt") 
output[1:5,]


###################################################
### code chunk number 11: supraHex_vignettes.Rnw:285-286 (eval = FALSE)
###################################################
## visHexMapping(sMap,mappingType="indexes",newpage=F)


###################################################
### code chunk number 12: supraHex_vignettes.Rnw:290-293
###################################################
pdf("supraHex_vignettes-hit.pdf", width=6, height=6)
visHexMapping(sMap,mappingType="hits",newpage=F)
dev.off()


###################################################
### code chunk number 13: supraHex_vignettes.Rnw:298-301
###################################################
pdf("supraHex_vignettes-distance.pdf", width=6, height=6)
visHexMapping(sMap,mappingType="dist",newpage=F)
dev.off()


###################################################
### code chunk number 14: supraHex_vignettes.Rnw:313-317
###################################################
pdf("supraHex_vignettes-line.pdf", width=6, height=6)
visHexPattern(sMap, plotType="lines", 
customized.color=rep(c("red","green"),each=3),newpage=F)
dev.off()


###################################################
### code chunk number 15: supraHex_vignettes.Rnw:322-326
###################################################
pdf("supraHex_vignettes-bar.pdf", width=6, height=6)
visHexPattern(sMap, plotType="bars", 
customized.color=rep(c("red","green"),each=3),newpage=F)
dev.off()


###################################################
### code chunk number 16: supraHex_vignettes.Rnw:333-335 (eval = FALSE)
###################################################
## ?visHexMapping
## ?visHexPattern


###################################################
### code chunk number 17: supraHex_vignettes.Rnw:344-349
###################################################
sBase <- sDmatCluster(sMap=sMap, which_neigh=1, 
distMeasure="median", clusterLinkage="average")
pdf("supraHex_vignettes-cluster.pdf", width=6, height=6)
visDmatCluster(sMap, sBase, newpage=F)
dev.off()


###################################################
### code chunk number 18: supraHex_vignettes.Rnw:355-358
###################################################
# it will also write out a file ('Output_base.txt') into your disk
output <- sWriteData(sMap, data, sBase, filename="Output_base.txt")
output[1:5,]


###################################################
### code chunk number 19: supraHex_vignettes.Rnw:369-371 (eval = FALSE)
###################################################
## sReorder <- sCompReorder(sMap=sMap, amplifier=2, metric="cos")
## visCompReorder(sMap=sMap, sReorder=sReorder)


###################################################
### code chunk number 20: supraHex_vignettes.Rnw:384-387
###################################################
pdf("supraHex_vignettes-kernels.pdf", width=12, height=6)
visKernels(newpage=F)
dev.off()


###################################################
### code chunk number 21: supraHex_vignettes.Rnw:396-398 (eval = FALSE)
###################################################
## sMap_ga <- sPipeline(data=data, neighKernel="gaussian", verbose=F)
## visHexMulComp(sMap_ga)


###################################################
### code chunk number 22: supraHex_vignettes.Rnw:403-405 (eval = FALSE)
###################################################
## sMap_bu <- sPipeline(data=data, neighKernel="bubble", verbose=F)
## visHexMulComp(sMap_bu)


###################################################
### code chunk number 23: supraHex_vignettes.Rnw:410-412 (eval = FALSE)
###################################################
## sMap_cu <- sPipeline(data=data, neighKernel="cutgaussian", verbose=F)
## visHexMulComp(sMap_cu)


###################################################
### code chunk number 24: supraHex_vignettes.Rnw:417-419 (eval = FALSE)
###################################################
## sMap_ep <- sPipeline(data=data, neighKernel="ep", verbose=F)
## visHexMulComp(sMap_ep)


###################################################
### code chunk number 25: supraHex_vignettes.Rnw:424-426 (eval = FALSE)
###################################################
## sMap_gm <- sPipeline(data=data, neighKernel="gamma", verbose=F)
## visHexMulComp(sMap_gm)


###################################################
### code chunk number 26: sessinfo
###################################################
sessionInfo()


