/*
 * Decompiled with CFR 0.152.
 */
package facs;

import facs.ColorGradient;
import java.awt.Color;

public final class UnidirectionalColorGradient
implements ColorGradient {
    private static final Color DEFAULT_COLOR = Color.black;
    private static final Color[] BLUE_TO_BLACK = new Color[]{new Color(200, 200, 255), new Color(0, 0, 255), new Color(0, 0, 0)};
    private static final Color[] BLACK_TO_YELLOW = new Color[]{new Color(0, 0, 0), new Color(255, 255, 0), new Color(255, 255, 200)};
    private static final Color[] GREY_TO_BLACK = new Color[]{new Color(247, 247, 247), new Color(123, 123, 123), new Color(0, 0, 0)};
    private static final Color[] BLACK_TO_GREY = new Color[]{new Color(0, 0, 0), new Color(123, 123, 123), new Color(247, 247, 247)};
    private static final Color[] GREEN_TO_BLACK = new Color[]{new Color(200, 255, 200), new Color(0, 255, 0), new Color(0, 0, 0)};
    private static final Color[] BLACK_TO_RED = new Color[]{new Color(0, 0, 0), new Color(255, 0, 0), new Color(255, 200, 200)};
    private final double min;
    private final double max;
    private Color minColor;
    private Color maxColor;
    private final boolean sameP;
    private int colorCount;
    private Color[] colors;
    private double[] values;

    UnidirectionalColorGradient(double min, double max, Color minColor, Color maxColor) {
        if (min > max) {
            this.min = max;
            this.max = min;
            this.minColor = maxColor;
            this.maxColor = minColor;
        } else {
            this.min = min;
            this.max = max;
            this.minColor = minColor;
            this.maxColor = maxColor;
        }
        if (this.minColor == null) {
            this.minColor = DEFAULT_COLOR;
        }
        if (this.maxColor == null) {
            this.maxColor = DEFAULT_COLOR;
        }
        this.sameP = this.minColor.equals(this.maxColor);
        this.colorCount = -1;
        this.colors = null;
        this.values = null;
    }

    UnidirectionalColorGradient(double min, double max, Color[] colors) {
        boolean flippedP = false;
        if (min > max) {
            this.min = max;
            this.max = min;
            flippedP = true;
        } else {
            this.min = min;
            this.max = max;
        }
        if (colors == null) {
            this.minColor = DEFAULT_COLOR;
            this.maxColor = DEFAULT_COLOR;
            this.sameP = true;
            this.colorCount = -1;
            colors = null;
            this.values = null;
        } else {
            this.colorCount = colors.length;
            if (this.colorCount > 2) {
                int i;
                this.colors = new Color[this.colorCount];
                System.arraycopy(colors, 0, this.colors, 0, this.colorCount);
                if (flippedP) {
                    for (i = 0; i <= this.colorCount / 2 - 1; ++i) {
                        int index = this.colorCount - 1 - i;
                        Color temp = this.colors[i];
                        this.colors[i] = this.colors[index];
                        this.colors[index] = temp;
                    }
                }
                this.values = new double[this.colorCount];
                this.values[0] = this.min;
                this.values[this.colorCount - 1] = this.max;
                double increment = (this.max - this.min) / (double)(this.colorCount - 1);
                for (i = 1; i < this.colorCount - 1; ++i) {
                    this.values[i] = this.min + (double)i * increment;
                }
                this.sameP = false;
            } else {
                if (this.colorCount == 2) {
                    if (flippedP) {
                        this.minColor = colors[1];
                        this.maxColor = colors[0];
                    } else {
                        this.minColor = colors[0];
                        this.maxColor = colors[1];
                    }
                    this.sameP = this.minColor.equals(this.maxColor);
                } else if (this.colorCount == 1) {
                    this.minColor = colors[0];
                    this.maxColor = colors[0];
                    this.sameP = true;
                } else {
                    this.minColor = DEFAULT_COLOR;
                    this.maxColor = DEFAULT_COLOR;
                    this.sameP = true;
                }
                this.colorCount = -1;
                colors = null;
                this.values = null;
            }
        }
    }

    public double getMinimum() {
        return this.min;
    }

    public double getMaximum() {
        return this.max;
    }

    public Color getMinimumColor() {
        if (this.colorCount <= -1) {
            return this.minColor;
        }
        if (this.colorCount > 2) {
            return this.colors[0];
        }
        return DEFAULT_COLOR;
    }

    public Color getMaximumColor() {
        if (this.colorCount <= -1) {
            return this.maxColor;
        }
        if (this.colorCount > 2) {
            return this.colors[this.colorCount - 1];
        }
        return DEFAULT_COLOR;
    }

    public Color getColor(double value) {
        if (this.colorCount <= -1) {
            if (this.sameP) {
                return this.minColor;
            }
            if (value <= this.min) {
                return this.minColor;
            }
            if (value >= this.max) {
                return this.maxColor;
            }
            return UnidirectionalColorGradient.interpolate(this.minColor, this.maxColor, (value - this.min) / (this.max - this.min));
        }
        if (this.colorCount > 2) {
            if (value <= this.min) {
                return this.colors[0];
            }
            if (value >= this.max) {
                return this.colors[this.colorCount - 1];
            }
            for (int i = 1; i < this.colorCount; ++i) {
                if (value == this.values[i]) {
                    return this.colors[i];
                }
                if (!(value < this.values[i])) continue;
                return UnidirectionalColorGradient.interpolate(this.colors[i - 1], this.colors[i], (value - this.values[i - 1]) / (this.values[i] - this.values[i - 1]));
            }
        }
        return DEFAULT_COLOR;
    }

    private static Color interpolate(Color low, Color high, double fraction) {
        if (Double.isNaN(fraction)) {
            return DEFAULT_COLOR;
        }
        if (low == null) {
            low = DEFAULT_COLOR;
        }
        if (high == null) {
            high = DEFAULT_COLOR;
        }
        if (low.equals(high)) {
            return low;
        }
        int lowR = low.getRed();
        int lowG = low.getGreen();
        int lowB = low.getBlue();
        int r = lowR + (int)(fraction * (double)(high.getRed() - lowR));
        int g = lowG + (int)(fraction * (double)(high.getGreen() - lowG));
        int b = lowB + (int)(fraction * (double)(high.getBlue() - lowB));
        if (r < 0) {
            r = 0;
        } else if (r > 255) {
            r = 255;
        }
        if (g < 0) {
            g = 0;
        } else if (g > 255) {
            g = 255;
        }
        if (b < 0) {
            b = 0;
        } else if (b > 255) {
            b = 255;
        }
        return new Color(r, g, b);
    }

    public static UnidirectionalColorGradient getUnidirectionalColorGradient(int colorSet, boolean maxP, double min, double max) {
        if (colorSet == 1) {
            if (maxP) {
                return new UnidirectionalColorGradient(min, max, BLUE_TO_BLACK);
            }
            return new UnidirectionalColorGradient(min, max, BLACK_TO_YELLOW);
        }
        if (colorSet == 2) {
            if (maxP) {
                return new UnidirectionalColorGradient(min, max, GREEN_TO_BLACK);
            }
            return new UnidirectionalColorGradient(min, max, BLACK_TO_RED);
        }
        if (colorSet == 3) {
            if (maxP) {
                return new UnidirectionalColorGradient(min, max, GREY_TO_BLACK);
            }
            return new UnidirectionalColorGradient(min, max, BLACK_TO_GREY);
        }
        return null;
    }

    public static void main(String[] args) {
        UnidirectionalColorGradient gradient = UnidirectionalColorGradient.getUnidirectionalColorGradient(1, false, 5.0, 10.0);
        for (int i = 0; i <= 10; ++i) {
            Color color = gradient.getColor(i);
            System.out.print(i);
            System.out.print(": (");
            System.out.print(color.getRed());
            System.out.print(", ");
            System.out.print(color.getGreen());
            System.out.print(", ");
            System.out.print(color.getBlue());
            System.out.println(")");
        }
    }
}

