/*
 * Decompiled with CFR 0.152.
 */
package facs;

import facs.PopulationGrid;
import facs.Representation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Illustration {
    public static final int TEST_PATTERN = -1;
    public static final int HISTOGRAM_X = 1;
    public static final int HISTOGRAM_Y = 2;
    public static final int DOT_PLOT = 11;
    public static final int DENSITY_DOT_PLOT = 12;
    public static final int SHADOW_PLOT = 13;
    public static final int CONTOUR_PLOT = 14;
    public static final int SHADED_CONTOUR_PLOT = 15;
    public static final int DENSITY_PLOT = 16;
    public static final int HISTOGRAM_OVERLAY_PLOT_TYPE = 101;
    public static final int THIRD_AXIS_MEDIAN_PLOT = 201;
    public static final int THIRD_AXIS_NINETYFIFTH_PLOT = 202;
    public static final int[] VALID_PLOT_TYPES = new int[]{1, 2, 11, 12, 13, 14, 15, 16, 201, 202, 101};
    public static final int NANO = 32;
    public static final int MICRO = 64;
    public static final int TINY = 96;
    public static final int SMALL = 128;
    public static final int REGULAR = 256;
    public static final int LARGE = 512;
    public static final int HUGE = 1024;
    public static final int[] VALID_PLOT_SIZES = new int[]{32, 64, 96, 128, 256, 512, 1024};
    public static final int VARY_NONE = -1;
    public static final int VARY_X = 0;
    public static final int VARY_Y = 1;
    public static final int VARY_Z = 2;
    public static final int EDIT_NO_STATUS = -1;
    public static final int EDIT_BY_CREATOR = 1;
    public static final int EDIT_BY_COAUTHORS = 2;
    public static final int EDIT_BY_LAB = 3;
    public static final int EDIT_BY_PUBLIC = 4;
    public static final int[] VALID_EDIT_STATUS = new int[]{-1, 1, 2, 3, 4};
    public static final int VIEW_NO_STATUS = -1;
    public static final int VIEW_BY_CREATOR = 1;
    public static final int VIEW_BY_COAUTHORS = 2;
    public static final int VIEW_BY_LAB = 3;
    public static final int VIEW_BY_PUBLIC = 4;
    public static final int[] VALID_VIEW_STATUS = new int[]{-1, 1, 2, 3, 4};
    public static final int NO_CITATION = -1;
    public static final int CITE_DATE = 1;
    public static final int CITE_PR = 2;
    public static final int CITE_PRPI = 3;
    public static final int CITE_ALL = 4;
    public static final int CITE_PR_DATE = 5;
    public static final int CITE_PRPI_DATE = 6;
    public static final int CITE_ALL_DATE = 7;
    public static final int CITE_PI = 8;
    public static final int CITE_PI_DATE = 9;
    public static final int[] VALID_CITATION_TYPES = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
    public static final int NO_STATISTIC = -1;
    public static final int MEAN = 1;
    public static final int MEDIAN = 2;
    public static final int STANDARD_DEVIATION = 3;
    public static final int VARIANCE = 4;
    public static final int MINIMUM = 5;
    public static final int MAXIMUM = 6;
    public static final int PERCENT = 8;
    public static final int EVENT_COUNT = 9;
    public static final int CHANNEL_RANGE = 10;
    public static final int GEOMETRIC_MEAN = 11;
    public static final int STATISTIC_1D_X = 101;
    public static final int STATISTIC_1D_Y = 102;
    public static final int STATISTIC_2D = 103;
    public static final int[] VALID_STATISTICS = new int[]{1, 2, 3, 4, 5, 6, 8, 9, 10, 11, 101, 102, 103};
    public static final int EN_FUEGO = 1;
    public static final int CHILL_OUT = 2;
    public static final int RAINBOW = 3;
    public static final int GREYSCALE = 4;
    public static final int PALE_FIRE = 5;
    public static final int GREEN_TO_RED = 6;
    public static final int BLUE_TO_YELLOW = 7;
    public static final int JONATHAN1 = 1;
    public static final int RYAN1 = 101;
    public static final int WILLIAM1 = 102;
    public static final int NIKESH1 = 103;
    public static final int MARK1 = 104;
    public static final int PETER1 = 105;
    public static final int GREEN = 201;
    public static final int RED = 202;
    public static final int YELLOW = 203;
    public static final int BLUE = 204;
    public static final int FUSCIA = 205;
    public static final int CYAN = 206;
    public static final int HETEROGENEITY_ON_FIRE = 301;
    public static final int[] VALID_COLOR_SETS = new int[]{1, 2, 3, 4, 5, 6, 7, 1, 101, 102, 103, 105, 104, 201, 202, 203, 204, 205, 206, 301};
    public static final int[] VALID_GRADIENT_COLOR_SETS = new int[]{1};
    public static final int NOOB = 0;
    public static final int TUTORIAL = 1;
    public static final int STANDARD_DIMENSIONS = 2;
    public static final int STANDARD_SCALES = 3;
    public static final int COMPACT = 4;
    public static final int STANDARD_BOTH = 5;
    public static final int[] VALID_MENU_STYLES = new int[]{0, 1, 2, 3, 4, 5};
    public static final int ILLUSTRATION_PAGE = -1;
    public static final int SINGLE_PLOT_PAGE = 1;
    public static final int COMPENSATION_PAGE = 1;
    public static final int ALL_REGIONS = -3;
    public static final int UNGATED = -2;
    public static final int GATE_SET = -1;
    public static final Region UNIVERSAL_REGION = new Region(-3);
    public static final int GATING_ILLUSTRATION_ID = 0;
    public static final int WORKING_ILLUSTRATION_ID = 1;
    public static final int WIPE_ALL_ILLUSTRATIONS_ID = -999;
    public static final int NONE = -1;
    public static final int HEATMAP = 1;
    public static final int HEATMAP_WITH_STATISTICS = 2;
    public static final int HISTOGRAM_OVERLAY = 3;
    public static final int HISTOGRAM_OVERLAY_WITH_STATISTICS = 4;
    public static final int HEATMAP_ONE_IMAGE = 5;
    public static final int HEATMAP_ONE_IMAGE_WITH_STATISTICS = 6;
    public static final int[] VALID_LAYOUT_OVERRIDE_TYPES = new int[]{1, 2, 3, 4, 5, 6};
    public static final int PANEL_DEFAULT_REPRESENTATION_ID = -2;
    public static final String placeholder_small_imagepath = "bitmaps/flow_tube_small.jpg";
    public static final String DEFAULT_NAME = "Illustration ";
    public static final int DEFAULT_PLOT_TYPE = 12;
    public static final boolean DEFAULT_BACKGROUND_FLAG = false;
    public static final boolean DEFAULT_PLOT_BACKGROUND_FLAG = false;
    public static final boolean DEFAULT_SHOW_SCALE_LABELS_FLAG = false;
    public static final int DEFAULT_STAT_TYPE = -1;
    public static final int DEFAULT_COLOR_SET = 1;
    public static final boolean DEFAULT_ANNOTATION_FLAG = true;
    public static final boolean DEFAULT_SHOW_SCALE_TICKS_FLAG = true;
    public static final boolean DEFAULT_SHOW_AXIS_LABELS_FLAG = true;
    public static final boolean DEFAULT_LONG_LABELS_FLAG = false;
    public static final double DEFAULT_SMOOTHING = 1.0;
    public static final double DEFAULT_ASPECT_RATIO = 1.0;
    public static final double DEFAULT_CONTOUR_PERCENT = 10.0;
    public static final double DEFAULT_CONTOUR_START_PERCENT = 10.0;
    public static final boolean DEFAULT_USE_PLACEHOLDERS_FLAG = false;
    public static final boolean DEFAULT_USE_PRINT_VIEW_FLAG = false;
    public static final boolean DEFAULT_PANEL_DEFAULT_FLAG = false;
    public static final boolean DEFAULT_SHOW_DETAILS_FLAG = false;
    public static final boolean DEFAULT_SHOW_TITLE_FLAG = true;
    public static final int DEFAULT_CHANNEL_INDEX = -1;
    public static final int DEFAULT_X_CHANNEL = 1;
    public static final int DEFAULT_Y_CHANNEL = 2;
    public static final int DEFAULT_Z_CHANNEL = 3;
    public static final int DEFAULT_VARIABLE_CHANNEL = 0;
    public static final int DEFAULT_CHANNEL_COUNT = -1;
    public static final ArrayList DEFAULT_GATE_SET_IDS = new ArrayList<Integer>(){
        {
            this.add(-2);
        }
    };
    public static final ArrayList DEFAULT_REGIONS = new ArrayList<Region>(){
        {
            this.add(UNIVERSAL_REGION);
        }
    };
    public static final int DEFAULT_SCALE_FLAG = 4;
    public static final String DEFAULT_SCALE_ARGUMENT = "200";
    public static final double DEFAULT_SCALE_MINIMUM = -200.0;
    public static final double DEFAULT_SCALE_MAXIMUM = 262144.0;
    public static final int DEFAULT_POPULATION_TYPE = -1;
    public static final int DEFAULT_POPULATION_CUTOFF = -1;
    public static final int DEFAULT_EVENT_COUNT = -1;
    public static final int DEFAULT_CITATION = 6;
    public static final int DEFAULT_EDIT_STATUS = 1;
    public static final int DEFAULT_VIEW_STATUS = 2;
    public static final int DEFAULT_CREATOR_ID = -1;
    public static final int DEFAULT_MENU_STYLE = 2;
    public static final int DEFAULT_PLOT_SIZE = 128;
    public static final String DEFAULT_CREATION_QUERY_STRING = null;
    public static final String DEFAULT_KEYSTONE_FILENAME = "";
    public static final int DEFAULT_LAYOUT_OVERRIDE = -1;
    public static final int DEFAULT_STATISTIC = 13;
    public static final int DEFAULT_EQUATION = 6;
    public static final String DEFAULT_FORMULA = null;
    public static final int DEFAULT_CONTROL = 11;
    public static final int DEFAULT_CONTROL_ROW = -1;
    public static final int DEFAULT_CONTROL_COLUMN = -1;
    public static final double DEFAULT_RANGE = Double.NaN;
    public static final IllustrationDimension DEFAULT_ROW = null;
    public static final IllustrationDimension DEFAULT_COLUMN = null;
    public static final String ILLUSTRATION_PARAM_NAME = "illustration";
    public static final String ID_PARAM_NAME = "illustrationID";
    public static final String CREATOR_EXPERIMENT_ID_PARAM_NAME = "experimentID";
    public static final String NAME_PARAM_NAME = "illustrationName";
    public static final String PLOT_TYPE_PARAM_NAME = "plotType";
    public static final String FROM_XML_PARAM_NAME = "fromXML";
    public static final String BLACK_BACKGROUND_PARAM_NAME = "blackBackground";
    public static final String BLACK_PLOT_BACKGROUND_PARAM_NAME = "blackPlotBackground";
    public static final String X_CHANNEL_PARAM_NAME = "xChannel";
    public static final String Y_CHANNEL_PARAM_NAME = "yChannel";
    public static final String Z_CHANNEL_PARAM_NAME = "zChannel";
    public static final String VARIABLE_CHANNEL_PARAM_NAME = "variableChannel";
    public static final String COMPENSATION_ID_PARAM_NAME = "compensationID";
    public static final String CHANNEL_COUNT_PARAM_NAME = "channelCount";
    public static final String GATE_SET_IDS_PARAM_NAME = "gateSetID";
    public static final String SCALE_FLAG_PARAM_NAME = "scale";
    public static final String SCALE_ARGUMENT_PARAM_NAME = "scaleArg";
    public static final String SCALE_MINIMUM_PARAM_NAME = "min";
    public static final String SCALE_MAXIMUM_PARAM_NAME = "max";
    public static final String POPULATION_TYPE_PARAM_NAME = "populationType";
    public static final String POPULATION_CUTOFF_PARAM_NAME = "layoutPopulationCutoff";
    public static final String EVENT_COUNT_PARAM_NAME = "eventCount";
    public static final String PANEL_DEFAULT_PARAM_NAME = "panelDefault";
    public static final String CITATION_FORMAT_PARAM_NAME = "citationFormat";
    public static final String CREATOR_ID_PARAM_NAME = "creatorID";
    public static final String EDIT_STATUS_PARAM_NAME = "editStatus";
    public static final String VIEW_STATUS_PARAM_NAME = "viewStatus";
    public static final String MENU_STYLE_PARAM_NAME = "menuStyle";
    public static final String PLOT_SIZE_PARAM_NAME = "axisBins";
    public static final String SAVE_FLAG_PARAM_NAME = "saveFlag";
    public static final String DELETE_FLAG_PARAM_NAME = "deleteFlag";
    public static final String DELETE_ALL_FLAG_PARAM_NAME = "deleteAllFlag";
    public static final String SHOW_SCALE_LABELS_PARAM_NAME = "scaleLabel";
    public static final String STAT_TYPE_PARAM_NAME = "statType";
    public static final String COLOR_SET_PARAM_NAME = "colorSet";
    public static final String ANNOTATION_PARAM_NAME = "annotation";
    public static final String SHOW_SCALE_TICKS_PARAM_NAME = "scaleTick";
    public static final String SHOW_AXIS_LABELS_PARAM_NAME = "axisLabel";
    public static final String LONG_LABELS_PARAM_NAME = "longLabel";
    public static final String SMOOTHING_PARAM_NAME = "smoothing";
    public static final String ASPECT_RATIO_PARAM_NAME = "aspectRatio";
    public static final String CONTOUR_PERCENT_PARAM_NAME = "contourPercent";
    public static final String CONTOUR_START_PERCENT_PARAM_NAME = "contourStartPercent";
    public static final String USE_PLACEHOLDERS_PARAM_NAME = "usePlaceholders";
    public static final String USE_PRINT_VIEW_PARAM_NAME = "usePrintView";
    public static final String SHOW_PANEL_DEFAULT_NAME = "panelDefault";
    public static final String SHOW_DETAILS_PARAM_NAME = "showDetails";
    public static final String SHOW_TITLE_PARAM_NAME = "showTitle";
    public static final String CREATION_QUERY_STRING_PARAM_NAME = "creationQueryString";
    public static final String KEYSTONE_FILENAME_PARAM_NAME = "keystoneFilename";
    public static final String ACTIVE_DIMENSIONS_PARAM_NAME = "activeDimensions";
    public static final String ILLUSTRATION_DIMENSION_PARAM_NAME = "illustrationDimension";
    public static final String DIMENSION_PREFIX = "illD";
    public static final String REGION_PREFIX = "region";
    public static final String LAYOUT_OVERRIDE_PARAM_NAME = "layoutOverride";
    public static final String STATISTIC_PARAM_NAME = "statistic";
    public static final String EQUATION_PARAM_NAME = "equation";
    public static final String FORMULA_PARAM_NAME = "formula";
    public static final String CONTROL_PARAM_NAME = "control";
    public static final String CONTROL_ROW_PARAM_NAME = "controlRow";
    public static final String CONTROL_COLUMN_PARAM_NAME = "controlColumn";
    public static final String RANGE_PARAM_NAME = "range";
    public static final String ROW_PARAM_NAME = "row";
    public static final String COLUMN_PARAM_NAME = "column";
    public static final String OVERLAY_PARAM_NAME = "overlay";
    public static final String HEATMAP_PARAM_NAME = "heatmap";
    private int id;
    private int creatorExperimentID;
    private String name;
    private String keystoneFilename;
    private int plotType;
    private int plotSize;
    private int xChannel;
    private int yChannel;
    private int zChannel;
    private int variableChannel;
    private int compensationID;
    private int channelCount;
    private ArrayList gateSetIDs;
    private ArrayList regions;
    private int[] scaleFlags;
    private String[] scaleArguments;
    private double[] minimums;
    private double[] maximums;
    private int populationType;
    private int populationCutoff;
    private int eventCount;
    private int dotSize;
    private int citationFormat;
    private int creatorID;
    private int editStatus;
    private int viewStatus;
    private int menuStyle;
    private boolean blackBackgroundP;
    private boolean blackPlotBackgroundP;
    private boolean usePlaceholdersP;
    private boolean usePrintViewP;
    private boolean showDetailsP;
    private boolean panelDefaultP;
    private boolean showTitleP;
    private boolean showScaleLabelsP;
    private int statType;
    private int colorSet;
    private boolean channelsAndScalesAreValid;
    private boolean annotationP;
    private boolean showScaleTicksP;
    private boolean showAxisLabelsP;
    private boolean longLabelsP;
    private double smoothing;
    private double aspectRatio;
    private double contourPercent;
    private double contourStartPercent;
    private ArrayList<IllustrationDimension> dimensions;
    private String creationQueryString;
    private int layoutOverride;
    private int statistic;
    private int equation;
    private String formula;
    private int control;
    private int controlRow;
    private int controlColumn;
    private double range;
    private IllustrationDimension row;
    private IllustrationDimension column;

    private void setToDefaultValues() {
        this.name = "Illustration";
        this.plotType = 12;
        this.blackBackgroundP = false;
        this.blackPlotBackgroundP = false;
        this.xChannel = -1;
        this.yChannel = -1;
        this.zChannel = -1;
        this.plotSize = 128;
        this.variableChannel = 0;
        this.channelCount = -1;
        this.gateSetIDs = DEFAULT_GATE_SET_IDS;
        this.regions = DEFAULT_REGIONS;
        this.populationType = -1;
        this.populationCutoff = -1;
        this.eventCount = -1;
        this.citationFormat = 6;
        this.editStatus = 1;
        this.viewStatus = 2;
        this.menuStyle = 2;
        this.usePlaceholdersP = false;
        this.showScaleLabelsP = false;
        this.statType = -1;
        this.colorSet = 1;
        this.annotationP = true;
        this.showScaleTicksP = true;
        this.showAxisLabelsP = true;
        this.longLabelsP = false;
        this.smoothing = 1.0;
        this.aspectRatio = 1.0;
        this.contourPercent = 10.0;
        this.contourStartPercent = 10.0;
        this.usePrintViewP = false;
        this.panelDefaultP = false;
        this.showDetailsP = false;
        this.showTitleP = true;
        this.dimensions = new ArrayList();
        this.creationQueryString = DEFAULT_CREATION_QUERY_STRING;
        this.layoutOverride = -1;
        this.statistic = 13;
        this.equation = 6;
        this.formula = DEFAULT_FORMULA;
        this.control = 11;
        this.controlRow = -1;
        this.controlColumn = -1;
        this.range = Double.NaN;
        this.row = DEFAULT_ROW;
        this.column = DEFAULT_COLUMN;
    }

    public int getNextDimensionID(IllustrationDimension[] illustrationDimensions) {
        int maxID = 0;
        if (illustrationDimensions != null && illustrationDimensions.length > 0) {
            for (int i = 0; i < illustrationDimensions.length; ++i) {
                if (illustrationDimensions[i] == null || illustrationDimensions[i].getID() <= maxID) continue;
                maxID = illustrationDimensions[i].getID();
            }
        }
        return maxID + 1;
    }

    public int getNextOrderValue() {
        int nextOrderValue = 0;
        IllustrationDimension[] illustrationDimensions = this.getActiveDimensions();
        if (illustrationDimensions != null && illustrationDimensions.length > 0) {
            for (int i = 0; i < illustrationDimensions.length; ++i) {
                if (nextOrderValue > illustrationDimensions[i].getOrder()) continue;
                nextOrderValue = illustrationDimensions[i].getOrder() + 1;
            }
        }
        return nextOrderValue;
    }

    public IllustrationDimension[] getActiveDimensions() {
        return this.toArray();
    }

    public int[] getActiveFigureDimensionIDs() {
        IllustrationDimension[] activeDimensions = this.getActiveDimensions();
        int[] activeIDs = null;
        if (activeDimensions != null && activeDimensions.length > 0) {
            activeIDs = new int[activeDimensions.length];
            for (int k = 0; k < activeDimensions.length; ++k) {
                activeIDs[k] = activeDimensions[k].getTargetFigureDimensionID();
            }
        }
        return activeIDs;
    }

    public int[] getFixedFigureDimensionIDs() {
        IllustrationDimension[] activeDimensions = this.getActiveDimensions();
        int[] activeIDs = null;
        if (activeDimensions != null && activeDimensions.length > 0) {
            activeIDs = new int[activeDimensions.length];
            for (int k = 0; k < activeDimensions.length; ++k) {
                activeIDs[k] = activeDimensions[k].getTargetFigureDimensionID();
            }
        }
        return activeIDs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Illustration) {
            Illustration ill = (Illustration)obj;
            return this.getID() == ill.getID();
        }
        return false;
    }

    public int hashCode() {
        return this.getID();
    }

    public int[] getGateSetIDs() {
        int size = this.gateSetIDs.size();
        int[] idArray = new int[size];
        for (int i = 0; i < size; ++i) {
            idArray[i] = -1;
            Object obj = this.gateSetIDs.get(i);
            if (!(obj instanceof Integer)) continue;
            Integer id = (Integer)obj;
            idArray[i] = id;
        }
        return idArray;
    }

    public boolean containsGateSetID(int id) {
        if (id < 1) {
            return false;
        }
        Integer newID = new Integer(id);
        return this.gateSetIDs.contains(newID);
    }

    public boolean addGateSetID(int id) {
        if (id < 1) {
            return false;
        }
        Integer newID = new Integer(id);
        if (this.gateSetIDs.contains(newID)) {
            return false;
        }
        return this.gateSetIDs.add(newID);
    }

    public boolean removeGateSetID(int id) {
        if (id < 1) {
            return false;
        }
        Integer newID = new Integer(id);
        return this.gateSetIDs.remove(newID);
    }

    public void clearGateSetIDs() {
        this.gateSetIDs.clear();
    }

    public int getChannelCount() {
        return this.channelCount;
    }

    public void setChannelCount(int channelCount) {
        if (channelCount <= this.channelCount) {
            return;
        }
        int[] scaleFlagArray = new int[this.channelCount];
        System.arraycopy(this.scaleFlags, 0, scaleFlagArray, 0, this.channelCount);
        String[] scaleArgumentArray = new String[this.channelCount];
        System.arraycopy(this.scaleArguments, 0, scaleArgumentArray, 0, this.channelCount);
        double[] minimumArray = new double[this.channelCount];
        System.arraycopy(this.minimums, 0, minimumArray, 0, this.channelCount);
        double[] maximumArray = new double[this.channelCount];
        System.arraycopy(this.maximums, 0, maximumArray, 0, this.channelCount);
        this.scaleFlags = new int[channelCount];
        this.scaleArguments = new String[channelCount];
        this.minimums = new double[channelCount];
        this.maximums = new double[channelCount];
        for (int i = 0; i < channelCount; ++i) {
            this.scaleFlags[i] = 4;
            this.scaleArguments[i] = DEFAULT_SCALE_ARGUMENT;
            this.minimums[i] = -200.0;
            this.maximums[i] = 262144.0;
        }
        System.arraycopy(scaleFlagArray, 0, this.scaleFlags, 0, this.channelCount);
        System.arraycopy(scaleArgumentArray, 0, this.scaleArguments, 0, this.channelCount);
        System.arraycopy(minimumArray, 0, this.minimums, 0, this.channelCount);
        System.arraycopy(maximumArray, 0, this.maximums, 0, this.channelCount);
        this.channelCount = channelCount;
    }

    public int getScaleFlag(int channel) {
        if (channel < 0 || channel >= this.channelCount) {
            return 4;
        }
        return this.scaleFlags[channel];
    }

    public void setScaleFlag(int channel, int flag) {
        if (channel >= 0 && channel < this.channelCount) {
            this.scaleFlags[channel] = flag;
        }
    }

    public String getScaleArgumentString(int channel) {
        if (channel < 0 || channel >= this.channelCount) {
            return DEFAULT_SCALE_ARGUMENT;
        }
        return this.scaleArguments[channel];
    }

    public void setScaleArgumentString(int channel, String arg) {
        if (channel >= 0 && channel < this.channelCount) {
            this.scaleArguments[channel] = arg;
        }
    }

    public double getMinimum(int channel) {
        if (channel < 0 || channel >= this.channelCount) {
            return -200.0;
        }
        return this.minimums[channel];
    }

    public void setMinimum(int channel, double min) {
        if (channel >= 0 && channel < this.channelCount) {
            this.minimums[channel] = min;
        }
    }

    public double getMaximum(int channel) {
        if (channel < 0 || channel >= this.channelCount) {
            return 262144.0;
        }
        return this.maximums[channel];
    }

    public void setMaximum(int channel, double max) {
        if (channel >= 0 && channel < this.channelCount) {
            this.maximums[channel] = max;
        }
    }

    public boolean channelsAndScalesAreValid() {
        boolean areValid = false;
        if (this.channelCount > 0 && this.scaleFlags != null && this.scaleArguments != null && this.minimums != null && this.maximums != null && this.scaleFlags.length == this.channelCount && this.scaleArguments.length == this.channelCount && this.minimums.length == this.channelCount && this.maximums.length == this.channelCount) {
            areValid = true;
        }
        return areValid;
    }

    public int getID() {
        return this.id;
    }

    public int getCreatorExperimentID() {
        return this.creatorExperimentID;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }

    public void setCreatorExperimentID(int creatorID) {
        this.creatorExperimentID = creatorID;
    }

    public void setCreatorID(int creatorID) {
        this.creatorID = creatorID;
    }

    public void setID(int id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getKeystoneFilename() {
        return this.keystoneFilename;
    }

    public void setKeystoneFilename(String name) {
        this.keystoneFilename = name;
    }

    public String getFilename() {
        return this.getKeystoneFilename();
    }

    public void setFilename(String filename) {
        this.setKeystoneFilename(filename);
    }

    public int getPlotType() {
        if (this.isHistogramOverlay()) {
            return 101;
        }
        return this.plotType;
    }

    public boolean isPseudo3DPlot() {
        return this.plotType == 201 || this.plotType == 202;
    }

    public boolean is1DPlot() {
        return this.plotType == 1 || this.plotType == 2 || this.plotType == 101 || this.isOneImageHeatmap();
    }

    public void setPlotType(int type) {
        Arrays.sort(VALID_PLOT_TYPES);
        this.plotType = Arrays.binarySearch(VALID_PLOT_TYPES, type) > -1 ? type : -1;
    }

    public int getPlotSize() {
        return this.plotSize;
    }

    public void setPlotSize(int size) {
        Arrays.sort(VALID_PLOT_SIZES);
        this.plotSize = Arrays.binarySearch(VALID_PLOT_SIZES, size) > -1 ? size : 128;
    }

    public int getStatisticType() {
        return this.statType;
    }

    public void setStatisticType(int type) {
        Arrays.sort(VALID_STATISTICS);
        this.statType = Arrays.binarySearch(VALID_STATISTICS, type) > -1 ? type : -1;
    }

    public int getXChannel() {
        return this.xChannel;
    }

    public void setXChannel(int channel) {
        if (channel >= -1 && channel < this.channelCount) {
            this.xChannel = channel;
        }
    }

    public int getYChannel() {
        return this.yChannel;
    }

    public int getZChannel() {
        return this.zChannel;
    }

    public void setYChannel(int channel) {
        if (channel >= -1 && channel < this.channelCount) {
            this.yChannel = channel;
        }
    }

    public void setZChannel(int channel) {
        if (channel >= -1 && channel < this.channelCount) {
            this.zChannel = channel;
        }
    }

    public void setVariableChannelToDefault() {
        this.variableChannel = this.is1DPlot() ? 0 : (this.isPseudo3DPlot() ? 2 : 1);
        this.checkVariableChannelBoundaries();
    }

    public void checkVariableChannelBoundaries() {
        if (this.is1DPlot()) {
            if (this.variableChannel != 0) {
                this.variableChannel = 0;
            }
        } else if (this.isPseudo3DPlot()) {
            if (this.variableChannel > 2) {
                this.variableChannel = 2;
            }
        } else if (this.variableChannel > 1) {
            this.variableChannel = 1;
        }
        if (this.variableChannel < 0) {
            this.variableChannel = 0;
        }
    }

    public void setVariableChannel(int value) {
        if (value > 0) {
            this.variableChannel = value;
        } else {
            this.setVariableChannelToDefault();
        }
        this.checkVariableChannelBoundaries();
    }

    public int getVariableChannel() {
        this.checkVariableChannelBoundaries();
        return this.variableChannel;
    }

    public int getCompensationID() {
        return this.compensationID;
    }

    public void setCompensationID(int value) {
        this.compensationID = value;
    }

    public int getCitationFormat() {
        return this.citationFormat;
    }

    public int getCreatorID() {
        return this.creatorID;
    }

    public int getViewStatus() {
        return this.viewStatus;
    }

    public void setViewStatus(int viewStatus) {
        Arrays.sort(VALID_VIEW_STATUS);
        this.viewStatus = Arrays.binarySearch(VALID_VIEW_STATUS, viewStatus) > -1 ? viewStatus : 2;
    }

    public void setEditStatus(int editStatus) {
        Arrays.sort(VALID_EDIT_STATUS);
        this.editStatus = Arrays.binarySearch(VALID_EDIT_STATUS, editStatus) > -1 ? editStatus : 1;
    }

    public int getEditStatus() {
        return this.editStatus;
    }

    public int getMenuStyle() {
        return this.menuStyle;
    }

    public boolean useBlackBackground() {
        return this.blackBackgroundP;
    }

    public void setBlackBackground(boolean blackBackgroundP) {
        this.blackBackgroundP = blackBackgroundP;
    }

    public boolean useBlackPlotBackground() {
        return this.blackPlotBackgroundP;
    }

    public void setBlackPlotBackground(boolean blackPlotBackgroundP) {
        this.blackPlotBackgroundP = blackPlotBackgroundP;
    }

    public void setUsePlaceholders(boolean value) {
        this.usePlaceholdersP = value;
    }

    public boolean usePlaceholders() {
        return this.usePlaceholdersP;
    }

    public String getPlaceholderImagepath() {
        return placeholder_small_imagepath;
    }

    public int getStatType() {
        return this.statType;
    }

    public int getColorSet() {
        return this.colorSet;
    }

    public void setColorSet(int colorSet) {
        Arrays.sort(VALID_COLOR_SETS);
        this.colorSet = Arrays.binarySearch(VALID_COLOR_SETS, colorSet) > -1 ? colorSet : 1;
    }

    public void checkGradientColorSet() {
        Arrays.sort(VALID_GRADIENT_COLOR_SETS);
        if (Arrays.binarySearch(VALID_GRADIENT_COLOR_SETS, this.colorSet) <= -1) {
            this.colorSet = 1;
        }
    }

    public boolean isUncolored() {
        boolean isUncolored = false;
        if (this.plotType == 1 || this.plotType == 2 || this.plotType == 11 || this.plotType == 14) {
            isUncolored = true;
        }
        return isUncolored;
    }

    public boolean drawAnnotation() {
        return this.annotationP;
    }

    public void setAnnotation(boolean annotationP) {
        this.annotationP = annotationP;
    }

    public boolean drawScaleTick() {
        return this.showScaleTicksP;
    }

    public void setScaleTick(boolean showScaleTicksP) {
        this.showScaleTicksP = showScaleTicksP;
    }

    public boolean drawScaleLabel() {
        return this.showScaleLabelsP;
    }

    public void setScaleLabel(boolean value) {
        this.showScaleLabelsP = value;
    }

    public boolean drawAxisLabel() {
        return this.showAxisLabelsP;
    }

    public void setAxisLabel(boolean showAxisLabelsP) {
        this.showAxisLabelsP = showAxisLabelsP;
    }

    public boolean useLongLabel() {
        return this.longLabelsP;
    }

    public void setLongLabel(boolean longLabelsP) {
        this.longLabelsP = longLabelsP;
    }

    public int getAxisBins() {
        return this.plotSize;
    }

    public void setAxisBins(int bins) {
        if (bins >= 0) {
            this.plotSize = bins;
        }
    }

    public double getSmoothing() {
        return this.smoothing;
    }

    public void setSmoothing(double smoothing) {
        this.smoothing = smoothing;
    }

    public double getAspectRatio() {
        return this.aspectRatio;
    }

    public void setAspectRatio(double aspectRatio) {
        this.aspectRatio = aspectRatio;
    }

    public double getContourPercent() {
        return this.contourPercent;
    }

    public void setContourPercent(double contourPercent) {
        this.contourPercent = contourPercent;
    }

    public double getContourStartPercent() {
        return this.contourStartPercent;
    }

    public void setContourStartPercent(double contourStartPercent) {
        this.contourStartPercent = contourStartPercent;
    }

    public boolean usePrintView() {
        return this.usePrintViewP;
    }

    public void setUsePrintView(boolean value) {
        this.usePrintViewP = value;
    }

    public boolean isPanelDefaultRepresentation() {
        return this.panelDefaultP;
    }

    public void setPanelDefaultRepresentation(boolean panelDefaultP) {
        this.panelDefaultP = panelDefaultP;
    }

    public boolean showDetails() {
        return this.showDetailsP;
    }

    public boolean showTitle() {
        return this.showTitleP;
    }

    public int getPopulationType() {
        return this.populationType;
    }

    public void setPopulationType(int type) {
        this.populationType = type;
    }

    public int getPopulationCutoff() {
        return this.populationCutoff;
    }

    public void setPopulationCutoff(int cutoff) {
        this.populationCutoff = cutoff;
    }

    public int getEventCount() {
        return this.eventCount;
    }

    public int getDotSize() {
        return this.dotSize;
    }

    public void setDotSize(int dotSize) {
        this.dotSize = dotSize;
    }

    public void setEventCount(int eventCount) {
        this.eventCount = eventCount;
    }

    public int getLayoutOverride() {
        return this.layoutOverride;
    }

    public void setLayoutOverride(int type) {
        Arrays.sort(VALID_LAYOUT_OVERRIDE_TYPES);
        this.layoutOverride = Arrays.binarySearch(VALID_LAYOUT_OVERRIDE_TYPES, type) > -1 ? type : -1;
        if (this.layoutOverride == 4 || this.layoutOverride == 3) {
            this.plotType = 101;
        }
    }

    public int getType() {
        return this.getLayoutOverride();
    }

    public void setType(int type) {
        this.setLayoutOverride(type);
    }

    public boolean isOneImageHeatmap() {
        return this.layoutOverride == 5 || this.layoutOverride == 6;
    }

    public boolean isHeatmapWithViewthrough() {
        return this.layoutOverride == 1 || this.layoutOverride == 2;
    }

    public boolean isHeatmap() {
        return this.isHeatmapWithViewthrough() || this.isOneImageHeatmap();
    }

    public boolean getUsesStats() {
        return this.layoutOverride == 6 || this.layoutOverride == 2 || this.layoutOverride == 4;
    }

    public boolean isHistogramOverlay() {
        return this.layoutOverride == 3 || this.layoutOverride == 4;
    }

    public int getStatistic() {
        return this.statistic;
    }

    public void setStatistic(int statistic) {
        Arrays.sort(VALID_STATISTICS);
        this.statistic = Arrays.binarySearch(VALID_STATISTICS, statistic) > -1 ? statistic : 13;
    }

    public int getEquation() {
        return this.equation;
    }

    public void setEquation(int equation) {
        Arrays.sort(PopulationGrid.VALID_EQUATIONS);
        this.equation = Arrays.binarySearch(PopulationGrid.VALID_EQUATIONS, equation) > -1 ? equation : 6;
    }

    public int getControl() {
        return this.control;
    }

    public void setControl(int control) {
        Arrays.sort(PopulationGrid.VALID_CONTROLS);
        this.control = Arrays.binarySearch(PopulationGrid.VALID_CONTROLS, control) > -1 ? control : 11;
    }

    public int getControlRow() {
        return this.controlRow;
    }

    public void setControlRow(int row) {
        this.controlRow = row;
    }

    public int getControlColumn() {
        return this.controlColumn;
    }

    public void setControlColumn(int column) {
        this.controlColumn = column;
    }

    public String getFormula() {
        return this.formula;
    }

    public void setFormula(String formula) {
        this.formula = formula;
    }

    public double getRange() {
        return this.range;
    }

    public void setRange(double range) {
        this.range = Math.abs(range);
    }

    public int getRowID() {
        if (this.row == null) {
            return -1;
        }
        return this.row.getID();
    }

    public IllustrationDimension getRow() {
        if (this.dimensions.size() > 1) {
            Collections.sort(this.dimensions);
            return this.dimensions.get(1);
        }
        return null;
    }

    public void setRow(IllustrationDimension row) {
        this.row = row;
    }

    public int getRowCount() {
        if (this.row == null) {
            return 0;
        }
        return this.row.getIndexCount();
    }

    public int getColumnID() {
        if (this.column == null) {
            return -1;
        }
        return this.column.getID();
    }

    public IllustrationDimension getColumn() {
        if (this.dimensions.size() > 0) {
            Collections.sort(this.dimensions);
            return this.dimensions.get(0);
        }
        return null;
    }

    public void setColumn(IllustrationDimension column) {
        this.column = column;
    }

    public int getColumnCount() {
        if (this.column == null) {
            return 0;
        }
        return this.column.getIndexCount();
    }

    public boolean add(IllustrationDimension dimension) {
        if (dimension == null) {
            return false;
        }
        return this.dimensions.add(dimension);
    }

    public void clear() {
        this.dimensions.clear();
    }

    public IllustrationDimension[] toArray() {
        if (this.dimensions.size() > 1) {
            Collections.sort(this.dimensions);
        }
        IllustrationDimension[] dimensionsArray = new IllustrationDimension[this.dimensions.size()];
        this.dimensions.toArray(dimensionsArray);
        return dimensionsArray;
    }

    public HashMap<Integer, IllustrationDimension> getIllustrationDimensionMap() {
        HashMap<Integer, IllustrationDimension> dimMap = new HashMap<Integer, IllustrationDimension>();
        IllustrationDimension[] dims = this.toArray();
        for (int i = 0; i < dims.length; ++i) {
            dimMap.put(dims[i].getID(), dims[i]);
        }
        return dimMap;
    }

    public int getTableCount() {
        return this.getCountHelper(true);
    }

    public int getPageCount() {
        return this.getCountHelper(false);
    }

    private int getCountHelper(boolean tableP) {
        IllustrationDimension[] dims = this.toArray();
        int count = 1;
        for (int i = 0; i < dims.length; ++i) {
            if ((!tableP || !dims[i].isTable()) && (tableP || dims[i].isTable())) continue;
            count *= dims[i].getIndexCount();
        }
        return count;
    }

    public boolean hasActiveDimensions() {
        IllustrationDimension[] dims = this.toArray();
        return dims != null && dims.length > 0;
    }

    public Region addRegion(int id) {
        if (id < -3) {
            return null;
        }
        Region region = this.getRegion(id);
        if (region == null) {
            region = new Region(id);
            this.regions.add(region);
            if (this.regions.size() > 1) {
                Collections.sort(this.regions);
            }
        }
        return region;
    }

    public boolean removeRegion(int id) {
        if (id < -3) {
            return false;
        }
        int n = this.regions.size();
        for (int i = 0; i < n; ++i) {
            Region region;
            Object object = this.regions.get(i);
            if (!(object instanceof Region) || (region = (Region)object).getID() != id) continue;
            return this.regions.remove(region);
        }
        return false;
    }

    public Region getRegion(int id) {
        if (id < -3) {
            return null;
        }
        int n = this.regions.size();
        for (int i = 0; i < n; ++i) {
            Region region;
            Object object = this.regions.get(i);
            if (!(object instanceof Region) || (region = (Region)object).getID() != id) continue;
            return region;
        }
        return null;
    }

    public Region[] getRegions() {
        Region[] regionArray = new Region[this.regions.size()];
        this.regions.toArray(regionArray);
        return regionArray;
    }

    public void clearRegions() {
        this.regions.clear();
    }

    public Representation getRepresentation(int id, String name, int channelCount, String filename, int compensationID, int[] gateSetIDs, int xChannel, int yChannel, int plotType, int statType, int colorSet, boolean blackBackgroundP, boolean annotationP, boolean scaleLabelP, boolean scaleTickP, boolean axisLabelP, boolean longLabelP, int axisBins, double smoothing, double aspectRatio, double contourPercent, double contourStartPercent) {
        Representation rep = new Representation(id, name, channelCount);
        rep.setFilename(filename);
        rep.setCompensationID(compensationID);
        if (gateSetIDs != null) {
            for (int i = 0; i < gateSetIDs.length; ++i) {
                rep.addGateSetID(gateSetIDs[i]);
            }
        }
        rep.setXChannel(xChannel);
        rep.setYChannel(yChannel);
        rep.setPlotType(this.getPlotType());
        rep.setStatisticType(statType);
        rep.setColorSet(colorSet);
        rep.setBlackBackground(blackBackgroundP);
        rep.setAnnotation(annotationP);
        rep.setScaleLabel(scaleLabelP);
        rep.setScaleTick(scaleTickP);
        rep.setAxisLabel(axisLabelP);
        rep.setLongLabel(longLabelP);
        rep.setAxisBins(axisBins);
        rep.setSmoothing(smoothing);
        rep.setAspectRatio(aspectRatio);
        rep.setContourPercent(contourPercent);
        rep.setContourStartPercent(contourStartPercent);
        return rep;
    }

    public Representation getRepresentation(int id, String name, int channelCount, String filename, int compensationID, int[] gateSetIDs, int xChannel, int yChannel, int plotType, int statType, int colorSet, boolean blackBackgroundP, boolean annotationP, boolean scaleLabelP, boolean scaleTickP, boolean axisLabelP, boolean longLabelP, int axisBins, double smoothing, double aspectRatio, double contourPercent, double contourStartPercent, int populationType, int eventCount, int dotSize) {
        Representation rep = Representation.getRepresentation(id, name, channelCount, filename, compensationID, gateSetIDs, xChannel, yChannel, this.getPlotType(), statType, colorSet, blackBackgroundP, annotationP, scaleLabelP, scaleTickP, axisLabelP, longLabelP, axisBins, smoothing, aspectRatio, contourPercent, contourStartPercent);
        rep.setPopulationType(populationType);
        rep.setEventCount(eventCount);
        return rep;
    }

    public String getPlaceholderQueryString() {
        StringBuffer parameters = new StringBuffer();
        parameters.append("mode=usePlaceholders");
        return parameters.toString();
    }

    public static final class Region
    implements Comparable,
    Serializable {
        public static final boolean DEFAULT_SHOW = true;
        public static final boolean DEFAULT_SHAPE = true;
        public static final boolean DEFAULT_LABEL = false;
        public static final boolean DEFAULT_EVENT_COUNT = false;
        public static final boolean DEFAULT_PERCENT = true;
        public static final String ID_PARAM_NAME = "id";
        public static final String SHOW_PARAM_NAME = "shown";
        public static final String SHAPE_PARAM_NAME = "shape";
        public static final String LABEL_PARAM_NAME = "label";
        public static final String EVENT_COUNT_PARAM_NAME = "eventcount";
        public static final String PERCENT_PARAM_NAME = "percent";
        public static final int DEFAULT_ID = -3;
        private final int id;
        private boolean showP;
        private boolean shapeP;
        private boolean labelP;
        private boolean eventCountP;
        private boolean percentP;

        public Region(int id) {
            this.id = id;
            this.showP = true;
            this.shapeP = true;
            this.labelP = false;
            this.eventCountP = false;
            this.percentP = true;
        }

        public Region(int id, boolean showP, boolean shapeP, boolean labelP, boolean eventCountP, boolean percentP) {
            this.id = id;
            this.showP = showP;
            this.shapeP = shapeP;
            this.labelP = labelP;
            this.eventCountP = eventCountP;
            this.percentP = percentP;
        }

        public int getID() {
            return this.id;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj instanceof Region) {
                Region region = (Region)obj;
                return this.id == region.id;
            }
            return false;
        }

        public int hashCode() {
            return this.getID();
        }

        public boolean isShown() {
            return this.showP;
        }

        public void setShown(boolean showP) {
            this.showP = showP;
        }

        public boolean isShapeShown() {
            return this.shapeP;
        }

        public void setShapeShown(boolean shapeP) {
            this.shapeP = shapeP;
        }

        public boolean isLabelShown() {
            return this.labelP;
        }

        public void setLabelShown(boolean labelP) {
            this.labelP = labelP;
        }

        public boolean isEventCountShown() {
            return this.eventCountP;
        }

        public void setEventCountShown(boolean eventCountP) {
            this.eventCountP = eventCountP;
        }

        public boolean isPercentShown() {
            return this.percentP;
        }

        public void setPercentShown(boolean percentP) {
            this.percentP = percentP;
        }

        public String getPlotSettingsQueryString() {
            StringBuffer parameters = new StringBuffer();
            if (this.showP) {
                if (this.shapeP) {
                    parameters.append("&region");
                    parameters.append(this.id);
                    parameters.append("=region");
                }
                if (this.labelP) {
                    parameters.append("&region");
                    parameters.append(this.id);
                    parameters.append("=label");
                }
                if (this.eventCountP) {
                    parameters.append("&region");
                    parameters.append(this.id);
                    parameters.append("=eventCount");
                }
                if (this.percentP) {
                    parameters.append("&region");
                    parameters.append(this.id);
                    parameters.append("=percent");
                }
            } else {
                parameters.append("&region");
                parameters.append(this.id);
                parameters.append("=none");
            }
            return parameters.toString();
        }

        public int compareTo(Object obj) {
            if (obj == null) {
                throw new NullPointerException("The object is null.");
            }
            if (obj instanceof Region) {
                Region region = (Region)obj;
                if (this.id < region.id) {
                    return -1;
                }
                if (this.id == region.id) {
                    return 0;
                }
                return 1;
            }
            throw new ClassCastException("The object is not a region.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class IllustrationDimension
    implements Comparable<IllustrationDimension> {
        public static final String ID_PARAM_NAME = "ID";
        public static final String TARGET_FIG_DIM_ID_PARAM_NAME = "TargetFigDimID";
        public static final String ORDER_PARAM_NAME = "Order";
        public static final String ORIENTATION_PARAM_NAME = "Orientation";
        public static final String INDICES_PARAM_NAME = "Indices";
        public static final String INDEX_PARAM_NAME = "Index";
        public static final int STACKED = 0;
        public static final int SIDE_BY_SIDE = 1;
        public static final int PAGES = 2;
        public static final int OVERLAY = 3;
        public static final int DEFAULT_ID = -1;
        public static final int DEFAULT_TARGET_FIGURE_DIMENSION_ID = -1;
        public static final int DEFAULT_ORIENTATION = 0;
        public static final int DEFAULT_ORDER = 1;
        private int id;
        private int targetFigureDimensionID;
        private int order;
        private int orientation;
        private int[] indices;

        public IllustrationDimension(int id) {
            this.id = id;
            this.order = Illustration.this.getNextOrderValue();
            this.targetFigureDimensionID = -1;
            this.orientation = 0;
            this.setIndices(this.indices);
        }

        public IllustrationDimension(int id, int targetFigureDimensionID, int orientation, int[] indices) {
            this(id, targetFigureDimensionID, 1, orientation, indices);
        }

        public IllustrationDimension(int id, int targetFigureDimensionID, int order, int orientation, int[] indices) {
            this.id = id;
            this.targetFigureDimensionID = targetFigureDimensionID;
            this.order = order;
            this.orientation = orientation;
            this.setIndices(indices);
        }

        private void setToDefaultValues() {
        }

        public int getID() {
            return this.id;
        }

        public int getTargetFigureDimensionID() {
            return this.targetFigureDimensionID;
        }

        public int getOrder() {
            return this.order;
        }

        public boolean isColumn() {
            boolean isColumn = false;
            if (this.getOrder() == 0) {
                isColumn = true;
            }
            return isColumn;
        }

        public boolean isRow() {
            boolean isRow = false;
            if (this.getOrder() == 1) {
                isRow = true;
            }
            return isRow;
        }

        public boolean isTable() {
            boolean isTable = false;
            if (this.getOrientation() == 0 || this.getOrientation() == 1 || this.getOrientation() == 3) {
                isTable = true;
            }
            return isTable;
        }

        public int getOrientation() {
            return this.orientation;
        }

        public boolean isActive(int indexToCheck) {
            boolean isActiveP = false;
            for (int j = 0; j < this.indices.length; ++j) {
                if (indexToCheck != this.indices[j]) continue;
                isActiveP = true;
            }
            return isActiveP;
        }

        public int getIndexCount() {
            if (this.indices == null) {
                return 0;
            }
            return this.indices.length;
        }

        public int[] getIndices() {
            return this.indices;
        }

        private void setIndices(int[] indices) {
            if (indices == null) {
                this.indices = new int[0];
            } else {
                this.indices = new int[indices.length];
                System.arraycopy(indices, 0, this.indices, 0, indices.length);
                Arrays.sort(this.indices);
            }
        }

        @Override
        public int compareTo(IllustrationDimension dimension) {
            if (dimension == null) {
                return -1;
            }
            Integer thisOrder = this.getOrder();
            Integer otherOrder = dimension.getOrder();
            return thisOrder.compareTo(otherOrder);
        }
    }
}

