/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.debugger.commands;

import java.io.CharArrayWriter;
import java.io.PrintWriter;
import org.semanticweb.HermiT.debugger.Debugger;
import org.semanticweb.HermiT.debugger.commands.AbstractCommand;
import org.semanticweb.HermiT.tableau.Node;

public class ModelStatsCommand
extends AbstractCommand {
    public ModelStatsCommand(Debugger debugger) {
        super(debugger);
    }

    public String getCommandName() {
        return "modelStats";
    }

    public String[] getDescription() {
        return new String[]{"", "prints statistics about a model"};
    }

    public void printHelp(PrintWriter printWriter) {
        printWriter.println("usage: modelStats");
        printWriter.println("    Prints statistics about the current model.");
    }

    public void execute(String[] stringArray) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (Node node = this.m_debugger.getTableau().getFirstTableauNode(); node != null; node = node.getNextTableauNode()) {
            ++n;
            if (node.isDirectlyBlocked()) {
                ++n3;
                continue;
            }
            if (node.isIndirectlyBlocked()) {
                ++n4;
                continue;
            }
            ++n2;
        }
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        PrintWriter printWriter = new PrintWriter(charArrayWriter);
        printWriter.println("  Model statistics");
        printWriter.println("================================================");
        printWriter.println("  Number of nodes:                    " + n);
        printWriter.println("  Number of unblocked nodes:          " + n2);
        printWriter.println("  Number of directly blocked nodes:   " + n3);
        printWriter.println("  Number of indirectly blocked nodes: " + n4);
        printWriter.println("================================================");
        printWriter.flush();
        this.showTextInWindow(charArrayWriter.toString(), "Model statistics");
        this.selectConsoleWindow();
    }
}

