### R code from vignette source 'msmsData-Vignette.Rnw'

###################################################
### code chunk number 1: msmsData-Vignette.Rnw:84-85
###################################################
options(continue=" ")


###################################################
### code chunk number 2: Chunk0
###################################################
  library(msmsEDA)
  data(msms.dataset)
  msms.dataset
  dim(msms.dataset)
  head(pData(msms.dataset))
  table(pData(msms.dataset)$treat)
  table(pData(msms.dataset)$batch)
  table(pData(msms.dataset)$treat, pData(msms.dataset)$batch)


###################################################
### code chunk number 3: Chunk1
###################################################
e <- pp.msms.data(msms.dataset)
processingData(e)
dim(e)  
setdiff(featureNames(msms.dataset), featureNames(e))


###################################################
### code chunk number 4: Chunk2
###################################################
tfvnm <- count.stats(e)  
{ cat("\nSample statistics after removing NAs and -R:\n\n")
  cat("SpC matrix dimension:",dim(e),"\n\n")
  print(tfvnm)
}


###################################################
### code chunk number 5: Chunk3 (eval = FALSE)
###################################################
## boxplot(exprs(e),las=2,col="lavender")


###################################################
### code chunk number 6: msmsData-Vignette.Rnw:141-143
###################################################
par(mar=c(5,4,0.5,2)+0.1)
boxplot(exprs(e),las=2,col="lavender")


###################################################
### code chunk number 7: Chunk4
###################################################
nfact <- median(tfvnm[,2])/tfvnm[,2]


###################################################
### code chunk number 8: msmsData-Vignette.Rnw:154-157 (eval = FALSE)
###################################################
## nfact <- median(tfvnm[,2])/tfvnm[,2]
## barplot(nfact,las=2,col="lavender")
## abline(h=1,lty=4)


###################################################
### code chunk number 9: msmsData-Vignette.Rnw:162-166
###################################################
par(mar=c(4,4,0.5,2)+0.1)
par(cex.axis=0.6,cex.lab=0.6)
barplot(nfact,las=2,col="lavender")
abline(h=1,lty=4)


###################################################
### code chunk number 10: msmsData-Vignette.Rnw:180-187
###################################################
facs <- pData(e)
snms <- substr(as.character(facs$treat),1,2)
snms <- paste(snms,as.integer(facs$batch),sep=".")
par(mar=c(4,4,0.5,2)+0.1)
par(mfrow=c(2,1))
counts.pca(e, facs = pData(e)[, "treat", drop = FALSE],snms=snms)
counts.pca(e, facs = pData(e)[, "batch", drop = FALSE],snms=snms)


###################################################
### code chunk number 11: ChunkPCA
###################################################
facs <- pData(e)
snms <- substr(as.character(facs$treat),1,2)
snms <- paste(snms,as.integer(facs$batch),sep=".")
pcares <- counts.pca(e)
smpl.pca <- pcares$pca
{ cat("Principal components analisis on the raw SpC matrix\n")
  cat("Variance of the first four principal components:\n\n")
  print(summary(smpl.pca)$importance[,1:4])
}


###################################################
### code chunk number 12: msmsData-Vignette.Rnw:221-222
###################################################
counts.hc(e,facs=pData(e)[, "treat", drop = FALSE])


###################################################
### code chunk number 13: msmsData-Vignette.Rnw:231-232
###################################################
counts.hc(e,facs=pData(e)[, "batch", drop = FALSE])


###################################################
### code chunk number 14: msmsData-Vignette.Rnw:252-253
###################################################
counts.heatmap(e,etit="UPS1",fac=pData(e)[, "treat"])


###################################################
### code chunk number 15: ChunkMC
###################################################
counts <- exprs(e)
batch <- msms.dataset$batch
batch.means <- t(apply(counts,1,function(x)
       tapply(x,batch,function(v) mean(v))))
msms.mc <- matrix(0, nrow=nrow(counts), ncol=ncol(counts))
msms.mc[,batch=="0302"] <- sweep(counts[,batch=="0302"],1,
                                 batch.means[,"0302"])
msms.mc[,batch=="2502"] <- sweep(counts[,batch=="2502"],1,
                                 batch.means[,"2502"])
e.mc <- e
exprs(e.mc) <- msms.mc
smpl.pca <- counts.pca(e.mc,snms=snms)$pca
{ cat("Principal components analisis on the batch mean centered SpC matrix\n")
  cat("Variance of the first four principal components:\n\n")
  print(summary(smpl.pca)$importance[,1:4])
}


###################################################
### code chunk number 16: msmsData-Vignette.Rnw:301-303
###################################################
par(mar=c(4,4,0.5,2)+0.1)
counts.pca(e.mc, facs = pData(e)[, "treat", drop = FALSE],snms=snms)


###################################################
### code chunk number 17: ChunkPCA
###################################################
dsp <- disp.estimates(e)
signif(dsp,4)


###################################################
### code chunk number 18: msmsData-Vignette.Rnw:351-354
###################################################
par(mar=c(5,4,0.5,2)+0.1,cex.lab=0.8,cex.axis=0.8,cex.main=1.2)
par(mfrow=c(2,1))
disp.estimates(e,facs=pData(e)[, "batch", drop = FALSE])


