### R code from vignette source 'intansvOverview.Rnw'

###################################################
### code chunk number 1: options
###################################################
options(width=72)


###################################################
### code chunk number 2: biocLite (eval = FALSE)
###################################################
## source("http://bioconductor.org/biocLite.R")
## biocLite("intansv")


###################################################
### code chunk number 3: initialize
###################################################
library(intansv)


###################################################
### code chunk number 4: read in results of BreakDancer
###################################################
breakdancer <- readBreakDancer(system.file("extdata/ZS97.breakdancer.sv",
                               package="intansv"))
str(breakdancer)


###################################################
### code chunk number 5: read in results of cnvnator
###################################################
cnvnator <- readCnvnator(system.file("extdata/cnvnator",package="intansv"))
str(cnvnator)


###################################################
### code chunk number 6: read in results of SVseq2
###################################################
svseq <- readSvseq(system.file("extdata/svseq2",package="intansv"))
str(svseq)


###################################################
### code chunk number 7: read in results of DELLY
###################################################
delly <- readDelly(system.file("extdata/delly",package="intansv"))
str(delly)


###################################################
### code chunk number 8: read in results of Pindel
###################################################
pindel <- readPindel(system.file("extdata/pindel",package="intansv"))
str(pindel)


###################################################
### code chunk number 9: read in results of Lumpy
###################################################
lumpy <- readLumpy(system.file("extdata/ZS97.lumpy.pesr.bedpe",
                   package="intansv"))
str(lumpy)


###################################################
### code chunk number 10: read in results of softSearch
###################################################
 softSearch <- readSoftSearch(system.file("extdata/ZS97.softsearch",package="intansv"))
str(softSearch)


###################################################
### code chunk number 11: MethodsMerge
###################################################
sv_all_methods <- methodsMerge(breakdancer,pindel,cnvnator,delly,svseq)
str(sv_all_methods)


###################################################
### code chunk number 12: MethodsMerge
###################################################
sv_all_methods.nopindel <- methodsMerge(breakdancer,cnvnator,delly,svseq)
str(sv_all_methods.nopindel)


###################################################
### code chunk number 13: sv annotation
###################################################
load(system.file("extdata/genome.anno.RData",package="intansv"))
sv_all_methods.anno <- llply(sv_all_methods,svAnnotation,
                             genomeAnnotation=msu_gff_v7)
names(sv_all_methods.anno)
head(sv_all_methods.anno$del)


###################################################
### code chunk number 14: genomic_distribution
###################################################
genome
plotChromosome(genome,sv_all_methods,1000000)


###################################################
### code chunk number 15: region_visualization
###################################################
head(msu_gff_v7,n=3)
plotRegion(sv_all_methods,msu_gff_v7,"chr05",1,200000)


###################################################
### code chunk number 16: intansvOverview.Rnw:291-292
###################################################
sessionInfo()


