### R code from vignette source 'graphite.Rnw'

###################################################
### code chunk number 1: startup
###################################################
library(graph)
library(graphite)


###################################################
### code chunk number 2: base1
###################################################
names(biocarta)[1:10]
p <- biocarta[["acetylation and deacetylation of rela in nucleus"]]
p


###################################################
### code chunk number 3: base2
###################################################
p <- biocarta[[1]]
p@title


###################################################
### code chunk number 4: base3
###################################################
nodes(p)


###################################################
### code chunk number 5: base4
###################################################
edges(p)


###################################################
### code chunk number 6: graph1
###################################################
g <- pathwayGraph(p)
g


###################################################
### code chunk number 7: graph2
###################################################
edgeData(g)[1]


###################################################
### code chunk number 8: ident1
###################################################
pEntrez <- convertIdentifiers(p, "entrez")
pEntrez
nodes(pEntrez)


###################################################
### code chunk number 9: ident2
###################################################
pSymbol <- convertIdentifiers(p, "symbol")
nodes(pSymbol)


###################################################
### code chunk number 10: spia1
###################################################
library(SPIA)
data(colorectalcancer)

library(hgu133plus2.db)
x <- hgu133plus2ENTREZID
top$ENTREZ <- unlist(as.list(x[top$ID]))
top <- top[!is.na(top$ENTREZ), ]
top <- top[!duplicated(top$ENTREZ), ]
tg1 <- top[top$adj.P.Val < 0.05, ]

DE_Colorectal = tg1$logFC
names(DE_Colorectal) <- as.vector(tg1$ENTREZ)
ALL_Colorectal <- top$ENTREZ

prepareSPIA(biocarta[1:2], "biocartaEx")
runSPIA(de=DE_Colorectal, all=ALL_Colorectal, "biocartaEx")


###################################################
### code chunk number 11: dg1
###################################################
library(DEGraph)
data("Loi2008_DEGraphVignette")

p <- convertIdentifiers(biocarta[["actions of nitric oxide in the heart"]], "entrez")
res <- runDEGraph(p, exprLoi2008, classLoi2008)
res$`1`


###################################################
### code chunk number 12: tg1
###################################################
library(topologyGSA)
data(examples)

p <- convertIdentifiers(kegg[["Fc epsilon RI signaling pathway"]], "symbol")
runTopologyGSA(p, "var", y1, y2, 0.05)


###################################################
### code chunk number 13: tg1
###################################################
library(clipper)
library(ALL)
path <- convertIdentifiers(kegg$'Chronic myeloid leukemia', "entrez")
genes <- nodes(path)
data(ALL)
all <- as.matrix(exprs(ALL[1:length(genes),1:20]))
classes <- c(rep(1,10), rep(2,10))
rownames(all) <- genes
clipped <- runClipper(path, all, classes, "mean", pathThr=0.1)
clipped[,1:5]


###################################################
### code chunk number 14: tg2
###################################################
library(clipper)
library(ALL)
paths <- lapply(kegg[1:5], function(x) convertIdentifiers(x, "entrez"))
genes <- unlist(lapply(paths, nodes))
data(ALL)
all <- as.matrix(exprs(ALL[1:length(genes),1:20]))
classes <- c(rep(1,10), rep(2,10))
rownames(all) <- genes
clipped <- runClipperMulti(paths, all, classes, "mean", pathThr=0.1)
resClip <- do.call(rbind,clipped$results)
resClip[,1:5]


