### R code from vignette source 'fmcsR.Rnw'

###################################################
### code chunk number 1: style
###################################################
BiocStyle::latex()


###################################################
### code chunk number 2: fmcsR.Rnw:45-47
###################################################
options(width=95)
unlink("test.db")


###################################################
### code chunk number 3: fmcsR.Rnw:63-65 (eval = FALSE)
###################################################
## source("http://bioconductor.org/biocLite.R")
## biocLite("fmcsR")


###################################################
### code chunk number 4: quicktest1
###################################################
library(fmcsR)
data(fmcstest)
plot(fmcstest[1:3], print=FALSE)


###################################################
### code chunk number 5: quicktest2
###################################################
test <- fmcs(fmcstest[1], fmcstest[2], au=2, bu=1)
plotMCS(test)


###################################################
### code chunk number 6: fmcsR.Rnw:97-98
###################################################
library("fmcsR") # Loads the package


###################################################
### code chunk number 7: fmcsR.Rnw:100-104 (eval = FALSE)
###################################################
## library(help="fmcsR") # Lists functions/classes provided by fmcsR 
## library(help="ChemmineR") # Lists functions/classes from ChemmineR
## vignette("fmcsR") # Opens this PDF manual
## vignette("ChemmineR") # Opens ChemmineR PDF manual


###################################################
### code chunk number 8: fmcsR.Rnw:108-111 (eval = FALSE)
###################################################
## ?fmcs
## ?"MCS-class"
## ?"SDFset-class"


###################################################
### code chunk number 9: fmcsR.Rnw:118-121
###################################################
data(fmcstest)
sdfset <- fmcstest
sdfset


###################################################
### code chunk number 10: fmcsR.Rnw:125-127 (eval = FALSE)
###################################################
## write.SDF(sdfset, file="sdfset.sdf")
## mysdf <- read.SDFset(file="sdfset.sdf")


###################################################
### code chunk number 11: fmcsR.Rnw:132-136
###################################################
mcsa <- fmcs(sdfset[[1]], sdfset[[2]])
mcsa
mcsb <- fmcs(sdfset[[1]], sdfset[[3]])
mcsb


###################################################
### code chunk number 12: fmcsR.Rnw:140-141
###################################################
fmcs(sdfset[1], sdfset[2], fast=TRUE)


###################################################
### code chunk number 13: fmcsR.Rnw:146-147
###################################################
slotNames(mcsa)


###################################################
### code chunk number 14: fmcsR.Rnw:151-156
###################################################
stats(mcsa) # or mcsa[["stats"]]
mcsa1 <- mcs1(mcsa) # or mcsa[["mcs1"]]
mcsa2 <- mcs2(mcsa) # or mcsa[["mcs2"]]
mcsa1[1] # returns SDFset component
mcsa1[[2]][1:2] # return first two index vectors


###################################################
### code chunk number 15: fmcsR.Rnw:160-162
###################################################
mcstosdfset <- mcs2sdfset(mcsa, type="new")
plot(mcstosdfset[[1]], print=FALSE)


###################################################
### code chunk number 16: fmcsR.Rnw:166-168
###################################################
mylist <- list(stats=stats(mcsa), mcs1=mcs1(mcsa), mcs2=mcs2(mcsa)) 
as(mylist, "MCS")


###################################################
### code chunk number 17: au0bu0
###################################################
plotMCS(fmcs(sdfset[1], sdfset[2], au=0, bu=0))


###################################################
### code chunk number 18: au1bu1
###################################################
plotMCS(fmcs(sdfset[1], sdfset[2], au=1, bu=1))


###################################################
### code chunk number 19: au2bu2
###################################################
plotMCS(fmcs(sdfset[1], sdfset[2], au=2, bu=2))


###################################################
### code chunk number 20: au0bu013
###################################################
plotMCS(fmcs(sdfset[1], sdfset[3], au=0, bu=0))


###################################################
### code chunk number 21: fmcsR.Rnw:218-221
###################################################
data(sdfsample) # Loads larger sample data set
sdf <- sdfsample
fmcsBatch(sdf[1], sdf[1:30], au=0, bu=0)


###################################################
### code chunk number 22: tree
###################################################
sdf <- sdf[1:7]
d <- sapply(cid(sdf), function(x) 
            fmcsBatch(sdf[x], sdf, au=0, bu=0, 
            matching.mode="aromatic")[,"Overlap_Coefficient"])
d
hc <- hclust(as.dist(1-d), method="complete")
plot(as.dendrogram(hc), edgePar=list(col=4, lwd=2), horiz=TRUE) 


###################################################
### code chunk number 23: au0bu024
###################################################
plotMCS(fmcs(sdf[3], sdf[7], au=0, bu=0, matching.mode="aromatic"))


###################################################
### code chunk number 24: sessionInfo
###################################################
toLatex(sessionInfo())


