context("rules")

test_that(".cleavePos", {
  peptides <- c(
    gaju="LAAGKVEDSD",
    ins=paste("MALWMRLLPLLALLALWGPDPAAAFVNQHLCGSHLVEALYLVCGERGFFYTPKTRREAED",
              "LQVGQVELGGGPGAGSLQPLALEGSLQKRGIVEQCCTSICSLYQLENYCN", sep=""),
    albu=paste("MKWVTFISLLFLFSSAYSRGVFRRDAHKSEVAHRFKDLGEENFKALVLIAFAQYLQQCPF",
               "EDHVKLVNEVTEFAKTCVADESAENCDKSLHTLFGDKLCTVATLRETYGEMADCCAKQEP",
               "ERNECFLQHKDDNPNLPRLVRPEVDVMCTAFHDNEETFLKKYLYEIARRHPYFYAPELLF",
               "FAKRYKAAFTECCQAADKAACLLPKLDELRDEGKASSAKQRLKCASLQKFGERAFKAWAV",
               "ARLSQRFPKAEFAEVSKLVTDLTKVHTECCHGDLLECADDRADLAKYICENQDSISSKLK",
               "ECCEKPLLEKSHCIAEVENDEMPADLPSLAADFVESKDVCKNYAEAKDVFLGMFLYEYAR",
               "RHPDYSVVLLLRLAKTYETTLEKCCAAADPHECYAKVFDEFKPLVEEPQNLIKQNCELFE",
               "QLGEYKFQNALLVRYTKKVPQVSTPTLVEVSRNLGKVGSKCCKHPEAKRMPCAEDYLSVV",
               "LNQLCVLHEKTPVSDRVTKCCTESLVNRRPCFSALEVDETYVPKEFNAETFTFHADICTL",
               "SEKERQIKKQTALVELVKHKPKATKEQLKAVMDDFAAFVEKCCKADDKETCFAEEGKKLV",
               "AASQAALGL", sep=""))

  cleavageResults <- list(
    "arg-c proteinase"=list(
      gaju=integer(0),
      ins=c(6, 46, 55, 56, 89),
      albu=c(19, 23, 24, 34, 105, 122, 138, 141, 168, 169, 184, 210, 221,
             233, 242, 246, 281, 360, 361, 372, 434, 452, 469, 496, 508, 509,
             545)),
    "asp-n endopeptidase"=list(
      gaju=c(7, 9),
      ins=c(19, 59),
      albu=c(24, 36, 61, 79, 86, 95, 112, 130, 131, 144, 152, 196, 206,
             210, 260, 272, 278, 279, 282, 292, 319, 324, 331, 337, 347, 363,
             388, 398, 474, 494, 517, 535, 572, 573, 585, 586)),
    "bnps-skatole"=list(
      gaju=integer(0),
      ins=c(4, 17),
      albu=c(3, 238)),
    caspase1=list(
      gaju=integer(0),
      ins=integer(0),
      albu=c(261, 332, 536)),
    caspase2=list(
      gaju=integer(0),
      ins=integer(0),
      albu=integer(0)),
    caspase3=list(
      gaju=integer(0),
      ins=integer(0),
      albu=integer(0)),
    caspase4=list(
      gaju=integer(0),
      ins=integer(0),
      albu=integer(0)),
    caspase5=list(
      gaju=integer(0),
      ins=integer(0),
      albu=integer(0)),
    caspase6=list(
      gaju=integer(0),
      ins=integer(0),
      albu=integer(0)),
    caspase7=list(
      gaju=integer(0),
      ins=integer(0),
      albu=integer(0)),
    caspase8=list(
      gaju=integer(0),
      ins=integer(0),
      albu=integer(0)),
    caspase9=list(
      gaju=integer(0),
      ins=integer(0),
      albu=integer(0)),
    caspase10=list(
      gaju=integer(0),
      ins=integer(0),
      albu=integer(0)),
    "chymotrypsin-high"=list(
      gaju=integer(0),
      ins=c(17, 25, 40, 48, 49, 50, 103, 108),
      albu=c(3, 6, 11, 13, 17, 22, 35, 43, 51, 54, 60, 73, 94, 108, 126,
             151, 158, 162, 164, 172, 173, 174, 180, 181, 185, 189, 230, 235,
             238, 252, 287, 333, 343, 350, 354, 356, 358, 365, 377, 394, 398,
             401, 419, 425, 427, 435, 476, 512, 521, 526, 531, 533, 575, 578,
             592)),
    "chymotrypsin-low"=list(
      gaju=1,
      ins=c(1, 3, 5, 7, 10, 11, 13, 14, 16, 17, 25, 29, 30, 34, 35, 39,
            40, 41, 48, 49, 50, 61, 68, 77, 80, 82, 86, 102, 103, 105, 108),
      albu=c(1, 3, 6, 9, 10, 11, 12, 13, 17, 22, 27, 33, 35, 38, 43, 46,
             48, 51, 54, 55, 60, 63, 66, 73, 90, 91, 93, 94, 98, 104, 108,
             111, 126, 127, 129, 139, 147, 151, 158, 159, 162, 163, 164, 172,
             173, 174, 178, 179, 180, 181, 185, 189, 202, 206, 209, 222, 227,
             230, 235, 238, 243, 252, 258, 262, 266, 271, 274, 275, 284, 287,
             299, 307, 308, 312, 329, 333, 343, 350, 351, 353, 354, 355, 356,
             358, 365, 369, 370, 371, 373, 377, 381, 391, 394, 398, 401, 404,
             411, 418, 419, 422, 425, 427, 431, 432, 435, 447, 454, 476, 477,
             481, 484, 487, 488, 505, 512, 515, 521, 526, 531, 533, 534, 540,
             553, 556, 559, 568, 572, 575, 578, 592, 599, 607)),
    clostripain=list(
      gaju=integer(0),
      ins=c(6, 46, 55, 56, 89),
      albu=c(19, 23, 24, 34, 105, 122, 138, 141, 168, 169, 184, 210, 221,
             233, 242, 246, 281, 360, 361, 372, 434, 452, 469, 496, 508, 509,
             545)),
    cnbr=list(
      gaju=integer(0),
      ins=c(1, 5),
      albu=c(1, 111, 147, 322, 353, 470, 572)),
    enterokinase=list(
      gaju=integer(0),
      ins=integer(0),
      albu=integer(0)),
    "factor xa"=list(
      gaju=integer(0),
      ins=integer(0),
      albu=integer(0)),
    "formic acid"=list(
      gaju=8,
      ins=c(20, 60),
      albu=c(25, 37, 62, 80, 87, 96, 113, 131, 132, 145, 153, 197, 207,
             211, 261, 273, 279, 280, 283, 293, 320, 325, 332, 338, 348, 364,
             389, 399, 475, 495, 518, 536, 573, 574, 586, 587)),
    "glutamyl endopeptidase"=list(
      gaju=7,
      ins=c(37, 45, 57, 59, 67, 83, 93, 106),
      albu=c(30, 40, 41, 61, 69, 72, 81, 84, 106, 110, 119, 121, 124, 143,
             155, 156, 165, 177, 191, 208, 212, 232, 251, 254, 268, 276, 290,
             301, 304, 309, 316, 318, 321, 335, 345, 357, 378, 382, 392, 400,
             406, 407, 417, 420, 424, 449, 466, 474, 489, 503, 516, 519, 525,
             529, 542, 544, 555, 566, 580, 589, 594, 595)),
    "granzyme-b"=list(
      gaju=integer(0),
      ins=integer(0),
      albu=integer(0)),
    hydroxylamine=list(
      gaju=integer(0),
      ins=integer(0),
      albu=integer(0)),
    "iodosobenzoic acid"=list(
      gaju=integer(0),
      ins=c(4, 17),
      albu=c(3, 238)),
    lysc=list(
      gaju=5,
      ins=c(53, 88),
      albu=c(2, 28, 36, 44, 65, 75, 88, 97, 117, 130, 160, 161, 183, 186,
             198, 205, 214, 219, 223, 229, 236, 249, 257, 264, 286, 298, 300,
             305, 310, 337, 341, 347, 375, 383, 396, 402, 413, 426, 437, 438,
             456, 460, 463, 468, 490, 499, 524, 543, 548, 549, 558, 560, 562,
             565, 569, 581, 584, 588, 597, 598)),
    lysn=list(
      gaju=4,
      ins=c(52, 87),
      albu=c(1, 27, 35, 43, 64, 74, 87, 96, 116, 129, 159, 160, 182, 185,
             197, 204, 213, 218, 222, 228, 235, 248, 256, 263, 285, 297, 299,
             304, 309, 336, 340, 346, 374, 382, 395, 401, 412, 425, 436, 437,
             455, 459, 462, 467, 489, 498, 523, 542, 547, 548, 557, 559, 561,
             564, 568, 580, 583, 587, 596, 597)),
    "neutrophil elastase"=list(
      gaju=c(2, 3, 6),
      ins=c(2, 12, 15, 22, 23, 24, 26, 36, 38, 42, 58, 63, 66, 74, 81,
            92),
      albu=c(4, 16, 21, 26, 31, 32, 45, 47, 50, 52, 64, 67, 70, 74, 78,
             79, 83, 101, 102, 112, 116, 140, 144, 146, 150, 167, 175, 182,
             187, 188, 195, 196, 199, 200, 215, 218, 225, 234, 237, 239, 240,
             241, 250, 253, 255, 259, 265, 278, 282, 285, 315, 317, 324, 330,
             331, 334, 339, 344, 346, 349, 359, 367, 368, 374, 386, 387, 388,
             395, 397, 405, 430, 433, 439, 442, 448, 450, 457, 467, 473, 479,
             480, 486, 493, 497, 506, 514, 517, 522, 528, 535, 552, 554, 557,
             563, 570, 571, 576, 577, 579, 585, 593, 600, 601, 602, 605, 606
             )),
    ntcb=list(
      gaju=integer(0),
      ins=c(30, 42, 94, 95, 99, 108),
      albu=c(57, 76, 85, 98, 113, 114, 124, 147, 191, 192, 200, 223, 268,
             269, 276, 288, 301, 302, 312, 339, 383, 384, 392, 415, 460, 461,
             471, 484, 499, 500, 510, 537, 581, 582, 590)),
    pepsin1.3=list(
      gaju=integer(0),
      ins=c(2, 3, 4, 9, 11, 12, 13, 14, 15, 16, 24, 25, 29, 30, 34, 35,
            38, 39, 40, 41, 47, 49, 60, 61, 67, 68, 76, 79, 81, 82, 85, 86,
            101, 102, 103, 104, 105, 107, 108),
      albu=c(2, 3, 5, 6, 8, 9, 10, 11, 12, 13, 16, 17, 22, 37, 42, 43, 45,
             47, 48, 50, 51, 53, 54, 55, 59, 66, 72, 73, 89, 92, 94, 97, 98,
             103, 104, 108, 125, 126, 127, 136, 139, 150, 151, 157, 158, 159,
             161, 164, 173, 178, 179, 180, 181, 189, 201, 203, 206, 208, 209,
             222, 226, 227, 229, 230, 234, 237, 243, 247, 252, 257, 258, 261,
             262, 274, 275, 284, 286, 287, 298, 299, 306, 308, 326, 329, 332,
             333, 342, 350, 351, 353, 354, 355, 356, 357, 358, 365, 368, 369,
             370, 371, 373, 376, 380, 381, 394, 397, 400, 403, 410, 411, 417,
             418, 419, 421, 422, 424, 425, 426, 427, 430, 431, 432, 435, 447,
             453, 475, 476, 477, 480, 481, 483, 484, 486, 487, 504, 505, 512,
             514, 515, 520, 525, 530, 531, 532, 533, 539, 540, 552, 553, 555,
             556, 568, 574, 575, 577, 578, 591, 592, 598, 606, 607)),
    pepsin=list(
      gaju=integer(0),
      ins=c(2, 3, 9, 11, 12, 13, 14, 15, 16, 24, 25, 29, 30, 34, 35, 38, 39,
            40, 41, 47, 49, 60, 61, 67, 68, 76, 79, 81, 82, 85, 86, 101, 102,
            104, 105),
      albu=c(5, 6, 8, 9, 10, 11, 12, 13, 22, 37, 42, 43, 45, 47, 48, 50, 51,
             54, 55, 59, 66, 72, 73, 89, 92, 94, 97, 98, 103, 104, 125, 126,
             127, 136, 139, 150, 151, 157, 158, 159, 173, 178, 179, 180, 181,
             189, 201, 203, 206, 208, 209, 222, 226, 227, 229, 230, 234, 243,
             247, 252, 257, 258, 261, 262, 274, 275, 284, 298, 299, 306, 308,
             326, 329, 332, 333, 350, 351, 353, 354, 355, 368, 369, 370, 371,
             373, 380, 381, 397, 400, 403, 410, 411, 417, 418, 419, 421, 422,
             426, 427, 430, 431, 432, 447, 453, 476, 477, 480, 481, 483, 484,
             486, 487, 504, 505, 512, 514, 515, 525, 530, 531, 532, 533, 539,
             540, 552, 553, 555, 556, 568, 574, 575, 577, 578, 591, 592, 598,
             606, 607)),
    "proline endopeptidase"=list(
      gaju=integer(0),
      ins=integer(0),
      albu=c(142, 171, 306, 363, 403, 465, 510, 561)),
    "proteinase k"=list(
      gaju=c(1:3, 6:7),
      ins=c(2, 3, 4, 7, 8, 10, 11, 12, 13, 14, 15, 16, 17, 22, 23, 24,
            25, 26, 30, 35, 36, 37, 38, 39, 40, 41, 42, 45, 48, 49, 50, 51,
            54, 57, 58, 59, 61, 63, 66, 67, 68, 74, 77, 80, 81, 82, 83, 86,
            91, 92, 93, 97, 99, 102, 103, 105, 106, 108),
      albu=c(3, 4, 5, 6, 7, 9, 10, 11, 12, 13, 16, 17, 21, 22, 26, 30, 31,
             32, 35, 38, 40, 41, 43, 45, 46, 47, 48, 49, 50, 51, 52, 54, 55,
             60, 61, 64, 66, 67, 69, 70, 71, 72, 73, 74, 76, 78, 79, 81, 83,
             84, 90, 92, 93, 94, 98, 100, 101, 102, 103, 104, 106, 107, 108,
             110, 112, 116, 119, 121, 124, 126, 127, 136, 139, 140, 143, 144,
             146, 149, 150, 151, 155, 156, 157, 158, 159, 162, 163, 164, 165,
             166, 167, 172, 173, 174, 175, 177, 178, 179, 180, 181, 182, 185,
             187, 188, 189, 190, 191, 195, 196, 199, 200, 202, 203, 206, 208,
             209, 212, 215, 218, 222, 225, 227, 230, 232, 234, 235, 237, 238,
             239, 240, 241, 243, 247, 250, 251, 252, 253, 254, 255, 258, 259,
             260, 262, 263, 265, 267, 268, 274, 275, 276, 278, 282, 284, 285,
             287, 288, 290, 295, 299, 301, 304, 307, 308, 309, 314, 315, 316,
             317, 318, 321, 324, 326, 329, 330, 331, 333, 334, 335, 339, 343,
             344, 345, 346, 349, 350, 351, 354, 355, 356, 357, 358, 359, 365,
             367, 368, 369, 370, 371, 373, 374, 376, 377, 378, 379, 380, 381,
             382, 386, 387, 388, 392, 394, 395, 397, 398, 400, 401, 404, 405,
             406, 407, 411, 412, 417, 418, 419, 420, 422, 424, 425, 427, 430,
             431, 432, 433, 435, 436, 439, 442, 444, 446, 447, 448, 449, 450,
             454, 457, 466, 467, 473, 474, 476, 477, 479, 480, 481, 484, 486,
             487, 489, 491, 493, 497, 498, 502, 503, 505, 506, 512, 514, 515,
             516, 517, 519, 520, 521, 522, 525, 526, 528, 529, 530, 531, 532,
             533, 535, 537, 539, 540, 542, 544, 547, 551, 552, 553, 554, 555,
             556, 557, 563, 564, 566, 568, 570, 571, 575, 576, 577, 578, 579,
             580, 585, 589, 590, 592, 593, 594, 595, 599, 600, 601, 602, 605,
             606, 607)),
    "staphylococcal peptidase i"=list(
      gaju=7,
      ins=c(37, 45, 57, 59, 67, 83, 93, 106),
      albu=c(30, 40, 61, 69, 72, 81, 84, 106, 110, 119, 121, 124, 143, 155,
             165, 177, 191, 208, 212, 232, 251, 254, 268, 276, 290, 301, 304,
             309, 316, 318, 321, 335, 345, 357, 378, 382, 392, 400, 406, 417,
             420, 424, 449, 466, 474, 489, 503, 516, 519, 525, 529, 542, 544,
             555, 566, 580, 589, 594)),
    thermolysin=list(
      gaju=c(1:2, 5),
      ## pos 7 is missing in peptide cutter output
      ins=c(1, 2, 4, 6, 7, 9, 10, 11, 12, 13, 14, 15, 21, 22, 23, 24, 25,
            29, 34, 35, 38, 40, 41, 47, 48, 62, 65, 73, 76, 79, 80, 81, 85,
            90, 91, 98, 101, 104),
      ## pos 135 174 202 246 438 469 521 are missing in peptide cutter output
      albu=c(3, 5, 6, 8, 9, 10, 11, 12, 15, 20, 21, 31, 34, 42, 44, 45,
             46, 47, 48, 49, 50, 51, 54, 59, 63, 65, 66, 73, 77, 78, 82, 89,
             92, 93, 97, 100, 101, 103, 111, 115, 125, 126, 135, 138, 139, 146,
             149, 150, 157, 158, 162, 166, 172, 174, 178, 179, 180, 181, 186,
             187, 188, 194, 195, 198, 199, 201, 202, 205, 214, 217, 221, 224,
             226, 229, 233, 234, 236, 238, 239, 240, 242, 246, 249, 252, 257,
             258, 264, 274, 277, 281, 284, 287, 294, 298, 306, 307, 313, 314,
             323, 328, 329, 330, 333, 343, 349, 350, 352, 353, 354, 358, 366,
             367, 368, 369, 370, 372, 373, 380, 385, 386, 387, 394, 396, 397,
             403, 404, 410, 411, 418, 421, 426, 429, 430, 431, 432, 438, 441,
             446, 447, 453, 456, 469, 472, 476, 478, 479, 480, 483, 485, 486,
             492, 496, 504, 505, 511, 513, 514, 521, 527, 530, 532, 534, 539,
             546, 551, 552, 553, 556, 562, 567, 569, 570, 571, 575, 576, 577,
             578, 584, 591, 592, 598, 599, 600, 601, 604, 605, 606, 608)),
    thrombin=list(
      gaju=integer(0),
      ins=integer(0),
      albu=integer(0)),
    trypsin=list(
      gaju=5,
      ins=c(6, 46, 53, 55, 56, 88, 89),
      albu=c(2, 19, 23, 24, 28, 34, 36, 44, 65, 75, 88, 97, 105, 117, 122, 130,
             138, 160, 161, 168, 183, 184, 186, 198, 205, 210, 214, 219, 221,
             223, 229, 233, 236, 242, 246, 249, 257, 264, 281, 286, 298, 300,
             310, 337, 341, 347, 360, 372, 375, 383, 396, 413, 426, 434, 437,
             438, 452, 456, 460, 468, 469, 490, 496, 499, 508, 524, 543, 545,
             548, 549, 558, 562, 565, 569, 581, 584, 588, 597, 598)))

  for (i in seq(along=cleavageResults)) {
    enzyme <- names(cleavageResults)[i]
    expect_equal(cleaver:::.cleavePos(peptides, cleaver:::rules[enzyme],
                                      cleaver:::exceptions[enzyme]),
                 unname(cleavageResults[[i]]))

  }
})

