### R code from vignette source 'TFBSTools.Rnw'

###################################################
### code chunk number 1: initialize
###################################################
options(width=70)


###################################################
### code chunk number 2: rtl-PFMatrix
###################################################
library(TFBSTools)
pfm = PFMatrix(ID="MA0004.1", name="Arnt", matrixClass="Zipper-Type", strand="+",
        bg=c(A=0.25, C=0.25, G=0.25, T=0.25),
        tags=list(family="Helix-Loop-Helix", species="10090", tax_group="vertebrates",
        medline="7592839", type="SELEX", ACC="P53762", pazar_tf_id="TF0000003",
        TFBSshape_ID="11", TFencyclopedia_ID="580"),
        matrix=matrix(c(4L,  19L, 0L,  0L,  0L,  0L,
                16L, 0L,  20L, 0L,  0L,  0L,
                0L,  1L,  0L,  20L, 0L,  20L,
                0L,  0L,  0L,  0L,  20L, 0L),
                byrow=TRUE, nrow=4, dimnames=list(c("A", "C", "G", "T")))
        )
## coerced to matrix
as.matrix(pfm)
## get the reverse complment matrix with all the same information except the strand.
reverseComplement(pfm)
## access the slots of pfm
ID(pfm)
name(pfm)
Matrix(pfm)


###################################################
### code chunk number 3: rtl-PFMatrixList (eval = FALSE)
###################################################
## pfm2 = pfm
## PFMatrixList(pfm1=pfm, pfm2=pfm2, use.names=TRUE)


###################################################
### code chunk number 4: rtl-searchDB (eval = FALSE)
###################################################
## library(JASPAR2014)
## opts = list()
## opts[["species"]] = 9606
## opts[["name"]] = "RUNX1"
## #opts[["class"]] = "Ig-fold"
## opts[["type"]] = "SELEX"
## opts[["all_versions"]] = TRUE
## PFMatrixList = getMatrixSet(JASPAR2014, opts)
## 
## opts2 = list()
## opts2[["type"]] = "SELEX"
## PFMatrixList2 = getMatrixSet(JASPAR2014, opts2)


###################################################
### code chunk number 5: rtl-operateDb (eval = FALSE)
###################################################
## db = "jaspar.sqlite"
## initializeJASPARDB(db)
## storeMatrix(db, pfm)
## deleteMatrixHavingID(db, "MA0003")


###################################################
### code chunk number 6: session-info
###################################################
  sessionInfo()


